/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.apimanagement.models.ApiVersionSetEntityBase;
import com.azure.resourcemanager.apimanagement.models.VersioningScheme;
import java.io.IOException;

public final class ApiVersionSetContractProperties
extends ApiVersionSetEntityBase {
    private String displayName;
    private VersioningScheme versioningScheme;
    private static final ClientLogger LOGGER = new ClientLogger(ApiVersionSetContractProperties.class);

    public String displayName() {
        return this.displayName;
    }

    public ApiVersionSetContractProperties withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    public VersioningScheme versioningScheme() {
        return this.versioningScheme;
    }

    public ApiVersionSetContractProperties withVersioningScheme(VersioningScheme versioningScheme) {
        this.versioningScheme = versioningScheme;
        return this;
    }

    @Override
    public ApiVersionSetContractProperties withDescription(String description) {
        super.withDescription(description);
        return this;
    }

    @Override
    public ApiVersionSetContractProperties withVersionQueryName(String versionQueryName) {
        super.withVersionQueryName(versionQueryName);
        return this;
    }

    @Override
    public ApiVersionSetContractProperties withVersionHeaderName(String versionHeaderName) {
        super.withVersionHeaderName(versionHeaderName);
        return this;
    }

    @Override
    public void validate() {
        if (this.displayName() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property displayName in model ApiVersionSetContractProperties"));
        }
        if (this.versioningScheme() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property versioningScheme in model ApiVersionSetContractProperties"));
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("description", this.description());
        jsonWriter.writeStringField("versionQueryName", this.versionQueryName());
        jsonWriter.writeStringField("versionHeaderName", this.versionHeaderName());
        jsonWriter.writeStringField("displayName", this.displayName);
        jsonWriter.writeStringField("versioningScheme", this.versioningScheme == null ? null : this.versioningScheme.toString());
        return jsonWriter.writeEndObject();
    }

    public static ApiVersionSetContractProperties fromJson(JsonReader jsonReader) throws IOException {
        return (ApiVersionSetContractProperties)jsonReader.readObject(reader -> {
            ApiVersionSetContractProperties deserializedApiVersionSetContractProperties = new ApiVersionSetContractProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("description".equals(fieldName)) {
                    deserializedApiVersionSetContractProperties.withDescription(reader.getString());
                    continue;
                }
                if ("versionQueryName".equals(fieldName)) {
                    deserializedApiVersionSetContractProperties.withVersionQueryName(reader.getString());
                    continue;
                }
                if ("versionHeaderName".equals(fieldName)) {
                    deserializedApiVersionSetContractProperties.withVersionHeaderName(reader.getString());
                    continue;
                }
                if ("displayName".equals(fieldName)) {
                    deserializedApiVersionSetContractProperties.displayName = reader.getString();
                    continue;
                }
                if ("versioningScheme".equals(fieldName)) {
                    deserializedApiVersionSetContractProperties.versioningScheme = VersioningScheme.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedApiVersionSetContractProperties;
        });
    }
}

