/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.apimanagement.models.KeyVaultContractProperties;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public final class CertificateContractProperties
implements JsonSerializable<CertificateContractProperties> {
    private String subject;
    private String thumbprint;
    private OffsetDateTime expirationDate;
    private KeyVaultContractProperties keyVault;
    private static final ClientLogger LOGGER = new ClientLogger(CertificateContractProperties.class);

    public String subject() {
        return this.subject;
    }

    public CertificateContractProperties withSubject(String subject) {
        this.subject = subject;
        return this;
    }

    public String thumbprint() {
        return this.thumbprint;
    }

    public CertificateContractProperties withThumbprint(String thumbprint) {
        this.thumbprint = thumbprint;
        return this;
    }

    public OffsetDateTime expirationDate() {
        return this.expirationDate;
    }

    public CertificateContractProperties withExpirationDate(OffsetDateTime expirationDate) {
        this.expirationDate = expirationDate;
        return this;
    }

    public KeyVaultContractProperties keyVault() {
        return this.keyVault;
    }

    public CertificateContractProperties withKeyVault(KeyVaultContractProperties keyVault) {
        this.keyVault = keyVault;
        return this;
    }

    public void validate() {
        if (this.subject() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property subject in model CertificateContractProperties"));
        }
        if (this.thumbprint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property thumbprint in model CertificateContractProperties"));
        }
        if (this.expirationDate() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property expirationDate in model CertificateContractProperties"));
        }
        if (this.keyVault() != null) {
            this.keyVault().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("subject", this.subject);
        jsonWriter.writeStringField("thumbprint", this.thumbprint);
        jsonWriter.writeStringField("expirationDate", this.expirationDate == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.expirationDate));
        jsonWriter.writeJsonField("keyVault", (JsonSerializable)this.keyVault);
        return jsonWriter.writeEndObject();
    }

    public static CertificateContractProperties fromJson(JsonReader jsonReader) throws IOException {
        return (CertificateContractProperties)jsonReader.readObject(reader -> {
            CertificateContractProperties deserializedCertificateContractProperties = new CertificateContractProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("subject".equals(fieldName)) {
                    deserializedCertificateContractProperties.subject = reader.getString();
                    continue;
                }
                if ("thumbprint".equals(fieldName)) {
                    deserializedCertificateContractProperties.thumbprint = reader.getString();
                    continue;
                }
                if ("expirationDate".equals(fieldName)) {
                    deserializedCertificateContractProperties.expirationDate = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("keyVault".equals(fieldName)) {
                    deserializedCertificateContractProperties.keyVault = KeyVaultContractProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCertificateContractProperties;
        });
    }
}

