/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.apimanagement.models.SchemaType;
import java.io.IOException;

public final class GlobalSchemaContractProperties
implements JsonSerializable<GlobalSchemaContractProperties> {
    private SchemaType schemaType;
    private String description;
    private Object value;
    private Object document;
    private static final ClientLogger LOGGER = new ClientLogger(GlobalSchemaContractProperties.class);

    public SchemaType schemaType() {
        return this.schemaType;
    }

    public GlobalSchemaContractProperties withSchemaType(SchemaType schemaType) {
        this.schemaType = schemaType;
        return this;
    }

    public String description() {
        return this.description;
    }

    public GlobalSchemaContractProperties withDescription(String description) {
        this.description = description;
        return this;
    }

    public Object value() {
        return this.value;
    }

    public GlobalSchemaContractProperties withValue(Object value) {
        this.value = value;
        return this;
    }

    public Object document() {
        return this.document;
    }

    public GlobalSchemaContractProperties withDocument(Object document) {
        this.document = document;
        return this;
    }

    public void validate() {
        if (this.schemaType() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property schemaType in model GlobalSchemaContractProperties"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("schemaType", this.schemaType == null ? null : this.schemaType.toString());
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeUntypedField("value", this.value);
        jsonWriter.writeUntypedField("document", this.document);
        return jsonWriter.writeEndObject();
    }

    public static GlobalSchemaContractProperties fromJson(JsonReader jsonReader) throws IOException {
        return (GlobalSchemaContractProperties)jsonReader.readObject(reader -> {
            GlobalSchemaContractProperties deserializedGlobalSchemaContractProperties = new GlobalSchemaContractProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("schemaType".equals(fieldName)) {
                    deserializedGlobalSchemaContractProperties.schemaType = SchemaType.fromString(reader.getString());
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedGlobalSchemaContractProperties.description = reader.getString();
                    continue;
                }
                if ("value".equals(fieldName)) {
                    deserializedGlobalSchemaContractProperties.value = reader.readUntyped();
                    continue;
                }
                if ("document".equals(fieldName)) {
                    deserializedGlobalSchemaContractProperties.document = reader.readUntyped();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedGlobalSchemaContractProperties;
        });
    }
}

