/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.apimanagement.models.IdentityProviderBaseParameters;
import com.azure.resourcemanager.apimanagement.models.IdentityProviderType;
import java.io.IOException;
import java.util.List;

public final class IdentityProviderCreateContractProperties
extends IdentityProviderBaseParameters {
    private String clientId;
    private String clientSecret;
    private static final ClientLogger LOGGER = new ClientLogger(IdentityProviderCreateContractProperties.class);

    public String clientId() {
        return this.clientId;
    }

    public IdentityProviderCreateContractProperties withClientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    public String clientSecret() {
        return this.clientSecret;
    }

    public IdentityProviderCreateContractProperties withClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
        return this;
    }

    @Override
    public IdentityProviderCreateContractProperties withType(IdentityProviderType type) {
        super.withType(type);
        return this;
    }

    @Override
    public IdentityProviderCreateContractProperties withSigninTenant(String signinTenant) {
        super.withSigninTenant(signinTenant);
        return this;
    }

    @Override
    public IdentityProviderCreateContractProperties withAllowedTenants(List<String> allowedTenants) {
        super.withAllowedTenants(allowedTenants);
        return this;
    }

    @Override
    public IdentityProviderCreateContractProperties withAuthority(String authority) {
        super.withAuthority(authority);
        return this;
    }

    @Override
    public IdentityProviderCreateContractProperties withSignupPolicyName(String signupPolicyName) {
        super.withSignupPolicyName(signupPolicyName);
        return this;
    }

    @Override
    public IdentityProviderCreateContractProperties withSigninPolicyName(String signinPolicyName) {
        super.withSigninPolicyName(signinPolicyName);
        return this;
    }

    @Override
    public IdentityProviderCreateContractProperties withProfileEditingPolicyName(String profileEditingPolicyName) {
        super.withProfileEditingPolicyName(profileEditingPolicyName);
        return this;
    }

    @Override
    public IdentityProviderCreateContractProperties withPasswordResetPolicyName(String passwordResetPolicyName) {
        super.withPasswordResetPolicyName(passwordResetPolicyName);
        return this;
    }

    @Override
    public IdentityProviderCreateContractProperties withClientLibrary(String clientLibrary) {
        super.withClientLibrary(clientLibrary);
        return this;
    }

    @Override
    public void validate() {
        if (this.clientId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property clientId in model IdentityProviderCreateContractProperties"));
        }
        if (this.clientSecret() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property clientSecret in model IdentityProviderCreateContractProperties"));
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type() == null ? null : this.type().toString());
        jsonWriter.writeStringField("signinTenant", this.signinTenant());
        jsonWriter.writeArrayField("allowedTenants", this.allowedTenants(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("authority", this.authority());
        jsonWriter.writeStringField("signupPolicyName", this.signupPolicyName());
        jsonWriter.writeStringField("signinPolicyName", this.signinPolicyName());
        jsonWriter.writeStringField("profileEditingPolicyName", this.profileEditingPolicyName());
        jsonWriter.writeStringField("passwordResetPolicyName", this.passwordResetPolicyName());
        jsonWriter.writeStringField("clientLibrary", this.clientLibrary());
        jsonWriter.writeStringField("clientId", this.clientId);
        jsonWriter.writeStringField("clientSecret", this.clientSecret);
        return jsonWriter.writeEndObject();
    }

    public static IdentityProviderCreateContractProperties fromJson(JsonReader jsonReader) throws IOException {
        return (IdentityProviderCreateContractProperties)jsonReader.readObject(reader -> {
            IdentityProviderCreateContractProperties deserializedIdentityProviderCreateContractProperties = new IdentityProviderCreateContractProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("type".equals(fieldName)) {
                    deserializedIdentityProviderCreateContractProperties.withType(IdentityProviderType.fromString(reader.getString()));
                    continue;
                }
                if ("signinTenant".equals(fieldName)) {
                    deserializedIdentityProviderCreateContractProperties.withSigninTenant(reader.getString());
                    continue;
                }
                if ("allowedTenants".equals(fieldName)) {
                    List allowedTenants = reader.readArray(reader1 -> reader1.getString());
                    deserializedIdentityProviderCreateContractProperties.withAllowedTenants(allowedTenants);
                    continue;
                }
                if ("authority".equals(fieldName)) {
                    deserializedIdentityProviderCreateContractProperties.withAuthority(reader.getString());
                    continue;
                }
                if ("signupPolicyName".equals(fieldName)) {
                    deserializedIdentityProviderCreateContractProperties.withSignupPolicyName(reader.getString());
                    continue;
                }
                if ("signinPolicyName".equals(fieldName)) {
                    deserializedIdentityProviderCreateContractProperties.withSigninPolicyName(reader.getString());
                    continue;
                }
                if ("profileEditingPolicyName".equals(fieldName)) {
                    deserializedIdentityProviderCreateContractProperties.withProfileEditingPolicyName(reader.getString());
                    continue;
                }
                if ("passwordResetPolicyName".equals(fieldName)) {
                    deserializedIdentityProviderCreateContractProperties.withPasswordResetPolicyName(reader.getString());
                    continue;
                }
                if ("clientLibrary".equals(fieldName)) {
                    deserializedIdentityProviderCreateContractProperties.withClientLibrary(reader.getString());
                    continue;
                }
                if ("clientId".equals(fieldName)) {
                    deserializedIdentityProviderCreateContractProperties.clientId = reader.getString();
                    continue;
                }
                if ("clientSecret".equals(fieldName)) {
                    deserializedIdentityProviderCreateContractProperties.clientSecret = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedIdentityProviderCreateContractProperties;
        });
    }
}

