/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.apimanagement.models.IdentityProviderBaseParameters;
import com.azure.resourcemanager.apimanagement.models.IdentityProviderType;
import java.io.IOException;
import java.util.List;

public final class IdentityProviderUpdateProperties
extends IdentityProviderBaseParameters {
    private String clientId;
    private String clientSecret;

    public String clientId() {
        return this.clientId;
    }

    public IdentityProviderUpdateProperties withClientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    public String clientSecret() {
        return this.clientSecret;
    }

    public IdentityProviderUpdateProperties withClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
        return this;
    }

    @Override
    public IdentityProviderUpdateProperties withType(IdentityProviderType type) {
        super.withType(type);
        return this;
    }

    @Override
    public IdentityProviderUpdateProperties withSigninTenant(String signinTenant) {
        super.withSigninTenant(signinTenant);
        return this;
    }

    @Override
    public IdentityProviderUpdateProperties withAllowedTenants(List<String> allowedTenants) {
        super.withAllowedTenants(allowedTenants);
        return this;
    }

    @Override
    public IdentityProviderUpdateProperties withAuthority(String authority) {
        super.withAuthority(authority);
        return this;
    }

    @Override
    public IdentityProviderUpdateProperties withSignupPolicyName(String signupPolicyName) {
        super.withSignupPolicyName(signupPolicyName);
        return this;
    }

    @Override
    public IdentityProviderUpdateProperties withSigninPolicyName(String signinPolicyName) {
        super.withSigninPolicyName(signinPolicyName);
        return this;
    }

    @Override
    public IdentityProviderUpdateProperties withProfileEditingPolicyName(String profileEditingPolicyName) {
        super.withProfileEditingPolicyName(profileEditingPolicyName);
        return this;
    }

    @Override
    public IdentityProviderUpdateProperties withPasswordResetPolicyName(String passwordResetPolicyName) {
        super.withPasswordResetPolicyName(passwordResetPolicyName);
        return this;
    }

    @Override
    public IdentityProviderUpdateProperties withClientLibrary(String clientLibrary) {
        super.withClientLibrary(clientLibrary);
        return this;
    }

    @Override
    public void validate() {
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type() == null ? null : this.type().toString());
        jsonWriter.writeStringField("signinTenant", this.signinTenant());
        jsonWriter.writeArrayField("allowedTenants", this.allowedTenants(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("authority", this.authority());
        jsonWriter.writeStringField("signupPolicyName", this.signupPolicyName());
        jsonWriter.writeStringField("signinPolicyName", this.signinPolicyName());
        jsonWriter.writeStringField("profileEditingPolicyName", this.profileEditingPolicyName());
        jsonWriter.writeStringField("passwordResetPolicyName", this.passwordResetPolicyName());
        jsonWriter.writeStringField("clientLibrary", this.clientLibrary());
        jsonWriter.writeStringField("clientId", this.clientId);
        jsonWriter.writeStringField("clientSecret", this.clientSecret);
        return jsonWriter.writeEndObject();
    }

    public static IdentityProviderUpdateProperties fromJson(JsonReader jsonReader) throws IOException {
        return (IdentityProviderUpdateProperties)jsonReader.readObject(reader -> {
            IdentityProviderUpdateProperties deserializedIdentityProviderUpdateProperties = new IdentityProviderUpdateProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("type".equals(fieldName)) {
                    deserializedIdentityProviderUpdateProperties.withType(IdentityProviderType.fromString(reader.getString()));
                    continue;
                }
                if ("signinTenant".equals(fieldName)) {
                    deserializedIdentityProviderUpdateProperties.withSigninTenant(reader.getString());
                    continue;
                }
                if ("allowedTenants".equals(fieldName)) {
                    List allowedTenants = reader.readArray(reader1 -> reader1.getString());
                    deserializedIdentityProviderUpdateProperties.withAllowedTenants(allowedTenants);
                    continue;
                }
                if ("authority".equals(fieldName)) {
                    deserializedIdentityProviderUpdateProperties.withAuthority(reader.getString());
                    continue;
                }
                if ("signupPolicyName".equals(fieldName)) {
                    deserializedIdentityProviderUpdateProperties.withSignupPolicyName(reader.getString());
                    continue;
                }
                if ("signinPolicyName".equals(fieldName)) {
                    deserializedIdentityProviderUpdateProperties.withSigninPolicyName(reader.getString());
                    continue;
                }
                if ("profileEditingPolicyName".equals(fieldName)) {
                    deserializedIdentityProviderUpdateProperties.withProfileEditingPolicyName(reader.getString());
                    continue;
                }
                if ("passwordResetPolicyName".equals(fieldName)) {
                    deserializedIdentityProviderUpdateProperties.withPasswordResetPolicyName(reader.getString());
                    continue;
                }
                if ("clientLibrary".equals(fieldName)) {
                    deserializedIdentityProviderUpdateProperties.withClientLibrary(reader.getString());
                    continue;
                }
                if ("clientId".equals(fieldName)) {
                    deserializedIdentityProviderUpdateProperties.clientId = reader.getString();
                    continue;
                }
                if ("clientSecret".equals(fieldName)) {
                    deserializedIdentityProviderUpdateProperties.clientSecret = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedIdentityProviderUpdateProperties;
        });
    }
}

