/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.apimanagement.models.LoggerType;
import java.io.IOException;
import java.util.Map;

public final class LoggerContractProperties
implements JsonSerializable<LoggerContractProperties> {
    private LoggerType loggerType;
    private String description;
    private Map<String, String> credentials;
    private Boolean isBuffered;
    private String resourceId;
    private static final ClientLogger LOGGER = new ClientLogger(LoggerContractProperties.class);

    public LoggerType loggerType() {
        return this.loggerType;
    }

    public LoggerContractProperties withLoggerType(LoggerType loggerType) {
        this.loggerType = loggerType;
        return this;
    }

    public String description() {
        return this.description;
    }

    public LoggerContractProperties withDescription(String description) {
        this.description = description;
        return this;
    }

    public Map<String, String> credentials() {
        return this.credentials;
    }

    public LoggerContractProperties withCredentials(Map<String, String> credentials) {
        this.credentials = credentials;
        return this;
    }

    public Boolean isBuffered() {
        return this.isBuffered;
    }

    public LoggerContractProperties withIsBuffered(Boolean isBuffered) {
        this.isBuffered = isBuffered;
        return this;
    }

    public String resourceId() {
        return this.resourceId;
    }

    public LoggerContractProperties withResourceId(String resourceId) {
        this.resourceId = resourceId;
        return this;
    }

    public void validate() {
        if (this.loggerType() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property loggerType in model LoggerContractProperties"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("loggerType", this.loggerType == null ? null : this.loggerType.toString());
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeMapField("credentials", this.credentials, (writer, element) -> writer.writeString(element));
        jsonWriter.writeBooleanField("isBuffered", this.isBuffered);
        jsonWriter.writeStringField("resourceId", this.resourceId);
        return jsonWriter.writeEndObject();
    }

    public static LoggerContractProperties fromJson(JsonReader jsonReader) throws IOException {
        return (LoggerContractProperties)jsonReader.readObject(reader -> {
            LoggerContractProperties deserializedLoggerContractProperties = new LoggerContractProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("loggerType".equals(fieldName)) {
                    deserializedLoggerContractProperties.loggerType = LoggerType.fromString(reader.getString());
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedLoggerContractProperties.description = reader.getString();
                    continue;
                }
                if ("credentials".equals(fieldName)) {
                    Map credentials;
                    deserializedLoggerContractProperties.credentials = credentials = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                if ("isBuffered".equals(fieldName)) {
                    deserializedLoggerContractProperties.isBuffered = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("resourceId".equals(fieldName)) {
                    deserializedLoggerContractProperties.resourceId = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedLoggerContractProperties;
        });
    }
}

