/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.apimanagement.models.KeyVaultContractProperties;
import com.azure.resourcemanager.apimanagement.models.NamedValueEntityBaseParameters;
import java.io.IOException;
import java.util.List;

public final class NamedValueContractProperties
extends NamedValueEntityBaseParameters {
    private String displayName;
    private String value;
    private KeyVaultContractProperties keyVault;
    private static final ClientLogger LOGGER = new ClientLogger(NamedValueContractProperties.class);

    public String displayName() {
        return this.displayName;
    }

    public NamedValueContractProperties withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    public String value() {
        return this.value;
    }

    public NamedValueContractProperties withValue(String value) {
        this.value = value;
        return this;
    }

    public KeyVaultContractProperties keyVault() {
        return this.keyVault;
    }

    public NamedValueContractProperties withKeyVault(KeyVaultContractProperties keyVault) {
        this.keyVault = keyVault;
        return this;
    }

    @Override
    public NamedValueContractProperties withTags(List<String> tags) {
        super.withTags(tags);
        return this;
    }

    @Override
    public NamedValueContractProperties withSecret(Boolean secret) {
        super.withSecret(secret);
        return this;
    }

    @Override
    public void validate() {
        if (this.displayName() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property displayName in model NamedValueContractProperties"));
        }
        if (this.keyVault() != null) {
            this.keyVault().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeBooleanField("secret", this.secret());
        jsonWriter.writeStringField("displayName", this.displayName);
        jsonWriter.writeStringField("value", this.value);
        jsonWriter.writeJsonField("keyVault", (JsonSerializable)this.keyVault);
        return jsonWriter.writeEndObject();
    }

    public static NamedValueContractProperties fromJson(JsonReader jsonReader) throws IOException {
        return (NamedValueContractProperties)jsonReader.readObject(reader -> {
            NamedValueContractProperties deserializedNamedValueContractProperties = new NamedValueContractProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("tags".equals(fieldName)) {
                    List tags = reader.readArray(reader1 -> reader1.getString());
                    deserializedNamedValueContractProperties.withTags(tags);
                    continue;
                }
                if ("secret".equals(fieldName)) {
                    deserializedNamedValueContractProperties.withSecret((Boolean)reader.getNullable(JsonReader::getBoolean));
                    continue;
                }
                if ("displayName".equals(fieldName)) {
                    deserializedNamedValueContractProperties.displayName = reader.getString();
                    continue;
                }
                if ("value".equals(fieldName)) {
                    deserializedNamedValueContractProperties.value = reader.getString();
                    continue;
                }
                if ("keyVault".equals(fieldName)) {
                    deserializedNamedValueContractProperties.keyVault = KeyVaultContractProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedNamedValueContractProperties;
        });
    }
}

