/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.apimanagement.models.KeyVaultContractCreateProperties;
import com.azure.resourcemanager.apimanagement.models.NamedValueEntityBaseParameters;
import java.io.IOException;
import java.util.List;

public final class NamedValueCreateContractProperties
extends NamedValueEntityBaseParameters {
    private String displayName;
    private String value;
    private KeyVaultContractCreateProperties keyVault;
    private static final ClientLogger LOGGER = new ClientLogger(NamedValueCreateContractProperties.class);

    public String displayName() {
        return this.displayName;
    }

    public NamedValueCreateContractProperties withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    public String value() {
        return this.value;
    }

    public NamedValueCreateContractProperties withValue(String value) {
        this.value = value;
        return this;
    }

    public KeyVaultContractCreateProperties keyVault() {
        return this.keyVault;
    }

    public NamedValueCreateContractProperties withKeyVault(KeyVaultContractCreateProperties keyVault) {
        this.keyVault = keyVault;
        return this;
    }

    @Override
    public NamedValueCreateContractProperties withTags(List<String> tags) {
        super.withTags(tags);
        return this;
    }

    @Override
    public NamedValueCreateContractProperties withSecret(Boolean secret) {
        super.withSecret(secret);
        return this;
    }

    @Override
    public void validate() {
        if (this.displayName() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property displayName in model NamedValueCreateContractProperties"));
        }
        if (this.keyVault() != null) {
            this.keyVault().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeBooleanField("secret", this.secret());
        jsonWriter.writeStringField("displayName", this.displayName);
        jsonWriter.writeStringField("value", this.value);
        jsonWriter.writeJsonField("keyVault", (JsonSerializable)this.keyVault);
        return jsonWriter.writeEndObject();
    }

    public static NamedValueCreateContractProperties fromJson(JsonReader jsonReader) throws IOException {
        return (NamedValueCreateContractProperties)jsonReader.readObject(reader -> {
            NamedValueCreateContractProperties deserializedNamedValueCreateContractProperties = new NamedValueCreateContractProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("tags".equals(fieldName)) {
                    List tags = reader.readArray(reader1 -> reader1.getString());
                    deserializedNamedValueCreateContractProperties.withTags(tags);
                    continue;
                }
                if ("secret".equals(fieldName)) {
                    deserializedNamedValueCreateContractProperties.withSecret((Boolean)reader.getNullable(JsonReader::getBoolean));
                    continue;
                }
                if ("displayName".equals(fieldName)) {
                    deserializedNamedValueCreateContractProperties.displayName = reader.getString();
                    continue;
                }
                if ("value".equals(fieldName)) {
                    deserializedNamedValueCreateContractProperties.value = reader.getString();
                    continue;
                }
                if ("keyVault".equals(fieldName)) {
                    deserializedNamedValueCreateContractProperties.keyVault = KeyVaultContractCreateProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedNamedValueCreateContractProperties;
        });
    }
}

