/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.apimanagement.models.ConnectivityStatusContract;
import java.io.IOException;
import java.util.List;

public final class NetworkStatusContractInner
implements JsonSerializable<NetworkStatusContractInner> {
    private List<String> dnsServers;
    private List<ConnectivityStatusContract> connectivityStatus;
    private static final ClientLogger LOGGER = new ClientLogger(NetworkStatusContractInner.class);

    public List<String> dnsServers() {
        return this.dnsServers;
    }

    public NetworkStatusContractInner withDnsServers(List<String> dnsServers) {
        this.dnsServers = dnsServers;
        return this;
    }

    public List<ConnectivityStatusContract> connectivityStatus() {
        return this.connectivityStatus;
    }

    public NetworkStatusContractInner withConnectivityStatus(List<ConnectivityStatusContract> connectivityStatus) {
        this.connectivityStatus = connectivityStatus;
        return this;
    }

    public void validate() {
        if (this.dnsServers() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property dnsServers in model NetworkStatusContractInner"));
        }
        if (this.connectivityStatus() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property connectivityStatus in model NetworkStatusContractInner"));
        }
        this.connectivityStatus().forEach(e -> e.validate());
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("dnsServers", this.dnsServers, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("connectivityStatus", this.connectivityStatus, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static NetworkStatusContractInner fromJson(JsonReader jsonReader) throws IOException {
        return (NetworkStatusContractInner)jsonReader.readObject(reader -> {
            NetworkStatusContractInner deserializedNetworkStatusContractInner = new NetworkStatusContractInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("dnsServers".equals(fieldName)) {
                    List dnsServers;
                    deserializedNetworkStatusContractInner.dnsServers = dnsServers = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("connectivityStatus".equals(fieldName)) {
                    List connectivityStatus;
                    deserializedNetworkStatusContractInner.connectivityStatus = connectivityStatus = reader.readArray(reader1 -> ConnectivityStatusContract.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedNetworkStatusContractInner;
        });
    }
}

