/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.apimanagement.models.RecipientsContractProperties;
import java.io.IOException;

public final class NotificationContractProperties
implements JsonSerializable<NotificationContractProperties> {
    private String title;
    private String description;
    private RecipientsContractProperties recipients;
    private static final ClientLogger LOGGER = new ClientLogger(NotificationContractProperties.class);

    public String title() {
        return this.title;
    }

    public NotificationContractProperties withTitle(String title) {
        this.title = title;
        return this;
    }

    public String description() {
        return this.description;
    }

    public NotificationContractProperties withDescription(String description) {
        this.description = description;
        return this;
    }

    public RecipientsContractProperties recipients() {
        return this.recipients;
    }

    public NotificationContractProperties withRecipients(RecipientsContractProperties recipients) {
        this.recipients = recipients;
        return this;
    }

    public void validate() {
        if (this.title() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property title in model NotificationContractProperties"));
        }
        if (this.recipients() != null) {
            this.recipients().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("title", this.title);
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeJsonField("recipients", (JsonSerializable)this.recipients);
        return jsonWriter.writeEndObject();
    }

    public static NotificationContractProperties fromJson(JsonReader jsonReader) throws IOException {
        return (NotificationContractProperties)jsonReader.readObject(reader -> {
            NotificationContractProperties deserializedNotificationContractProperties = new NotificationContractProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("title".equals(fieldName)) {
                    deserializedNotificationContractProperties.title = reader.getString();
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedNotificationContractProperties.description = reader.getString();
                    continue;
                }
                if ("recipients".equals(fieldName)) {
                    deserializedNotificationContractProperties.recipients = RecipientsContractProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedNotificationContractProperties;
        });
    }
}

