/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.apimanagement.models.RegistrationDelegationSettingsProperties;
import com.azure.resourcemanager.apimanagement.models.SubscriptionsDelegationSettingsProperties;
import java.io.IOException;

public final class PortalDelegationSettingsProperties
implements JsonSerializable<PortalDelegationSettingsProperties> {
    private String url;
    private String validationKey;
    private SubscriptionsDelegationSettingsProperties subscriptions;
    private RegistrationDelegationSettingsProperties userRegistration;

    public String url() {
        return this.url;
    }

    public PortalDelegationSettingsProperties withUrl(String url) {
        this.url = url;
        return this;
    }

    public String validationKey() {
        return this.validationKey;
    }

    public PortalDelegationSettingsProperties withValidationKey(String validationKey) {
        this.validationKey = validationKey;
        return this;
    }

    public SubscriptionsDelegationSettingsProperties subscriptions() {
        return this.subscriptions;
    }

    public PortalDelegationSettingsProperties withSubscriptions(SubscriptionsDelegationSettingsProperties subscriptions) {
        this.subscriptions = subscriptions;
        return this;
    }

    public RegistrationDelegationSettingsProperties userRegistration() {
        return this.userRegistration;
    }

    public PortalDelegationSettingsProperties withUserRegistration(RegistrationDelegationSettingsProperties userRegistration) {
        this.userRegistration = userRegistration;
        return this;
    }

    public void validate() {
        if (this.subscriptions() != null) {
            this.subscriptions().validate();
        }
        if (this.userRegistration() != null) {
            this.userRegistration().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("url", this.url);
        jsonWriter.writeStringField("validationKey", this.validationKey);
        jsonWriter.writeJsonField("subscriptions", (JsonSerializable)this.subscriptions);
        jsonWriter.writeJsonField("userRegistration", (JsonSerializable)this.userRegistration);
        return jsonWriter.writeEndObject();
    }

    public static PortalDelegationSettingsProperties fromJson(JsonReader jsonReader) throws IOException {
        return (PortalDelegationSettingsProperties)jsonReader.readObject(reader -> {
            PortalDelegationSettingsProperties deserializedPortalDelegationSettingsProperties = new PortalDelegationSettingsProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("url".equals(fieldName)) {
                    deserializedPortalDelegationSettingsProperties.url = reader.getString();
                    continue;
                }
                if ("validationKey".equals(fieldName)) {
                    deserializedPortalDelegationSettingsProperties.validationKey = reader.getString();
                    continue;
                }
                if ("subscriptions".equals(fieldName)) {
                    deserializedPortalDelegationSettingsProperties.subscriptions = SubscriptionsDelegationSettingsProperties.fromJson(reader);
                    continue;
                }
                if ("userRegistration".equals(fieldName)) {
                    deserializedPortalDelegationSettingsProperties.userRegistration = RegistrationDelegationSettingsProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedPortalDelegationSettingsProperties;
        });
    }
}

