/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.apimanagement.models.PortalRevisionStatus;
import java.io.IOException;
import java.time.OffsetDateTime;

public final class PortalRevisionContractProperties
implements JsonSerializable<PortalRevisionContractProperties> {
    private String description;
    private String statusDetails;
    private PortalRevisionStatus status;
    private Boolean isCurrent;
    private OffsetDateTime createdDateTime;
    private OffsetDateTime updatedDateTime;

    public String description() {
        return this.description;
    }

    public PortalRevisionContractProperties withDescription(String description) {
        this.description = description;
        return this;
    }

    public String statusDetails() {
        return this.statusDetails;
    }

    public PortalRevisionStatus status() {
        return this.status;
    }

    public Boolean isCurrent() {
        return this.isCurrent;
    }

    public PortalRevisionContractProperties withIsCurrent(Boolean isCurrent) {
        this.isCurrent = isCurrent;
        return this;
    }

    public OffsetDateTime createdDateTime() {
        return this.createdDateTime;
    }

    public OffsetDateTime updatedDateTime() {
        return this.updatedDateTime;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeBooleanField("isCurrent", this.isCurrent);
        return jsonWriter.writeEndObject();
    }

    public static PortalRevisionContractProperties fromJson(JsonReader jsonReader) throws IOException {
        return (PortalRevisionContractProperties)jsonReader.readObject(reader -> {
            PortalRevisionContractProperties deserializedPortalRevisionContractProperties = new PortalRevisionContractProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("description".equals(fieldName)) {
                    deserializedPortalRevisionContractProperties.description = reader.getString();
                    continue;
                }
                if ("statusDetails".equals(fieldName)) {
                    deserializedPortalRevisionContractProperties.statusDetails = reader.getString();
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedPortalRevisionContractProperties.status = PortalRevisionStatus.fromString(reader.getString());
                    continue;
                }
                if ("isCurrent".equals(fieldName)) {
                    deserializedPortalRevisionContractProperties.isCurrent = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("createdDateTime".equals(fieldName)) {
                    deserializedPortalRevisionContractProperties.createdDateTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("updatedDateTime".equals(fieldName)) {
                    deserializedPortalRevisionContractProperties.updatedDateTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedPortalRevisionContractProperties;
        });
    }
}

