/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.apimanagement.models.ProductEntityBaseParameters;
import com.azure.resourcemanager.apimanagement.models.ProductState;
import java.io.IOException;

public final class ProductUpdateProperties
extends ProductEntityBaseParameters {
    private String displayName;

    public String displayName() {
        return this.displayName;
    }

    public ProductUpdateProperties withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @Override
    public ProductUpdateProperties withDescription(String description) {
        super.withDescription(description);
        return this;
    }

    @Override
    public ProductUpdateProperties withTerms(String terms) {
        super.withTerms(terms);
        return this;
    }

    @Override
    public ProductUpdateProperties withSubscriptionRequired(Boolean subscriptionRequired) {
        super.withSubscriptionRequired(subscriptionRequired);
        return this;
    }

    @Override
    public ProductUpdateProperties withApprovalRequired(Boolean approvalRequired) {
        super.withApprovalRequired(approvalRequired);
        return this;
    }

    @Override
    public ProductUpdateProperties withSubscriptionsLimit(Integer subscriptionsLimit) {
        super.withSubscriptionsLimit(subscriptionsLimit);
        return this;
    }

    @Override
    public ProductUpdateProperties withState(ProductState state) {
        super.withState(state);
        return this;
    }

    @Override
    public void validate() {
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("description", this.description());
        jsonWriter.writeStringField("terms", this.terms());
        jsonWriter.writeBooleanField("subscriptionRequired", this.subscriptionRequired());
        jsonWriter.writeBooleanField("approvalRequired", this.approvalRequired());
        jsonWriter.writeNumberField("subscriptionsLimit", (Number)this.subscriptionsLimit());
        jsonWriter.writeStringField("state", this.state() == null ? null : this.state().toString());
        jsonWriter.writeStringField("displayName", this.displayName);
        return jsonWriter.writeEndObject();
    }

    public static ProductUpdateProperties fromJson(JsonReader jsonReader) throws IOException {
        return (ProductUpdateProperties)jsonReader.readObject(reader -> {
            ProductUpdateProperties deserializedProductUpdateProperties = new ProductUpdateProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("description".equals(fieldName)) {
                    deserializedProductUpdateProperties.withDescription(reader.getString());
                    continue;
                }
                if ("terms".equals(fieldName)) {
                    deserializedProductUpdateProperties.withTerms(reader.getString());
                    continue;
                }
                if ("subscriptionRequired".equals(fieldName)) {
                    deserializedProductUpdateProperties.withSubscriptionRequired((Boolean)reader.getNullable(JsonReader::getBoolean));
                    continue;
                }
                if ("approvalRequired".equals(fieldName)) {
                    deserializedProductUpdateProperties.withApprovalRequired((Boolean)reader.getNullable(JsonReader::getBoolean));
                    continue;
                }
                if ("subscriptionsLimit".equals(fieldName)) {
                    deserializedProductUpdateProperties.withSubscriptionsLimit((Integer)reader.getNullable(JsonReader::getInt));
                    continue;
                }
                if ("state".equals(fieldName)) {
                    deserializedProductUpdateProperties.withState(ProductState.fromString(reader.getString()));
                    continue;
                }
                if ("displayName".equals(fieldName)) {
                    deserializedProductUpdateProperties.displayName = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedProductUpdateProperties;
        });
    }
}

