/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public final class ReportRecordContractInner
implements JsonSerializable<ReportRecordContractInner> {
    private String name;
    private OffsetDateTime timestamp;
    private String interval;
    private String country;
    private String region;
    private String zip;
    private String userId;
    private String productId;
    private String apiId;
    private String operationId;
    private String apiRegion;
    private String subscriptionId;
    private Integer callCountSuccess;
    private Integer callCountBlocked;
    private Integer callCountFailed;
    private Integer callCountOther;
    private Integer callCountTotal;
    private Long bandwidth;
    private Integer cacheHitCount;
    private Integer cacheMissCount;
    private Double apiTimeAvg;
    private Double apiTimeMin;
    private Double apiTimeMax;
    private Double serviceTimeAvg;
    private Double serviceTimeMin;
    private Double serviceTimeMax;

    public String name() {
        return this.name;
    }

    public ReportRecordContractInner withName(String name) {
        this.name = name;
        return this;
    }

    public OffsetDateTime timestamp() {
        return this.timestamp;
    }

    public ReportRecordContractInner withTimestamp(OffsetDateTime timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    public String interval() {
        return this.interval;
    }

    public ReportRecordContractInner withInterval(String interval) {
        this.interval = interval;
        return this;
    }

    public String country() {
        return this.country;
    }

    public ReportRecordContractInner withCountry(String country) {
        this.country = country;
        return this;
    }

    public String region() {
        return this.region;
    }

    public ReportRecordContractInner withRegion(String region) {
        this.region = region;
        return this;
    }

    public String zip() {
        return this.zip;
    }

    public ReportRecordContractInner withZip(String zip) {
        this.zip = zip;
        return this;
    }

    public String userId() {
        return this.userId;
    }

    public String productId() {
        return this.productId;
    }

    public String apiId() {
        return this.apiId;
    }

    public ReportRecordContractInner withApiId(String apiId) {
        this.apiId = apiId;
        return this;
    }

    public String operationId() {
        return this.operationId;
    }

    public ReportRecordContractInner withOperationId(String operationId) {
        this.operationId = operationId;
        return this;
    }

    public String apiRegion() {
        return this.apiRegion;
    }

    public ReportRecordContractInner withApiRegion(String apiRegion) {
        this.apiRegion = apiRegion;
        return this;
    }

    public String subscriptionId() {
        return this.subscriptionId;
    }

    public ReportRecordContractInner withSubscriptionId(String subscriptionId) {
        this.subscriptionId = subscriptionId;
        return this;
    }

    public Integer callCountSuccess() {
        return this.callCountSuccess;
    }

    public ReportRecordContractInner withCallCountSuccess(Integer callCountSuccess) {
        this.callCountSuccess = callCountSuccess;
        return this;
    }

    public Integer callCountBlocked() {
        return this.callCountBlocked;
    }

    public ReportRecordContractInner withCallCountBlocked(Integer callCountBlocked) {
        this.callCountBlocked = callCountBlocked;
        return this;
    }

    public Integer callCountFailed() {
        return this.callCountFailed;
    }

    public ReportRecordContractInner withCallCountFailed(Integer callCountFailed) {
        this.callCountFailed = callCountFailed;
        return this;
    }

    public Integer callCountOther() {
        return this.callCountOther;
    }

    public ReportRecordContractInner withCallCountOther(Integer callCountOther) {
        this.callCountOther = callCountOther;
        return this;
    }

    public Integer callCountTotal() {
        return this.callCountTotal;
    }

    public ReportRecordContractInner withCallCountTotal(Integer callCountTotal) {
        this.callCountTotal = callCountTotal;
        return this;
    }

    public Long bandwidth() {
        return this.bandwidth;
    }

    public ReportRecordContractInner withBandwidth(Long bandwidth) {
        this.bandwidth = bandwidth;
        return this;
    }

    public Integer cacheHitCount() {
        return this.cacheHitCount;
    }

    public ReportRecordContractInner withCacheHitCount(Integer cacheHitCount) {
        this.cacheHitCount = cacheHitCount;
        return this;
    }

    public Integer cacheMissCount() {
        return this.cacheMissCount;
    }

    public ReportRecordContractInner withCacheMissCount(Integer cacheMissCount) {
        this.cacheMissCount = cacheMissCount;
        return this;
    }

    public Double apiTimeAvg() {
        return this.apiTimeAvg;
    }

    public ReportRecordContractInner withApiTimeAvg(Double apiTimeAvg) {
        this.apiTimeAvg = apiTimeAvg;
        return this;
    }

    public Double apiTimeMin() {
        return this.apiTimeMin;
    }

    public ReportRecordContractInner withApiTimeMin(Double apiTimeMin) {
        this.apiTimeMin = apiTimeMin;
        return this;
    }

    public Double apiTimeMax() {
        return this.apiTimeMax;
    }

    public ReportRecordContractInner withApiTimeMax(Double apiTimeMax) {
        this.apiTimeMax = apiTimeMax;
        return this;
    }

    public Double serviceTimeAvg() {
        return this.serviceTimeAvg;
    }

    public ReportRecordContractInner withServiceTimeAvg(Double serviceTimeAvg) {
        this.serviceTimeAvg = serviceTimeAvg;
        return this;
    }

    public Double serviceTimeMin() {
        return this.serviceTimeMin;
    }

    public ReportRecordContractInner withServiceTimeMin(Double serviceTimeMin) {
        this.serviceTimeMin = serviceTimeMin;
        return this;
    }

    public Double serviceTimeMax() {
        return this.serviceTimeMax;
    }

    public ReportRecordContractInner withServiceTimeMax(Double serviceTimeMax) {
        this.serviceTimeMax = serviceTimeMax;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("timestamp", this.timestamp == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.timestamp));
        jsonWriter.writeStringField("interval", this.interval);
        jsonWriter.writeStringField("country", this.country);
        jsonWriter.writeStringField("region", this.region);
        jsonWriter.writeStringField("zip", this.zip);
        jsonWriter.writeStringField("apiId", this.apiId);
        jsonWriter.writeStringField("operationId", this.operationId);
        jsonWriter.writeStringField("apiRegion", this.apiRegion);
        jsonWriter.writeStringField("subscriptionId", this.subscriptionId);
        jsonWriter.writeNumberField("callCountSuccess", (Number)this.callCountSuccess);
        jsonWriter.writeNumberField("callCountBlocked", (Number)this.callCountBlocked);
        jsonWriter.writeNumberField("callCountFailed", (Number)this.callCountFailed);
        jsonWriter.writeNumberField("callCountOther", (Number)this.callCountOther);
        jsonWriter.writeNumberField("callCountTotal", (Number)this.callCountTotal);
        jsonWriter.writeNumberField("bandwidth", (Number)this.bandwidth);
        jsonWriter.writeNumberField("cacheHitCount", (Number)this.cacheHitCount);
        jsonWriter.writeNumberField("cacheMissCount", (Number)this.cacheMissCount);
        jsonWriter.writeNumberField("apiTimeAvg", (Number)this.apiTimeAvg);
        jsonWriter.writeNumberField("apiTimeMin", (Number)this.apiTimeMin);
        jsonWriter.writeNumberField("apiTimeMax", (Number)this.apiTimeMax);
        jsonWriter.writeNumberField("serviceTimeAvg", (Number)this.serviceTimeAvg);
        jsonWriter.writeNumberField("serviceTimeMin", (Number)this.serviceTimeMin);
        jsonWriter.writeNumberField("serviceTimeMax", (Number)this.serviceTimeMax);
        return jsonWriter.writeEndObject();
    }

    public static ReportRecordContractInner fromJson(JsonReader jsonReader) throws IOException {
        return (ReportRecordContractInner)jsonReader.readObject(reader -> {
            ReportRecordContractInner deserializedReportRecordContractInner = new ReportRecordContractInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedReportRecordContractInner.name = reader.getString();
                    continue;
                }
                if ("timestamp".equals(fieldName)) {
                    deserializedReportRecordContractInner.timestamp = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("interval".equals(fieldName)) {
                    deserializedReportRecordContractInner.interval = reader.getString();
                    continue;
                }
                if ("country".equals(fieldName)) {
                    deserializedReportRecordContractInner.country = reader.getString();
                    continue;
                }
                if ("region".equals(fieldName)) {
                    deserializedReportRecordContractInner.region = reader.getString();
                    continue;
                }
                if ("zip".equals(fieldName)) {
                    deserializedReportRecordContractInner.zip = reader.getString();
                    continue;
                }
                if ("userId".equals(fieldName)) {
                    deserializedReportRecordContractInner.userId = reader.getString();
                    continue;
                }
                if ("productId".equals(fieldName)) {
                    deserializedReportRecordContractInner.productId = reader.getString();
                    continue;
                }
                if ("apiId".equals(fieldName)) {
                    deserializedReportRecordContractInner.apiId = reader.getString();
                    continue;
                }
                if ("operationId".equals(fieldName)) {
                    deserializedReportRecordContractInner.operationId = reader.getString();
                    continue;
                }
                if ("apiRegion".equals(fieldName)) {
                    deserializedReportRecordContractInner.apiRegion = reader.getString();
                    continue;
                }
                if ("subscriptionId".equals(fieldName)) {
                    deserializedReportRecordContractInner.subscriptionId = reader.getString();
                    continue;
                }
                if ("callCountSuccess".equals(fieldName)) {
                    deserializedReportRecordContractInner.callCountSuccess = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("callCountBlocked".equals(fieldName)) {
                    deserializedReportRecordContractInner.callCountBlocked = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("callCountFailed".equals(fieldName)) {
                    deserializedReportRecordContractInner.callCountFailed = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("callCountOther".equals(fieldName)) {
                    deserializedReportRecordContractInner.callCountOther = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("callCountTotal".equals(fieldName)) {
                    deserializedReportRecordContractInner.callCountTotal = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("bandwidth".equals(fieldName)) {
                    deserializedReportRecordContractInner.bandwidth = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("cacheHitCount".equals(fieldName)) {
                    deserializedReportRecordContractInner.cacheHitCount = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("cacheMissCount".equals(fieldName)) {
                    deserializedReportRecordContractInner.cacheMissCount = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("apiTimeAvg".equals(fieldName)) {
                    deserializedReportRecordContractInner.apiTimeAvg = (Double)reader.getNullable(JsonReader::getDouble);
                    continue;
                }
                if ("apiTimeMin".equals(fieldName)) {
                    deserializedReportRecordContractInner.apiTimeMin = (Double)reader.getNullable(JsonReader::getDouble);
                    continue;
                }
                if ("apiTimeMax".equals(fieldName)) {
                    deserializedReportRecordContractInner.apiTimeMax = (Double)reader.getNullable(JsonReader::getDouble);
                    continue;
                }
                if ("serviceTimeAvg".equals(fieldName)) {
                    deserializedReportRecordContractInner.serviceTimeAvg = (Double)reader.getNullable(JsonReader::getDouble);
                    continue;
                }
                if ("serviceTimeMin".equals(fieldName)) {
                    deserializedReportRecordContractInner.serviceTimeMin = (Double)reader.getNullable(JsonReader::getDouble);
                    continue;
                }
                if ("serviceTimeMax".equals(fieldName)) {
                    deserializedReportRecordContractInner.serviceTimeMax = (Double)reader.getNullable(JsonReader::getDouble);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedReportRecordContractInner;
        });
    }
}

