/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public final class RequestReportRecordContractInner
implements JsonSerializable<RequestReportRecordContractInner> {
    private String apiId;
    private String operationId;
    private String productId;
    private String userId;
    private String method;
    private String url;
    private String ipAddress;
    private String backendResponseCode;
    private Integer responseCode;
    private Integer responseSize;
    private OffsetDateTime timestamp;
    private String cache;
    private Double apiTime;
    private Double serviceTime;
    private String apiRegion;
    private String subscriptionId;
    private String requestId;
    private Integer requestSize;

    public String apiId() {
        return this.apiId;
    }

    public RequestReportRecordContractInner withApiId(String apiId) {
        this.apiId = apiId;
        return this;
    }

    public String operationId() {
        return this.operationId;
    }

    public RequestReportRecordContractInner withOperationId(String operationId) {
        this.operationId = operationId;
        return this;
    }

    public String productId() {
        return this.productId;
    }

    public String userId() {
        return this.userId;
    }

    public String method() {
        return this.method;
    }

    public RequestReportRecordContractInner withMethod(String method) {
        this.method = method;
        return this;
    }

    public String url() {
        return this.url;
    }

    public RequestReportRecordContractInner withUrl(String url) {
        this.url = url;
        return this;
    }

    public String ipAddress() {
        return this.ipAddress;
    }

    public RequestReportRecordContractInner withIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
        return this;
    }

    public String backendResponseCode() {
        return this.backendResponseCode;
    }

    public RequestReportRecordContractInner withBackendResponseCode(String backendResponseCode) {
        this.backendResponseCode = backendResponseCode;
        return this;
    }

    public Integer responseCode() {
        return this.responseCode;
    }

    public RequestReportRecordContractInner withResponseCode(Integer responseCode) {
        this.responseCode = responseCode;
        return this;
    }

    public Integer responseSize() {
        return this.responseSize;
    }

    public RequestReportRecordContractInner withResponseSize(Integer responseSize) {
        this.responseSize = responseSize;
        return this;
    }

    public OffsetDateTime timestamp() {
        return this.timestamp;
    }

    public RequestReportRecordContractInner withTimestamp(OffsetDateTime timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    public String cache() {
        return this.cache;
    }

    public RequestReportRecordContractInner withCache(String cache) {
        this.cache = cache;
        return this;
    }

    public Double apiTime() {
        return this.apiTime;
    }

    public RequestReportRecordContractInner withApiTime(Double apiTime) {
        this.apiTime = apiTime;
        return this;
    }

    public Double serviceTime() {
        return this.serviceTime;
    }

    public RequestReportRecordContractInner withServiceTime(Double serviceTime) {
        this.serviceTime = serviceTime;
        return this;
    }

    public String apiRegion() {
        return this.apiRegion;
    }

    public RequestReportRecordContractInner withApiRegion(String apiRegion) {
        this.apiRegion = apiRegion;
        return this;
    }

    public String subscriptionId() {
        return this.subscriptionId;
    }

    public RequestReportRecordContractInner withSubscriptionId(String subscriptionId) {
        this.subscriptionId = subscriptionId;
        return this;
    }

    public String requestId() {
        return this.requestId;
    }

    public RequestReportRecordContractInner withRequestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    public Integer requestSize() {
        return this.requestSize;
    }

    public RequestReportRecordContractInner withRequestSize(Integer requestSize) {
        this.requestSize = requestSize;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("apiId", this.apiId);
        jsonWriter.writeStringField("operationId", this.operationId);
        jsonWriter.writeStringField("method", this.method);
        jsonWriter.writeStringField("url", this.url);
        jsonWriter.writeStringField("ipAddress", this.ipAddress);
        jsonWriter.writeStringField("backendResponseCode", this.backendResponseCode);
        jsonWriter.writeNumberField("responseCode", (Number)this.responseCode);
        jsonWriter.writeNumberField("responseSize", (Number)this.responseSize);
        jsonWriter.writeStringField("timestamp", this.timestamp == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.timestamp));
        jsonWriter.writeStringField("cache", this.cache);
        jsonWriter.writeNumberField("apiTime", (Number)this.apiTime);
        jsonWriter.writeNumberField("serviceTime", (Number)this.serviceTime);
        jsonWriter.writeStringField("apiRegion", this.apiRegion);
        jsonWriter.writeStringField("subscriptionId", this.subscriptionId);
        jsonWriter.writeStringField("requestId", this.requestId);
        jsonWriter.writeNumberField("requestSize", (Number)this.requestSize);
        return jsonWriter.writeEndObject();
    }

    public static RequestReportRecordContractInner fromJson(JsonReader jsonReader) throws IOException {
        return (RequestReportRecordContractInner)jsonReader.readObject(reader -> {
            RequestReportRecordContractInner deserializedRequestReportRecordContractInner = new RequestReportRecordContractInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("apiId".equals(fieldName)) {
                    deserializedRequestReportRecordContractInner.apiId = reader.getString();
                    continue;
                }
                if ("operationId".equals(fieldName)) {
                    deserializedRequestReportRecordContractInner.operationId = reader.getString();
                    continue;
                }
                if ("productId".equals(fieldName)) {
                    deserializedRequestReportRecordContractInner.productId = reader.getString();
                    continue;
                }
                if ("userId".equals(fieldName)) {
                    deserializedRequestReportRecordContractInner.userId = reader.getString();
                    continue;
                }
                if ("method".equals(fieldName)) {
                    deserializedRequestReportRecordContractInner.method = reader.getString();
                    continue;
                }
                if ("url".equals(fieldName)) {
                    deserializedRequestReportRecordContractInner.url = reader.getString();
                    continue;
                }
                if ("ipAddress".equals(fieldName)) {
                    deserializedRequestReportRecordContractInner.ipAddress = reader.getString();
                    continue;
                }
                if ("backendResponseCode".equals(fieldName)) {
                    deserializedRequestReportRecordContractInner.backendResponseCode = reader.getString();
                    continue;
                }
                if ("responseCode".equals(fieldName)) {
                    deserializedRequestReportRecordContractInner.responseCode = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("responseSize".equals(fieldName)) {
                    deserializedRequestReportRecordContractInner.responseSize = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("timestamp".equals(fieldName)) {
                    deserializedRequestReportRecordContractInner.timestamp = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("cache".equals(fieldName)) {
                    deserializedRequestReportRecordContractInner.cache = reader.getString();
                    continue;
                }
                if ("apiTime".equals(fieldName)) {
                    deserializedRequestReportRecordContractInner.apiTime = (Double)reader.getNullable(JsonReader::getDouble);
                    continue;
                }
                if ("serviceTime".equals(fieldName)) {
                    deserializedRequestReportRecordContractInner.serviceTime = (Double)reader.getNullable(JsonReader::getDouble);
                    continue;
                }
                if ("apiRegion".equals(fieldName)) {
                    deserializedRequestReportRecordContractInner.apiRegion = reader.getString();
                    continue;
                }
                if ("subscriptionId".equals(fieldName)) {
                    deserializedRequestReportRecordContractInner.subscriptionId = reader.getString();
                    continue;
                }
                if ("requestId".equals(fieldName)) {
                    deserializedRequestReportRecordContractInner.requestId = reader.getString();
                    continue;
                }
                if ("requestSize".equals(fieldName)) {
                    deserializedRequestReportRecordContractInner.requestSize = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRequestReportRecordContractInner;
        });
    }
}

