/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.apimanagement.fluent.models.SchemaDocumentProperties;
import java.io.IOException;

public final class SchemaContractProperties
implements JsonSerializable<SchemaContractProperties> {
    private String contentType;
    private SchemaDocumentProperties innerDocument = new SchemaDocumentProperties();
    private static final ClientLogger LOGGER = new ClientLogger(SchemaContractProperties.class);

    public String contentType() {
        return this.contentType;
    }

    public SchemaContractProperties withContentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    private SchemaDocumentProperties innerDocument() {
        return this.innerDocument;
    }

    public String value() {
        return this.innerDocument() == null ? null : this.innerDocument().value();
    }

    public SchemaContractProperties withValue(String value) {
        if (this.innerDocument() == null) {
            this.innerDocument = new SchemaDocumentProperties();
        }
        this.innerDocument().withValue(value);
        return this;
    }

    public Object definitions() {
        return this.innerDocument() == null ? null : this.innerDocument().definitions();
    }

    public SchemaContractProperties withDefinitions(Object definitions) {
        if (this.innerDocument() == null) {
            this.innerDocument = new SchemaDocumentProperties();
        }
        this.innerDocument().withDefinitions(definitions);
        return this;
    }

    public Object components() {
        return this.innerDocument() == null ? null : this.innerDocument().components();
    }

    public SchemaContractProperties withComponents(Object components) {
        if (this.innerDocument() == null) {
            this.innerDocument = new SchemaDocumentProperties();
        }
        this.innerDocument().withComponents(components);
        return this;
    }

    public void validate() {
        if (this.contentType() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property contentType in model SchemaContractProperties"));
        }
        if (this.innerDocument() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property innerDocument in model SchemaContractProperties"));
        }
        this.innerDocument().validate();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("contentType", this.contentType);
        jsonWriter.writeJsonField("document", (JsonSerializable)this.innerDocument);
        return jsonWriter.writeEndObject();
    }

    public static SchemaContractProperties fromJson(JsonReader jsonReader) throws IOException {
        return (SchemaContractProperties)jsonReader.readObject(reader -> {
            SchemaContractProperties deserializedSchemaContractProperties = new SchemaContractProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("contentType".equals(fieldName)) {
                    deserializedSchemaContractProperties.contentType = reader.getString();
                    continue;
                }
                if ("document".equals(fieldName)) {
                    deserializedSchemaContractProperties.innerDocument = SchemaDocumentProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSchemaContractProperties;
        });
    }
}

