/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.apimanagement.models.SubscriptionState;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public final class SubscriptionContractProperties
implements JsonSerializable<SubscriptionContractProperties> {
    private String ownerId;
    private String scope;
    private String displayName;
    private SubscriptionState state;
    private OffsetDateTime createdDate;
    private OffsetDateTime startDate;
    private OffsetDateTime expirationDate;
    private OffsetDateTime endDate;
    private OffsetDateTime notificationDate;
    private String primaryKey;
    private String secondaryKey;
    private String stateComment;
    private Boolean allowTracing;
    private static final ClientLogger LOGGER = new ClientLogger(SubscriptionContractProperties.class);

    public String ownerId() {
        return this.ownerId;
    }

    public SubscriptionContractProperties withOwnerId(String ownerId) {
        this.ownerId = ownerId;
        return this;
    }

    public String scope() {
        return this.scope;
    }

    public SubscriptionContractProperties withScope(String scope) {
        this.scope = scope;
        return this;
    }

    public String displayName() {
        return this.displayName;
    }

    public SubscriptionContractProperties withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    public SubscriptionState state() {
        return this.state;
    }

    public SubscriptionContractProperties withState(SubscriptionState state) {
        this.state = state;
        return this;
    }

    public OffsetDateTime createdDate() {
        return this.createdDate;
    }

    public OffsetDateTime startDate() {
        return this.startDate;
    }

    public SubscriptionContractProperties withStartDate(OffsetDateTime startDate) {
        this.startDate = startDate;
        return this;
    }

    public OffsetDateTime expirationDate() {
        return this.expirationDate;
    }

    public SubscriptionContractProperties withExpirationDate(OffsetDateTime expirationDate) {
        this.expirationDate = expirationDate;
        return this;
    }

    public OffsetDateTime endDate() {
        return this.endDate;
    }

    public SubscriptionContractProperties withEndDate(OffsetDateTime endDate) {
        this.endDate = endDate;
        return this;
    }

    public OffsetDateTime notificationDate() {
        return this.notificationDate;
    }

    public SubscriptionContractProperties withNotificationDate(OffsetDateTime notificationDate) {
        this.notificationDate = notificationDate;
        return this;
    }

    public String primaryKey() {
        return this.primaryKey;
    }

    public SubscriptionContractProperties withPrimaryKey(String primaryKey) {
        this.primaryKey = primaryKey;
        return this;
    }

    public String secondaryKey() {
        return this.secondaryKey;
    }

    public SubscriptionContractProperties withSecondaryKey(String secondaryKey) {
        this.secondaryKey = secondaryKey;
        return this;
    }

    public String stateComment() {
        return this.stateComment;
    }

    public SubscriptionContractProperties withStateComment(String stateComment) {
        this.stateComment = stateComment;
        return this;
    }

    public Boolean allowTracing() {
        return this.allowTracing;
    }

    public SubscriptionContractProperties withAllowTracing(Boolean allowTracing) {
        this.allowTracing = allowTracing;
        return this;
    }

    public void validate() {
        if (this.scope() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property scope in model SubscriptionContractProperties"));
        }
        if (this.state() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property state in model SubscriptionContractProperties"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("scope", this.scope);
        jsonWriter.writeStringField("state", this.state == null ? null : this.state.toString());
        jsonWriter.writeStringField("ownerId", this.ownerId);
        jsonWriter.writeStringField("displayName", this.displayName);
        jsonWriter.writeStringField("startDate", this.startDate == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.startDate));
        jsonWriter.writeStringField("expirationDate", this.expirationDate == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.expirationDate));
        jsonWriter.writeStringField("endDate", this.endDate == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.endDate));
        jsonWriter.writeStringField("notificationDate", this.notificationDate == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.notificationDate));
        jsonWriter.writeStringField("primaryKey", this.primaryKey);
        jsonWriter.writeStringField("secondaryKey", this.secondaryKey);
        jsonWriter.writeStringField("stateComment", this.stateComment);
        jsonWriter.writeBooleanField("allowTracing", this.allowTracing);
        return jsonWriter.writeEndObject();
    }

    public static SubscriptionContractProperties fromJson(JsonReader jsonReader) throws IOException {
        return (SubscriptionContractProperties)jsonReader.readObject(reader -> {
            SubscriptionContractProperties deserializedSubscriptionContractProperties = new SubscriptionContractProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("scope".equals(fieldName)) {
                    deserializedSubscriptionContractProperties.scope = reader.getString();
                    continue;
                }
                if ("state".equals(fieldName)) {
                    deserializedSubscriptionContractProperties.state = SubscriptionState.fromString(reader.getString());
                    continue;
                }
                if ("ownerId".equals(fieldName)) {
                    deserializedSubscriptionContractProperties.ownerId = reader.getString();
                    continue;
                }
                if ("displayName".equals(fieldName)) {
                    deserializedSubscriptionContractProperties.displayName = reader.getString();
                    continue;
                }
                if ("createdDate".equals(fieldName)) {
                    deserializedSubscriptionContractProperties.createdDate = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("startDate".equals(fieldName)) {
                    deserializedSubscriptionContractProperties.startDate = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("expirationDate".equals(fieldName)) {
                    deserializedSubscriptionContractProperties.expirationDate = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("endDate".equals(fieldName)) {
                    deserializedSubscriptionContractProperties.endDate = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("notificationDate".equals(fieldName)) {
                    deserializedSubscriptionContractProperties.notificationDate = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("primaryKey".equals(fieldName)) {
                    deserializedSubscriptionContractProperties.primaryKey = reader.getString();
                    continue;
                }
                if ("secondaryKey".equals(fieldName)) {
                    deserializedSubscriptionContractProperties.secondaryKey = reader.getString();
                    continue;
                }
                if ("stateComment".equals(fieldName)) {
                    deserializedSubscriptionContractProperties.stateComment = reader.getString();
                    continue;
                }
                if ("allowTracing".equals(fieldName)) {
                    deserializedSubscriptionContractProperties.allowTracing = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSubscriptionContractProperties;
        });
    }
}

