/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.apimanagement.fluent.models.UserIdentityContractInner;
import com.azure.resourcemanager.apimanagement.models.AppType;
import com.azure.resourcemanager.apimanagement.models.Confirmation;
import com.azure.resourcemanager.apimanagement.models.UserEntityBaseParameters;
import com.azure.resourcemanager.apimanagement.models.UserState;
import java.io.IOException;
import java.util.List;

public final class UserCreateParameterProperties
extends UserEntityBaseParameters {
    private String email;
    private String firstName;
    private String lastName;
    private String password;
    private AppType appType;
    private Confirmation confirmation;
    private static final ClientLogger LOGGER = new ClientLogger(UserCreateParameterProperties.class);

    public String email() {
        return this.email;
    }

    public UserCreateParameterProperties withEmail(String email) {
        this.email = email;
        return this;
    }

    public String firstName() {
        return this.firstName;
    }

    public UserCreateParameterProperties withFirstName(String firstName) {
        this.firstName = firstName;
        return this;
    }

    public String lastName() {
        return this.lastName;
    }

    public UserCreateParameterProperties withLastName(String lastName) {
        this.lastName = lastName;
        return this;
    }

    public String password() {
        return this.password;
    }

    public UserCreateParameterProperties withPassword(String password) {
        this.password = password;
        return this;
    }

    public AppType appType() {
        return this.appType;
    }

    public UserCreateParameterProperties withAppType(AppType appType) {
        this.appType = appType;
        return this;
    }

    public Confirmation confirmation() {
        return this.confirmation;
    }

    public UserCreateParameterProperties withConfirmation(Confirmation confirmation) {
        this.confirmation = confirmation;
        return this;
    }

    @Override
    public UserCreateParameterProperties withState(UserState state) {
        super.withState(state);
        return this;
    }

    @Override
    public UserCreateParameterProperties withNote(String note) {
        super.withNote(note);
        return this;
    }

    @Override
    public UserCreateParameterProperties withIdentities(List<UserIdentityContractInner> identities) {
        super.withIdentities(identities);
        return this;
    }

    @Override
    public void validate() {
        if (this.email() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property email in model UserCreateParameterProperties"));
        }
        if (this.firstName() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property firstName in model UserCreateParameterProperties"));
        }
        if (this.lastName() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property lastName in model UserCreateParameterProperties"));
        }
        if (this.identities() != null) {
            this.identities().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("state", this.state() == null ? null : this.state().toString());
        jsonWriter.writeStringField("note", this.note());
        jsonWriter.writeArrayField("identities", this.identities(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("email", this.email);
        jsonWriter.writeStringField("firstName", this.firstName);
        jsonWriter.writeStringField("lastName", this.lastName);
        jsonWriter.writeStringField("password", this.password);
        jsonWriter.writeStringField("appType", this.appType == null ? null : this.appType.toString());
        jsonWriter.writeStringField("confirmation", this.confirmation == null ? null : this.confirmation.toString());
        return jsonWriter.writeEndObject();
    }

    public static UserCreateParameterProperties fromJson(JsonReader jsonReader) throws IOException {
        return (UserCreateParameterProperties)jsonReader.readObject(reader -> {
            UserCreateParameterProperties deserializedUserCreateParameterProperties = new UserCreateParameterProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("state".equals(fieldName)) {
                    deserializedUserCreateParameterProperties.withState(UserState.fromString(reader.getString()));
                    continue;
                }
                if ("note".equals(fieldName)) {
                    deserializedUserCreateParameterProperties.withNote(reader.getString());
                    continue;
                }
                if ("identities".equals(fieldName)) {
                    List identities = reader.readArray(reader1 -> UserIdentityContractInner.fromJson(reader1));
                    deserializedUserCreateParameterProperties.withIdentities(identities);
                    continue;
                }
                if ("email".equals(fieldName)) {
                    deserializedUserCreateParameterProperties.email = reader.getString();
                    continue;
                }
                if ("firstName".equals(fieldName)) {
                    deserializedUserCreateParameterProperties.firstName = reader.getString();
                    continue;
                }
                if ("lastName".equals(fieldName)) {
                    deserializedUserCreateParameterProperties.lastName = reader.getString();
                    continue;
                }
                if ("password".equals(fieldName)) {
                    deserializedUserCreateParameterProperties.password = reader.getString();
                    continue;
                }
                if ("appType".equals(fieldName)) {
                    deserializedUserCreateParameterProperties.appType = AppType.fromString(reader.getString());
                    continue;
                }
                if ("confirmation".equals(fieldName)) {
                    deserializedUserCreateParameterProperties.confirmation = Confirmation.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedUserCreateParameterProperties;
        });
    }
}

