/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.apimanagement.models.KeyType;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public final class UserTokenParameterProperties
implements JsonSerializable<UserTokenParameterProperties> {
    private KeyType keyType;
    private OffsetDateTime expiry;
    private static final ClientLogger LOGGER = new ClientLogger(UserTokenParameterProperties.class);

    public KeyType keyType() {
        return this.keyType;
    }

    public UserTokenParameterProperties withKeyType(KeyType keyType) {
        this.keyType = keyType;
        return this;
    }

    public OffsetDateTime expiry() {
        return this.expiry;
    }

    public UserTokenParameterProperties withExpiry(OffsetDateTime expiry) {
        this.expiry = expiry;
        return this;
    }

    public void validate() {
        if (this.keyType() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property keyType in model UserTokenParameterProperties"));
        }
        if (this.expiry() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property expiry in model UserTokenParameterProperties"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("keyType", this.keyType == null ? null : this.keyType.toString());
        jsonWriter.writeStringField("expiry", this.expiry == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.expiry));
        return jsonWriter.writeEndObject();
    }

    public static UserTokenParameterProperties fromJson(JsonReader jsonReader) throws IOException {
        return (UserTokenParameterProperties)jsonReader.readObject(reader -> {
            UserTokenParameterProperties deserializedUserTokenParameterProperties = new UserTokenParameterProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("keyType".equals(fieldName)) {
                    deserializedUserTokenParameterProperties.keyType = KeyType.fromString(reader.getString());
                    continue;
                }
                if ("expiry".equals(fieldName)) {
                    deserializedUserTokenParameterProperties.expiry = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedUserTokenParameterProperties;
        });
    }
}

