/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.apimanagement.ApiManagementManager;
import com.azure.resourcemanager.apimanagement.fluent.ApiIssueCommentsClient;
import com.azure.resourcemanager.apimanagement.fluent.models.IssueCommentContractInner;
import com.azure.resourcemanager.apimanagement.implementation.IssueCommentContractImpl;
import com.azure.resourcemanager.apimanagement.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.apimanagement.models.ApiIssueComments;
import com.azure.resourcemanager.apimanagement.models.ApiIssueCommentsGetEntityTagResponse;
import com.azure.resourcemanager.apimanagement.models.ApiIssueCommentsGetResponse;
import com.azure.resourcemanager.apimanagement.models.IssueCommentContract;

public final class ApiIssueCommentsImpl
implements ApiIssueComments {
    private static final ClientLogger LOGGER = new ClientLogger(ApiIssueCommentsImpl.class);
    private final ApiIssueCommentsClient innerClient;
    private final ApiManagementManager serviceManager;

    public ApiIssueCommentsImpl(ApiIssueCommentsClient innerClient, ApiManagementManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<IssueCommentContract> listByService(String resourceGroupName, String serviceName, String apiId, String issueId) {
        PagedIterable<IssueCommentContractInner> inner = this.serviceClient().listByService(resourceGroupName, serviceName, apiId, issueId);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new IssueCommentContractImpl((IssueCommentContractInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<IssueCommentContract> listByService(String resourceGroupName, String serviceName, String apiId, String issueId, String filter, Integer top, Integer skip, Context context) {
        PagedIterable<IssueCommentContractInner> inner = this.serviceClient().listByService(resourceGroupName, serviceName, apiId, issueId, filter, top, skip, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new IssueCommentContractImpl((IssueCommentContractInner)((Object)inner1), this.manager()));
    }

    @Override
    public ApiIssueCommentsGetEntityTagResponse getEntityTagWithResponse(String resourceGroupName, String serviceName, String apiId, String issueId, String commentId, Context context) {
        return this.serviceClient().getEntityTagWithResponse(resourceGroupName, serviceName, apiId, issueId, commentId, context);
    }

    @Override
    public void getEntityTag(String resourceGroupName, String serviceName, String apiId, String issueId, String commentId) {
        this.serviceClient().getEntityTag(resourceGroupName, serviceName, apiId, issueId, commentId);
    }

    @Override
    public Response<IssueCommentContract> getWithResponse(String resourceGroupName, String serviceName, String apiId, String issueId, String commentId, Context context) {
        ApiIssueCommentsGetResponse inner = this.serviceClient().getWithResponse(resourceGroupName, serviceName, apiId, issueId, commentId, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new IssueCommentContractImpl(inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public IssueCommentContract get(String resourceGroupName, String serviceName, String apiId, String issueId, String commentId) {
        IssueCommentContractInner inner = this.serviceClient().get(resourceGroupName, serviceName, apiId, issueId, commentId);
        if (inner != null) {
            return new IssueCommentContractImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Void> deleteWithResponse(String resourceGroupName, String serviceName, String apiId, String issueId, String commentId, String ifMatch, Context context) {
        return this.serviceClient().deleteWithResponse(resourceGroupName, serviceName, apiId, issueId, commentId, ifMatch, context);
    }

    @Override
    public void delete(String resourceGroupName, String serviceName, String apiId, String issueId, String commentId, String ifMatch) {
        this.serviceClient().delete(resourceGroupName, serviceName, apiId, issueId, commentId, ifMatch);
    }

    @Override
    public IssueCommentContract getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String apiId = ResourceManagerUtils.getValueFromIdByName(id, "apis");
        if (apiId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'apis'.", id)));
        }
        String issueId = ResourceManagerUtils.getValueFromIdByName(id, "issues");
        if (issueId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'issues'.", id)));
        }
        String commentId = ResourceManagerUtils.getValueFromIdByName(id, "comments");
        if (commentId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'comments'.", id)));
        }
        return (IssueCommentContract)this.getWithResponse(resourceGroupName, serviceName, apiId, issueId, commentId, Context.NONE).getValue();
    }

    @Override
    public Response<IssueCommentContract> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String apiId = ResourceManagerUtils.getValueFromIdByName(id, "apis");
        if (apiId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'apis'.", id)));
        }
        String issueId = ResourceManagerUtils.getValueFromIdByName(id, "issues");
        if (issueId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'issues'.", id)));
        }
        String commentId = ResourceManagerUtils.getValueFromIdByName(id, "comments");
        if (commentId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'comments'.", id)));
        }
        return this.getWithResponse(resourceGroupName, serviceName, apiId, issueId, commentId, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String apiId = ResourceManagerUtils.getValueFromIdByName(id, "apis");
        if (apiId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'apis'.", id)));
        }
        String issueId = ResourceManagerUtils.getValueFromIdByName(id, "issues");
        if (issueId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'issues'.", id)));
        }
        String commentId = ResourceManagerUtils.getValueFromIdByName(id, "comments");
        if (commentId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'comments'.", id)));
        }
        String localIfMatch = null;
        this.deleteWithResponse(resourceGroupName, serviceName, apiId, issueId, commentId, localIfMatch, Context.NONE);
    }

    @Override
    public Response<Void> deleteByIdWithResponse(String id, String ifMatch, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String apiId = ResourceManagerUtils.getValueFromIdByName(id, "apis");
        if (apiId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'apis'.", id)));
        }
        String issueId = ResourceManagerUtils.getValueFromIdByName(id, "issues");
        if (issueId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'issues'.", id)));
        }
        String commentId = ResourceManagerUtils.getValueFromIdByName(id, "comments");
        if (commentId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'comments'.", id)));
        }
        return this.deleteWithResponse(resourceGroupName, serviceName, apiId, issueId, commentId, ifMatch, context);
    }

    private ApiIssueCommentsClient serviceClient() {
        return this.innerClient;
    }

    private ApiManagementManager manager() {
        return this.serviceManager;
    }

    @Override
    public IssueCommentContractImpl define(String name) {
        return new IssueCommentContractImpl(name, this.manager());
    }
}

