/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.apimanagement.ApiManagementManager;
import com.azure.resourcemanager.apimanagement.fluent.ApiManagementServicesClient;
import com.azure.resourcemanager.apimanagement.fluent.models.ApiManagementServiceGetDomainOwnershipIdentifierResultInner;
import com.azure.resourcemanager.apimanagement.fluent.models.ApiManagementServiceGetSsoTokenResultInner;
import com.azure.resourcemanager.apimanagement.fluent.models.ApiManagementServiceNameAvailabilityResultInner;
import com.azure.resourcemanager.apimanagement.fluent.models.ApiManagementServiceResourceInner;
import com.azure.resourcemanager.apimanagement.implementation.ApiManagementServiceGetDomainOwnershipIdentifierResultImpl;
import com.azure.resourcemanager.apimanagement.implementation.ApiManagementServiceGetSsoTokenResultImpl;
import com.azure.resourcemanager.apimanagement.implementation.ApiManagementServiceNameAvailabilityResultImpl;
import com.azure.resourcemanager.apimanagement.implementation.ApiManagementServiceResourceImpl;
import com.azure.resourcemanager.apimanagement.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.apimanagement.models.ApiManagementServiceApplyNetworkConfigurationParameters;
import com.azure.resourcemanager.apimanagement.models.ApiManagementServiceBackupRestoreParameters;
import com.azure.resourcemanager.apimanagement.models.ApiManagementServiceCheckNameAvailabilityParameters;
import com.azure.resourcemanager.apimanagement.models.ApiManagementServiceGetDomainOwnershipIdentifierResult;
import com.azure.resourcemanager.apimanagement.models.ApiManagementServiceGetSsoTokenResult;
import com.azure.resourcemanager.apimanagement.models.ApiManagementServiceNameAvailabilityResult;
import com.azure.resourcemanager.apimanagement.models.ApiManagementServiceResource;
import com.azure.resourcemanager.apimanagement.models.ApiManagementServices;

public final class ApiManagementServicesImpl
implements ApiManagementServices {
    private static final ClientLogger LOGGER = new ClientLogger(ApiManagementServicesImpl.class);
    private final ApiManagementServicesClient innerClient;
    private final ApiManagementManager serviceManager;

    public ApiManagementServicesImpl(ApiManagementServicesClient innerClient, ApiManagementManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public ApiManagementServiceResource restore(String resourceGroupName, String serviceName, ApiManagementServiceBackupRestoreParameters parameters) {
        ApiManagementServiceResourceInner inner = this.serviceClient().restore(resourceGroupName, serviceName, parameters);
        if (inner != null) {
            return new ApiManagementServiceResourceImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public ApiManagementServiceResource restore(String resourceGroupName, String serviceName, ApiManagementServiceBackupRestoreParameters parameters, Context context) {
        ApiManagementServiceResourceInner inner = this.serviceClient().restore(resourceGroupName, serviceName, parameters, context);
        if (inner != null) {
            return new ApiManagementServiceResourceImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public ApiManagementServiceResource backup(String resourceGroupName, String serviceName, ApiManagementServiceBackupRestoreParameters parameters) {
        ApiManagementServiceResourceInner inner = this.serviceClient().backup(resourceGroupName, serviceName, parameters);
        if (inner != null) {
            return new ApiManagementServiceResourceImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public ApiManagementServiceResource backup(String resourceGroupName, String serviceName, ApiManagementServiceBackupRestoreParameters parameters, Context context) {
        ApiManagementServiceResourceInner inner = this.serviceClient().backup(resourceGroupName, serviceName, parameters, context);
        if (inner != null) {
            return new ApiManagementServiceResourceImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<ApiManagementServiceResource> getByResourceGroupWithResponse(String resourceGroupName, String serviceName, Context context) {
        Response<ApiManagementServiceResourceInner> inner = this.serviceClient().getByResourceGroupWithResponse(resourceGroupName, serviceName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new ApiManagementServiceResourceImpl((ApiManagementServiceResourceInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public ApiManagementServiceResource getByResourceGroup(String resourceGroupName, String serviceName) {
        ApiManagementServiceResourceInner inner = this.serviceClient().getByResourceGroup(resourceGroupName, serviceName);
        if (inner != null) {
            return new ApiManagementServiceResourceImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public ApiManagementServiceResource deleteByResourceGroup(String resourceGroupName, String serviceName) {
        ApiManagementServiceResourceInner inner = this.serviceClient().delete(resourceGroupName, serviceName);
        if (inner != null) {
            return new ApiManagementServiceResourceImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public ApiManagementServiceResource delete(String resourceGroupName, String serviceName, Context context) {
        ApiManagementServiceResourceInner inner = this.serviceClient().delete(resourceGroupName, serviceName, context);
        if (inner != null) {
            return new ApiManagementServiceResourceImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public ApiManagementServiceResource migrateToStv2(String resourceGroupName, String serviceName) {
        ApiManagementServiceResourceInner inner = this.serviceClient().migrateToStv2(resourceGroupName, serviceName);
        if (inner != null) {
            return new ApiManagementServiceResourceImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public ApiManagementServiceResource migrateToStv2(String resourceGroupName, String serviceName, Context context) {
        ApiManagementServiceResourceInner inner = this.serviceClient().migrateToStv2(resourceGroupName, serviceName, context);
        if (inner != null) {
            return new ApiManagementServiceResourceImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public PagedIterable<ApiManagementServiceResource> listByResourceGroup(String resourceGroupName) {
        PagedIterable<ApiManagementServiceResourceInner> inner = this.serviceClient().listByResourceGroup(resourceGroupName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ApiManagementServiceResourceImpl((ApiManagementServiceResourceInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<ApiManagementServiceResource> listByResourceGroup(String resourceGroupName, Context context) {
        PagedIterable<ApiManagementServiceResourceInner> inner = this.serviceClient().listByResourceGroup(resourceGroupName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ApiManagementServiceResourceImpl((ApiManagementServiceResourceInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<ApiManagementServiceResource> list() {
        PagedIterable<ApiManagementServiceResourceInner> inner = this.serviceClient().list();
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ApiManagementServiceResourceImpl((ApiManagementServiceResourceInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<ApiManagementServiceResource> list(Context context) {
        PagedIterable<ApiManagementServiceResourceInner> inner = this.serviceClient().list(context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ApiManagementServiceResourceImpl((ApiManagementServiceResourceInner)((Object)inner1), this.manager()));
    }

    @Override
    public Response<ApiManagementServiceGetSsoTokenResult> getSsoTokenWithResponse(String resourceGroupName, String serviceName, Context context) {
        Response<ApiManagementServiceGetSsoTokenResultInner> inner = this.serviceClient().getSsoTokenWithResponse(resourceGroupName, serviceName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new ApiManagementServiceGetSsoTokenResultImpl((ApiManagementServiceGetSsoTokenResultInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public ApiManagementServiceGetSsoTokenResult getSsoToken(String resourceGroupName, String serviceName) {
        ApiManagementServiceGetSsoTokenResultInner inner = this.serviceClient().getSsoToken(resourceGroupName, serviceName);
        if (inner != null) {
            return new ApiManagementServiceGetSsoTokenResultImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<ApiManagementServiceNameAvailabilityResult> checkNameAvailabilityWithResponse(ApiManagementServiceCheckNameAvailabilityParameters parameters, Context context) {
        Response<ApiManagementServiceNameAvailabilityResultInner> inner = this.serviceClient().checkNameAvailabilityWithResponse(parameters, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new ApiManagementServiceNameAvailabilityResultImpl((ApiManagementServiceNameAvailabilityResultInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public ApiManagementServiceNameAvailabilityResult checkNameAvailability(ApiManagementServiceCheckNameAvailabilityParameters parameters) {
        ApiManagementServiceNameAvailabilityResultInner inner = this.serviceClient().checkNameAvailability(parameters);
        if (inner != null) {
            return new ApiManagementServiceNameAvailabilityResultImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<ApiManagementServiceGetDomainOwnershipIdentifierResult> getDomainOwnershipIdentifierWithResponse(Context context) {
        Response<ApiManagementServiceGetDomainOwnershipIdentifierResultInner> inner = this.serviceClient().getDomainOwnershipIdentifierWithResponse(context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new ApiManagementServiceGetDomainOwnershipIdentifierResultImpl((ApiManagementServiceGetDomainOwnershipIdentifierResultInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public ApiManagementServiceGetDomainOwnershipIdentifierResult getDomainOwnershipIdentifier() {
        ApiManagementServiceGetDomainOwnershipIdentifierResultInner inner = this.serviceClient().getDomainOwnershipIdentifier();
        if (inner != null) {
            return new ApiManagementServiceGetDomainOwnershipIdentifierResultImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public ApiManagementServiceResource applyNetworkConfigurationUpdates(String resourceGroupName, String serviceName) {
        ApiManagementServiceResourceInner inner = this.serviceClient().applyNetworkConfigurationUpdates(resourceGroupName, serviceName);
        if (inner != null) {
            return new ApiManagementServiceResourceImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public ApiManagementServiceResource applyNetworkConfigurationUpdates(String resourceGroupName, String serviceName, ApiManagementServiceApplyNetworkConfigurationParameters parameters, Context context) {
        ApiManagementServiceResourceInner inner = this.serviceClient().applyNetworkConfigurationUpdates(resourceGroupName, serviceName, parameters, context);
        if (inner != null) {
            return new ApiManagementServiceResourceImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public ApiManagementServiceResource getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        return (ApiManagementServiceResource)this.getByResourceGroupWithResponse(resourceGroupName, serviceName, Context.NONE).getValue();
    }

    @Override
    public Response<ApiManagementServiceResource> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        return this.getByResourceGroupWithResponse(resourceGroupName, serviceName, context);
    }

    @Override
    public ApiManagementServiceResource deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        return this.delete(resourceGroupName, serviceName, Context.NONE);
    }

    @Override
    public ApiManagementServiceResource deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        return this.delete(resourceGroupName, serviceName, context);
    }

    private ApiManagementServicesClient serviceClient() {
        return this.innerClient;
    }

    private ApiManagementManager manager() {
        return this.serviceManager;
    }

    @Override
    public ApiManagementServiceResourceImpl define(String name) {
        return new ApiManagementServiceResourceImpl(name, this.manager());
    }
}

