/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.apimanagement.ApiManagementManager;
import com.azure.resourcemanager.apimanagement.fluent.AuthorizationAccessPoliciesClient;
import com.azure.resourcemanager.apimanagement.fluent.models.AuthorizationAccessPolicyContractInner;
import com.azure.resourcemanager.apimanagement.implementation.AuthorizationAccessPolicyContractImpl;
import com.azure.resourcemanager.apimanagement.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.apimanagement.models.AuthorizationAccessPolicies;
import com.azure.resourcemanager.apimanagement.models.AuthorizationAccessPoliciesGetResponse;
import com.azure.resourcemanager.apimanagement.models.AuthorizationAccessPolicyContract;

public final class AuthorizationAccessPoliciesImpl
implements AuthorizationAccessPolicies {
    private static final ClientLogger LOGGER = new ClientLogger(AuthorizationAccessPoliciesImpl.class);
    private final AuthorizationAccessPoliciesClient innerClient;
    private final ApiManagementManager serviceManager;

    public AuthorizationAccessPoliciesImpl(AuthorizationAccessPoliciesClient innerClient, ApiManagementManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<AuthorizationAccessPolicyContract> listByAuthorization(String resourceGroupName, String serviceName, String authorizationProviderId, String authorizationId) {
        PagedIterable<AuthorizationAccessPolicyContractInner> inner = this.serviceClient().listByAuthorization(resourceGroupName, serviceName, authorizationProviderId, authorizationId);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new AuthorizationAccessPolicyContractImpl((AuthorizationAccessPolicyContractInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<AuthorizationAccessPolicyContract> listByAuthorization(String resourceGroupName, String serviceName, String authorizationProviderId, String authorizationId, String filter, Integer top, Integer skip, Context context) {
        PagedIterable<AuthorizationAccessPolicyContractInner> inner = this.serviceClient().listByAuthorization(resourceGroupName, serviceName, authorizationProviderId, authorizationId, filter, top, skip, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new AuthorizationAccessPolicyContractImpl((AuthorizationAccessPolicyContractInner)((Object)inner1), this.manager()));
    }

    @Override
    public Response<AuthorizationAccessPolicyContract> getWithResponse(String resourceGroupName, String serviceName, String authorizationProviderId, String authorizationId, String authorizationAccessPolicyId, Context context) {
        AuthorizationAccessPoliciesGetResponse inner = this.serviceClient().getWithResponse(resourceGroupName, serviceName, authorizationProviderId, authorizationId, authorizationAccessPolicyId, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new AuthorizationAccessPolicyContractImpl(inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public AuthorizationAccessPolicyContract get(String resourceGroupName, String serviceName, String authorizationProviderId, String authorizationId, String authorizationAccessPolicyId) {
        AuthorizationAccessPolicyContractInner inner = this.serviceClient().get(resourceGroupName, serviceName, authorizationProviderId, authorizationId, authorizationAccessPolicyId);
        if (inner != null) {
            return new AuthorizationAccessPolicyContractImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Void> deleteWithResponse(String resourceGroupName, String serviceName, String authorizationProviderId, String authorizationId, String authorizationAccessPolicyId, String ifMatch, Context context) {
        return this.serviceClient().deleteWithResponse(resourceGroupName, serviceName, authorizationProviderId, authorizationId, authorizationAccessPolicyId, ifMatch, context);
    }

    @Override
    public void delete(String resourceGroupName, String serviceName, String authorizationProviderId, String authorizationId, String authorizationAccessPolicyId, String ifMatch) {
        this.serviceClient().delete(resourceGroupName, serviceName, authorizationProviderId, authorizationId, authorizationAccessPolicyId, ifMatch);
    }

    @Override
    public AuthorizationAccessPolicyContract getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String authorizationProviderId = ResourceManagerUtils.getValueFromIdByName(id, "authorizationProviders");
        if (authorizationProviderId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'authorizationProviders'.", id)));
        }
        String authorizationId = ResourceManagerUtils.getValueFromIdByName(id, "authorizations");
        if (authorizationId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'authorizations'.", id)));
        }
        String authorizationAccessPolicyId = ResourceManagerUtils.getValueFromIdByName(id, "accessPolicies");
        if (authorizationAccessPolicyId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'accessPolicies'.", id)));
        }
        return (AuthorizationAccessPolicyContract)this.getWithResponse(resourceGroupName, serviceName, authorizationProviderId, authorizationId, authorizationAccessPolicyId, Context.NONE).getValue();
    }

    @Override
    public Response<AuthorizationAccessPolicyContract> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String authorizationProviderId = ResourceManagerUtils.getValueFromIdByName(id, "authorizationProviders");
        if (authorizationProviderId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'authorizationProviders'.", id)));
        }
        String authorizationId = ResourceManagerUtils.getValueFromIdByName(id, "authorizations");
        if (authorizationId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'authorizations'.", id)));
        }
        String authorizationAccessPolicyId = ResourceManagerUtils.getValueFromIdByName(id, "accessPolicies");
        if (authorizationAccessPolicyId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'accessPolicies'.", id)));
        }
        return this.getWithResponse(resourceGroupName, serviceName, authorizationProviderId, authorizationId, authorizationAccessPolicyId, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String authorizationProviderId = ResourceManagerUtils.getValueFromIdByName(id, "authorizationProviders");
        if (authorizationProviderId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'authorizationProviders'.", id)));
        }
        String authorizationId = ResourceManagerUtils.getValueFromIdByName(id, "authorizations");
        if (authorizationId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'authorizations'.", id)));
        }
        String authorizationAccessPolicyId = ResourceManagerUtils.getValueFromIdByName(id, "accessPolicies");
        if (authorizationAccessPolicyId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'accessPolicies'.", id)));
        }
        String localIfMatch = null;
        this.deleteWithResponse(resourceGroupName, serviceName, authorizationProviderId, authorizationId, authorizationAccessPolicyId, localIfMatch, Context.NONE);
    }

    @Override
    public Response<Void> deleteByIdWithResponse(String id, String ifMatch, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String authorizationProviderId = ResourceManagerUtils.getValueFromIdByName(id, "authorizationProviders");
        if (authorizationProviderId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'authorizationProviders'.", id)));
        }
        String authorizationId = ResourceManagerUtils.getValueFromIdByName(id, "authorizations");
        if (authorizationId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'authorizations'.", id)));
        }
        String authorizationAccessPolicyId = ResourceManagerUtils.getValueFromIdByName(id, "accessPolicies");
        if (authorizationAccessPolicyId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'accessPolicies'.", id)));
        }
        return this.deleteWithResponse(resourceGroupName, serviceName, authorizationProviderId, authorizationId, authorizationAccessPolicyId, ifMatch, context);
    }

    private AuthorizationAccessPoliciesClient serviceClient() {
        return this.innerClient;
    }

    private ApiManagementManager manager() {
        return this.serviceManager;
    }

    @Override
    public AuthorizationAccessPolicyContractImpl define(String name) {
        return new AuthorizationAccessPolicyContractImpl(name, this.manager());
    }
}

