/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.util.Context;
import com.azure.resourcemanager.apimanagement.ApiManagementManager;
import com.azure.resourcemanager.apimanagement.fluent.models.AuthorizationProviderContractInner;
import com.azure.resourcemanager.apimanagement.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.apimanagement.models.AuthorizationProviderContract;
import com.azure.resourcemanager.apimanagement.models.AuthorizationProviderOAuth2Settings;

public final class AuthorizationProviderContractImpl
implements AuthorizationProviderContract,
AuthorizationProviderContract.Definition,
AuthorizationProviderContract.Update {
    private AuthorizationProviderContractInner innerObject;
    private final ApiManagementManager serviceManager;
    private String resourceGroupName;
    private String serviceName;
    private String authorizationProviderId;
    private String createIfMatch;
    private String updateIfMatch;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String displayName() {
        return this.innerModel().displayName();
    }

    @Override
    public String identityProvider() {
        return this.innerModel().identityProvider();
    }

    @Override
    public AuthorizationProviderOAuth2Settings oauth2() {
        return this.innerModel().oauth2();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public AuthorizationProviderContractInner innerModel() {
        return this.innerObject;
    }

    private ApiManagementManager manager() {
        return this.serviceManager;
    }

    @Override
    public AuthorizationProviderContractImpl withExistingService(String resourceGroupName, String serviceName) {
        this.resourceGroupName = resourceGroupName;
        this.serviceName = serviceName;
        return this;
    }

    @Override
    public AuthorizationProviderContract create() {
        this.innerObject = this.serviceManager.serviceClient().getAuthorizationProviders().createOrUpdateWithResponse(this.resourceGroupName, this.serviceName, this.authorizationProviderId, this.innerModel(), this.createIfMatch, Context.NONE).getValue();
        return this;
    }

    @Override
    public AuthorizationProviderContract create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getAuthorizationProviders().createOrUpdateWithResponse(this.resourceGroupName, this.serviceName, this.authorizationProviderId, this.innerModel(), this.createIfMatch, context).getValue();
        return this;
    }

    AuthorizationProviderContractImpl(String name, ApiManagementManager serviceManager) {
        this.innerObject = new AuthorizationProviderContractInner();
        this.serviceManager = serviceManager;
        this.authorizationProviderId = name;
        this.createIfMatch = null;
    }

    @Override
    public AuthorizationProviderContractImpl update() {
        this.updateIfMatch = null;
        return this;
    }

    @Override
    public AuthorizationProviderContract apply() {
        this.innerObject = this.serviceManager.serviceClient().getAuthorizationProviders().createOrUpdateWithResponse(this.resourceGroupName, this.serviceName, this.authorizationProviderId, this.innerModel(), this.updateIfMatch, Context.NONE).getValue();
        return this;
    }

    @Override
    public AuthorizationProviderContract apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getAuthorizationProviders().createOrUpdateWithResponse(this.resourceGroupName, this.serviceName, this.authorizationProviderId, this.innerModel(), this.updateIfMatch, context).getValue();
        return this;
    }

    AuthorizationProviderContractImpl(AuthorizationProviderContractInner innerObject, ApiManagementManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.serviceName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "service");
        this.authorizationProviderId = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "authorizationProviders");
    }

    @Override
    public AuthorizationProviderContract refresh() {
        this.innerObject = this.serviceManager.serviceClient().getAuthorizationProviders().getWithResponse(this.resourceGroupName, this.serviceName, this.authorizationProviderId, Context.NONE).getValue();
        return this;
    }

    @Override
    public AuthorizationProviderContract refresh(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getAuthorizationProviders().getWithResponse(this.resourceGroupName, this.serviceName, this.authorizationProviderId, context).getValue();
        return this;
    }

    @Override
    public AuthorizationProviderContractImpl withDisplayName(String displayName) {
        this.innerModel().withDisplayName(displayName);
        return this;
    }

    @Override
    public AuthorizationProviderContractImpl withIdentityProvider(String identityProvider) {
        this.innerModel().withIdentityProvider(identityProvider);
        return this;
    }

    @Override
    public AuthorizationProviderContractImpl withOauth2(AuthorizationProviderOAuth2Settings oauth2) {
        this.innerModel().withOauth2(oauth2);
        return this;
    }

    @Override
    public AuthorizationProviderContractImpl withIfMatch(String ifMatch) {
        if (this.isInCreateMode()) {
            this.createIfMatch = ifMatch;
            return this;
        }
        this.updateIfMatch = ifMatch;
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel().id() == null;
    }
}

