/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.resourcemanager.apimanagement.ApiManagementManager;
import com.azure.resourcemanager.apimanagement.fluent.models.AuthorizationServerContractInner;
import com.azure.resourcemanager.apimanagement.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.apimanagement.models.AuthorizationMethod;
import com.azure.resourcemanager.apimanagement.models.AuthorizationServerContract;
import com.azure.resourcemanager.apimanagement.models.AuthorizationServerSecretsContract;
import com.azure.resourcemanager.apimanagement.models.AuthorizationServerUpdateContract;
import com.azure.resourcemanager.apimanagement.models.BearerTokenSendingMethod;
import com.azure.resourcemanager.apimanagement.models.ClientAuthenticationMethod;
import com.azure.resourcemanager.apimanagement.models.GrantType;
import com.azure.resourcemanager.apimanagement.models.TokenBodyParameterContract;
import java.util.Collections;
import java.util.List;

public final class AuthorizationServerContractImpl
implements AuthorizationServerContract,
AuthorizationServerContract.Definition,
AuthorizationServerContract.Update {
    private AuthorizationServerContractInner innerObject;
    private final ApiManagementManager serviceManager;
    private String resourceGroupName;
    private String serviceName;
    private String authsid;
    private String createIfMatch;
    private String updateIfMatch;
    private AuthorizationServerUpdateContract updateParameters;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String displayName() {
        return this.innerModel().displayName();
    }

    @Override
    public Boolean useInTestConsole() {
        return this.innerModel().useInTestConsole();
    }

    @Override
    public Boolean useInApiDocumentation() {
        return this.innerModel().useInApiDocumentation();
    }

    @Override
    public String clientRegistrationEndpoint() {
        return this.innerModel().clientRegistrationEndpoint();
    }

    @Override
    public String authorizationEndpoint() {
        return this.innerModel().authorizationEndpoint();
    }

    @Override
    public List<GrantType> grantTypes() {
        List<GrantType> inner = this.innerModel().grantTypes();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public String clientId() {
        return this.innerModel().clientId();
    }

    @Override
    public String clientSecret() {
        return this.innerModel().clientSecret();
    }

    @Override
    public String description() {
        return this.innerModel().description();
    }

    @Override
    public List<AuthorizationMethod> authorizationMethods() {
        List<AuthorizationMethod> inner = this.innerModel().authorizationMethods();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public List<ClientAuthenticationMethod> clientAuthenticationMethod() {
        List<ClientAuthenticationMethod> inner = this.innerModel().clientAuthenticationMethod();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public List<TokenBodyParameterContract> tokenBodyParameters() {
        List<TokenBodyParameterContract> inner = this.innerModel().tokenBodyParameters();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public String tokenEndpoint() {
        return this.innerModel().tokenEndpoint();
    }

    @Override
    public Boolean supportState() {
        return this.innerModel().supportState();
    }

    @Override
    public String defaultScope() {
        return this.innerModel().defaultScope();
    }

    @Override
    public List<BearerTokenSendingMethod> bearerTokenSendingMethods() {
        List<BearerTokenSendingMethod> inner = this.innerModel().bearerTokenSendingMethods();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public String resourceOwnerUsername() {
        return this.innerModel().resourceOwnerUsername();
    }

    @Override
    public String resourceOwnerPassword() {
        return this.innerModel().resourceOwnerPassword();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public AuthorizationServerContractInner innerModel() {
        return this.innerObject;
    }

    private ApiManagementManager manager() {
        return this.serviceManager;
    }

    @Override
    public AuthorizationServerContractImpl withExistingService(String resourceGroupName, String serviceName) {
        this.resourceGroupName = resourceGroupName;
        this.serviceName = serviceName;
        return this;
    }

    @Override
    public AuthorizationServerContract create() {
        this.innerObject = this.serviceManager.serviceClient().getAuthorizationServers().createOrUpdateWithResponse(this.resourceGroupName, this.serviceName, this.authsid, this.innerModel(), this.createIfMatch, Context.NONE).getValue();
        return this;
    }

    @Override
    public AuthorizationServerContract create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getAuthorizationServers().createOrUpdateWithResponse(this.resourceGroupName, this.serviceName, this.authsid, this.innerModel(), this.createIfMatch, context).getValue();
        return this;
    }

    AuthorizationServerContractImpl(String name, ApiManagementManager serviceManager) {
        this.innerObject = new AuthorizationServerContractInner();
        this.serviceManager = serviceManager;
        this.authsid = name;
        this.createIfMatch = null;
    }

    @Override
    public AuthorizationServerContractImpl update() {
        this.updateIfMatch = null;
        this.updateParameters = new AuthorizationServerUpdateContract();
        return this;
    }

    @Override
    public AuthorizationServerContract apply() {
        this.innerObject = this.serviceManager.serviceClient().getAuthorizationServers().updateWithResponse(this.resourceGroupName, this.serviceName, this.authsid, this.updateIfMatch, this.updateParameters, Context.NONE).getValue();
        return this;
    }

    @Override
    public AuthorizationServerContract apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getAuthorizationServers().updateWithResponse(this.resourceGroupName, this.serviceName, this.authsid, this.updateIfMatch, this.updateParameters, context).getValue();
        return this;
    }

    AuthorizationServerContractImpl(AuthorizationServerContractInner innerObject, ApiManagementManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.serviceName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "service");
        this.authsid = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "authorizationServers");
    }

    @Override
    public AuthorizationServerContract refresh() {
        this.innerObject = this.serviceManager.serviceClient().getAuthorizationServers().getWithResponse(this.resourceGroupName, this.serviceName, this.authsid, Context.NONE).getValue();
        return this;
    }

    @Override
    public AuthorizationServerContract refresh(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getAuthorizationServers().getWithResponse(this.resourceGroupName, this.serviceName, this.authsid, context).getValue();
        return this;
    }

    @Override
    public Response<AuthorizationServerSecretsContract> listSecretsWithResponse(Context context) {
        return this.serviceManager.authorizationServers().listSecretsWithResponse(this.resourceGroupName, this.serviceName, this.authsid, context);
    }

    @Override
    public AuthorizationServerSecretsContract listSecrets() {
        return this.serviceManager.authorizationServers().listSecrets(this.resourceGroupName, this.serviceName, this.authsid);
    }

    @Override
    public AuthorizationServerContractImpl withDisplayName(String displayName) {
        if (this.isInCreateMode()) {
            this.innerModel().withDisplayName(displayName);
            return this;
        }
        this.updateParameters.withDisplayName(displayName);
        return this;
    }

    @Override
    public AuthorizationServerContractImpl withUseInTestConsole(Boolean useInTestConsole) {
        if (this.isInCreateMode()) {
            this.innerModel().withUseInTestConsole(useInTestConsole);
            return this;
        }
        this.updateParameters.withUseInTestConsole(useInTestConsole);
        return this;
    }

    @Override
    public AuthorizationServerContractImpl withUseInApiDocumentation(Boolean useInApiDocumentation) {
        if (this.isInCreateMode()) {
            this.innerModel().withUseInApiDocumentation(useInApiDocumentation);
            return this;
        }
        this.updateParameters.withUseInApiDocumentation(useInApiDocumentation);
        return this;
    }

    @Override
    public AuthorizationServerContractImpl withClientRegistrationEndpoint(String clientRegistrationEndpoint) {
        if (this.isInCreateMode()) {
            this.innerModel().withClientRegistrationEndpoint(clientRegistrationEndpoint);
            return this;
        }
        this.updateParameters.withClientRegistrationEndpoint(clientRegistrationEndpoint);
        return this;
    }

    @Override
    public AuthorizationServerContractImpl withAuthorizationEndpoint(String authorizationEndpoint) {
        if (this.isInCreateMode()) {
            this.innerModel().withAuthorizationEndpoint(authorizationEndpoint);
            return this;
        }
        this.updateParameters.withAuthorizationEndpoint(authorizationEndpoint);
        return this;
    }

    @Override
    public AuthorizationServerContractImpl withGrantTypes(List<GrantType> grantTypes) {
        if (this.isInCreateMode()) {
            this.innerModel().withGrantTypes(grantTypes);
            return this;
        }
        this.updateParameters.withGrantTypes(grantTypes);
        return this;
    }

    @Override
    public AuthorizationServerContractImpl withClientId(String clientId) {
        if (this.isInCreateMode()) {
            this.innerModel().withClientId(clientId);
            return this;
        }
        this.updateParameters.withClientId(clientId);
        return this;
    }

    @Override
    public AuthorizationServerContractImpl withClientSecret(String clientSecret) {
        if (this.isInCreateMode()) {
            this.innerModel().withClientSecret(clientSecret);
            return this;
        }
        this.updateParameters.withClientSecret(clientSecret);
        return this;
    }

    @Override
    public AuthorizationServerContractImpl withDescription(String description) {
        if (this.isInCreateMode()) {
            this.innerModel().withDescription(description);
            return this;
        }
        this.updateParameters.withDescription(description);
        return this;
    }

    @Override
    public AuthorizationServerContractImpl withAuthorizationMethods(List<AuthorizationMethod> authorizationMethods) {
        if (this.isInCreateMode()) {
            this.innerModel().withAuthorizationMethods(authorizationMethods);
            return this;
        }
        this.updateParameters.withAuthorizationMethods(authorizationMethods);
        return this;
    }

    @Override
    public AuthorizationServerContractImpl withClientAuthenticationMethod(List<ClientAuthenticationMethod> clientAuthenticationMethod) {
        if (this.isInCreateMode()) {
            this.innerModel().withClientAuthenticationMethod(clientAuthenticationMethod);
            return this;
        }
        this.updateParameters.withClientAuthenticationMethod(clientAuthenticationMethod);
        return this;
    }

    @Override
    public AuthorizationServerContractImpl withTokenBodyParameters(List<TokenBodyParameterContract> tokenBodyParameters) {
        if (this.isInCreateMode()) {
            this.innerModel().withTokenBodyParameters(tokenBodyParameters);
            return this;
        }
        this.updateParameters.withTokenBodyParameters(tokenBodyParameters);
        return this;
    }

    @Override
    public AuthorizationServerContractImpl withTokenEndpoint(String tokenEndpoint) {
        if (this.isInCreateMode()) {
            this.innerModel().withTokenEndpoint(tokenEndpoint);
            return this;
        }
        this.updateParameters.withTokenEndpoint(tokenEndpoint);
        return this;
    }

    @Override
    public AuthorizationServerContractImpl withSupportState(Boolean supportState) {
        if (this.isInCreateMode()) {
            this.innerModel().withSupportState(supportState);
            return this;
        }
        this.updateParameters.withSupportState(supportState);
        return this;
    }

    @Override
    public AuthorizationServerContractImpl withDefaultScope(String defaultScope) {
        if (this.isInCreateMode()) {
            this.innerModel().withDefaultScope(defaultScope);
            return this;
        }
        this.updateParameters.withDefaultScope(defaultScope);
        return this;
    }

    @Override
    public AuthorizationServerContractImpl withBearerTokenSendingMethods(List<BearerTokenSendingMethod> bearerTokenSendingMethods) {
        if (this.isInCreateMode()) {
            this.innerModel().withBearerTokenSendingMethods(bearerTokenSendingMethods);
            return this;
        }
        this.updateParameters.withBearerTokenSendingMethods(bearerTokenSendingMethods);
        return this;
    }

    @Override
    public AuthorizationServerContractImpl withResourceOwnerUsername(String resourceOwnerUsername) {
        if (this.isInCreateMode()) {
            this.innerModel().withResourceOwnerUsername(resourceOwnerUsername);
            return this;
        }
        this.updateParameters.withResourceOwnerUsername(resourceOwnerUsername);
        return this;
    }

    @Override
    public AuthorizationServerContractImpl withResourceOwnerPassword(String resourceOwnerPassword) {
        if (this.isInCreateMode()) {
            this.innerModel().withResourceOwnerPassword(resourceOwnerPassword);
            return this;
        }
        this.updateParameters.withResourceOwnerPassword(resourceOwnerPassword);
        return this;
    }

    @Override
    public AuthorizationServerContractImpl withIfMatch(String ifMatch) {
        if (this.isInCreateMode()) {
            this.createIfMatch = ifMatch;
            return this;
        }
        this.updateIfMatch = ifMatch;
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel().id() == null;
    }
}

