/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.resourcemanager.apimanagement.ApiManagementManager;
import com.azure.resourcemanager.apimanagement.fluent.models.BackendContractInner;
import com.azure.resourcemanager.apimanagement.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.apimanagement.models.BackendContract;
import com.azure.resourcemanager.apimanagement.models.BackendCredentialsContract;
import com.azure.resourcemanager.apimanagement.models.BackendProperties;
import com.azure.resourcemanager.apimanagement.models.BackendProtocol;
import com.azure.resourcemanager.apimanagement.models.BackendProxyContract;
import com.azure.resourcemanager.apimanagement.models.BackendReconnectContract;
import com.azure.resourcemanager.apimanagement.models.BackendTlsProperties;
import com.azure.resourcemanager.apimanagement.models.BackendUpdateParameters;

public final class BackendContractImpl
implements BackendContract,
BackendContract.Definition,
BackendContract.Update {
    private BackendContractInner innerObject;
    private final ApiManagementManager serviceManager;
    private String resourceGroupName;
    private String serviceName;
    private String backendId;
    private String createIfMatch;
    private String updateIfMatch;
    private BackendUpdateParameters updateParameters;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String url() {
        return this.innerModel().url();
    }

    @Override
    public BackendProtocol protocol() {
        return this.innerModel().protocol();
    }

    @Override
    public String title() {
        return this.innerModel().title();
    }

    @Override
    public String description() {
        return this.innerModel().description();
    }

    @Override
    public String resourceId() {
        return this.innerModel().resourceId();
    }

    @Override
    public BackendProperties properties() {
        return this.innerModel().properties();
    }

    @Override
    public BackendCredentialsContract credentials() {
        return this.innerModel().credentials();
    }

    @Override
    public BackendProxyContract proxy() {
        return this.innerModel().proxy();
    }

    @Override
    public BackendTlsProperties tls() {
        return this.innerModel().tls();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public BackendContractInner innerModel() {
        return this.innerObject;
    }

    private ApiManagementManager manager() {
        return this.serviceManager;
    }

    @Override
    public BackendContractImpl withExistingService(String resourceGroupName, String serviceName) {
        this.resourceGroupName = resourceGroupName;
        this.serviceName = serviceName;
        return this;
    }

    @Override
    public BackendContract create() {
        this.innerObject = this.serviceManager.serviceClient().getBackends().createOrUpdateWithResponse(this.resourceGroupName, this.serviceName, this.backendId, this.innerModel(), this.createIfMatch, Context.NONE).getValue();
        return this;
    }

    @Override
    public BackendContract create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getBackends().createOrUpdateWithResponse(this.resourceGroupName, this.serviceName, this.backendId, this.innerModel(), this.createIfMatch, context).getValue();
        return this;
    }

    BackendContractImpl(String name, ApiManagementManager serviceManager) {
        this.innerObject = new BackendContractInner();
        this.serviceManager = serviceManager;
        this.backendId = name;
        this.createIfMatch = null;
    }

    @Override
    public BackendContractImpl update() {
        this.updateIfMatch = null;
        this.updateParameters = new BackendUpdateParameters();
        return this;
    }

    @Override
    public BackendContract apply() {
        this.innerObject = this.serviceManager.serviceClient().getBackends().updateWithResponse(this.resourceGroupName, this.serviceName, this.backendId, this.updateIfMatch, this.updateParameters, Context.NONE).getValue();
        return this;
    }

    @Override
    public BackendContract apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getBackends().updateWithResponse(this.resourceGroupName, this.serviceName, this.backendId, this.updateIfMatch, this.updateParameters, context).getValue();
        return this;
    }

    BackendContractImpl(BackendContractInner innerObject, ApiManagementManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.serviceName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "service");
        this.backendId = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "backends");
    }

    @Override
    public BackendContract refresh() {
        this.innerObject = this.serviceManager.serviceClient().getBackends().getWithResponse(this.resourceGroupName, this.serviceName, this.backendId, Context.NONE).getValue();
        return this;
    }

    @Override
    public BackendContract refresh(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getBackends().getWithResponse(this.resourceGroupName, this.serviceName, this.backendId, context).getValue();
        return this;
    }

    @Override
    public Response<Void> reconnectWithResponse(BackendReconnectContract parameters, Context context) {
        return this.serviceManager.backends().reconnectWithResponse(this.resourceGroupName, this.serviceName, this.backendId, parameters, context);
    }

    @Override
    public void reconnect() {
        this.serviceManager.backends().reconnect(this.resourceGroupName, this.serviceName, this.backendId);
    }

    @Override
    public BackendContractImpl withUrl(String url) {
        if (this.isInCreateMode()) {
            this.innerModel().withUrl(url);
            return this;
        }
        this.updateParameters.withUrl(url);
        return this;
    }

    @Override
    public BackendContractImpl withProtocol(BackendProtocol protocol) {
        if (this.isInCreateMode()) {
            this.innerModel().withProtocol(protocol);
            return this;
        }
        this.updateParameters.withProtocol(protocol);
        return this;
    }

    @Override
    public BackendContractImpl withTitle(String title) {
        if (this.isInCreateMode()) {
            this.innerModel().withTitle(title);
            return this;
        }
        this.updateParameters.withTitle(title);
        return this;
    }

    @Override
    public BackendContractImpl withDescription(String description) {
        if (this.isInCreateMode()) {
            this.innerModel().withDescription(description);
            return this;
        }
        this.updateParameters.withDescription(description);
        return this;
    }

    @Override
    public BackendContractImpl withResourceId(String resourceId) {
        if (this.isInCreateMode()) {
            this.innerModel().withResourceId(resourceId);
            return this;
        }
        this.updateParameters.withResourceId(resourceId);
        return this;
    }

    @Override
    public BackendContractImpl withProperties(BackendProperties properties) {
        if (this.isInCreateMode()) {
            this.innerModel().withProperties(properties);
            return this;
        }
        this.updateParameters.withProperties(properties);
        return this;
    }

    @Override
    public BackendContractImpl withCredentials(BackendCredentialsContract credentials) {
        if (this.isInCreateMode()) {
            this.innerModel().withCredentials(credentials);
            return this;
        }
        this.updateParameters.withCredentials(credentials);
        return this;
    }

    @Override
    public BackendContractImpl withProxy(BackendProxyContract proxy) {
        if (this.isInCreateMode()) {
            this.innerModel().withProxy(proxy);
            return this;
        }
        this.updateParameters.withProxy(proxy);
        return this;
    }

    @Override
    public BackendContractImpl withTls(BackendTlsProperties tls) {
        if (this.isInCreateMode()) {
            this.innerModel().withTls(tls);
            return this;
        }
        this.updateParameters.withTls(tls);
        return this;
    }

    @Override
    public BackendContractImpl withIfMatch(String ifMatch) {
        if (this.isInCreateMode()) {
            this.createIfMatch = ifMatch;
            return this;
        }
        this.updateIfMatch = ifMatch;
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel().id() == null;
    }
}

