/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.apimanagement.ApiManagementManager;
import com.azure.resourcemanager.apimanagement.fluent.GatewayCertificateAuthoritiesClient;
import com.azure.resourcemanager.apimanagement.fluent.models.GatewayCertificateAuthorityContractInner;
import com.azure.resourcemanager.apimanagement.implementation.GatewayCertificateAuthorityContractImpl;
import com.azure.resourcemanager.apimanagement.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.apimanagement.models.GatewayCertificateAuthorities;
import com.azure.resourcemanager.apimanagement.models.GatewayCertificateAuthoritiesGetEntityTagResponse;
import com.azure.resourcemanager.apimanagement.models.GatewayCertificateAuthoritiesGetResponse;
import com.azure.resourcemanager.apimanagement.models.GatewayCertificateAuthorityContract;

public final class GatewayCertificateAuthoritiesImpl
implements GatewayCertificateAuthorities {
    private static final ClientLogger LOGGER = new ClientLogger(GatewayCertificateAuthoritiesImpl.class);
    private final GatewayCertificateAuthoritiesClient innerClient;
    private final ApiManagementManager serviceManager;

    public GatewayCertificateAuthoritiesImpl(GatewayCertificateAuthoritiesClient innerClient, ApiManagementManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<GatewayCertificateAuthorityContract> listByService(String resourceGroupName, String serviceName, String gatewayId) {
        PagedIterable<GatewayCertificateAuthorityContractInner> inner = this.serviceClient().listByService(resourceGroupName, serviceName, gatewayId);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new GatewayCertificateAuthorityContractImpl((GatewayCertificateAuthorityContractInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<GatewayCertificateAuthorityContract> listByService(String resourceGroupName, String serviceName, String gatewayId, String filter, Integer top, Integer skip, Context context) {
        PagedIterable<GatewayCertificateAuthorityContractInner> inner = this.serviceClient().listByService(resourceGroupName, serviceName, gatewayId, filter, top, skip, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new GatewayCertificateAuthorityContractImpl((GatewayCertificateAuthorityContractInner)((Object)inner1), this.manager()));
    }

    @Override
    public GatewayCertificateAuthoritiesGetEntityTagResponse getEntityTagWithResponse(String resourceGroupName, String serviceName, String gatewayId, String certificateId, Context context) {
        return this.serviceClient().getEntityTagWithResponse(resourceGroupName, serviceName, gatewayId, certificateId, context);
    }

    @Override
    public void getEntityTag(String resourceGroupName, String serviceName, String gatewayId, String certificateId) {
        this.serviceClient().getEntityTag(resourceGroupName, serviceName, gatewayId, certificateId);
    }

    @Override
    public Response<GatewayCertificateAuthorityContract> getWithResponse(String resourceGroupName, String serviceName, String gatewayId, String certificateId, Context context) {
        GatewayCertificateAuthoritiesGetResponse inner = this.serviceClient().getWithResponse(resourceGroupName, serviceName, gatewayId, certificateId, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new GatewayCertificateAuthorityContractImpl(inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public GatewayCertificateAuthorityContract get(String resourceGroupName, String serviceName, String gatewayId, String certificateId) {
        GatewayCertificateAuthorityContractInner inner = this.serviceClient().get(resourceGroupName, serviceName, gatewayId, certificateId);
        if (inner != null) {
            return new GatewayCertificateAuthorityContractImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Void> deleteWithResponse(String resourceGroupName, String serviceName, String gatewayId, String certificateId, String ifMatch, Context context) {
        return this.serviceClient().deleteWithResponse(resourceGroupName, serviceName, gatewayId, certificateId, ifMatch, context);
    }

    @Override
    public void delete(String resourceGroupName, String serviceName, String gatewayId, String certificateId, String ifMatch) {
        this.serviceClient().delete(resourceGroupName, serviceName, gatewayId, certificateId, ifMatch);
    }

    @Override
    public GatewayCertificateAuthorityContract getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String gatewayId = ResourceManagerUtils.getValueFromIdByName(id, "gateways");
        if (gatewayId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'gateways'.", id)));
        }
        String certificateId = ResourceManagerUtils.getValueFromIdByName(id, "certificateAuthorities");
        if (certificateId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'certificateAuthorities'.", id)));
        }
        return (GatewayCertificateAuthorityContract)this.getWithResponse(resourceGroupName, serviceName, gatewayId, certificateId, Context.NONE).getValue();
    }

    @Override
    public Response<GatewayCertificateAuthorityContract> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String gatewayId = ResourceManagerUtils.getValueFromIdByName(id, "gateways");
        if (gatewayId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'gateways'.", id)));
        }
        String certificateId = ResourceManagerUtils.getValueFromIdByName(id, "certificateAuthorities");
        if (certificateId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'certificateAuthorities'.", id)));
        }
        return this.getWithResponse(resourceGroupName, serviceName, gatewayId, certificateId, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String gatewayId = ResourceManagerUtils.getValueFromIdByName(id, "gateways");
        if (gatewayId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'gateways'.", id)));
        }
        String certificateId = ResourceManagerUtils.getValueFromIdByName(id, "certificateAuthorities");
        if (certificateId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'certificateAuthorities'.", id)));
        }
        String localIfMatch = null;
        this.deleteWithResponse(resourceGroupName, serviceName, gatewayId, certificateId, localIfMatch, Context.NONE);
    }

    @Override
    public Response<Void> deleteByIdWithResponse(String id, String ifMatch, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String gatewayId = ResourceManagerUtils.getValueFromIdByName(id, "gateways");
        if (gatewayId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'gateways'.", id)));
        }
        String certificateId = ResourceManagerUtils.getValueFromIdByName(id, "certificateAuthorities");
        if (certificateId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'certificateAuthorities'.", id)));
        }
        return this.deleteWithResponse(resourceGroupName, serviceName, gatewayId, certificateId, ifMatch, context);
    }

    private GatewayCertificateAuthoritiesClient serviceClient() {
        return this.innerClient;
    }

    private ApiManagementManager manager() {
        return this.serviceManager;
    }

    @Override
    public GatewayCertificateAuthorityContractImpl define(String name) {
        return new GatewayCertificateAuthorityContractImpl(name, this.manager());
    }
}

