/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.util.Context;
import com.azure.resourcemanager.apimanagement.ApiManagementManager;
import com.azure.resourcemanager.apimanagement.fluent.models.GatewayCertificateAuthorityContractInner;
import com.azure.resourcemanager.apimanagement.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.apimanagement.models.GatewayCertificateAuthorityContract;

public final class GatewayCertificateAuthorityContractImpl
implements GatewayCertificateAuthorityContract,
GatewayCertificateAuthorityContract.Definition,
GatewayCertificateAuthorityContract.Update {
    private GatewayCertificateAuthorityContractInner innerObject;
    private final ApiManagementManager serviceManager;
    private String resourceGroupName;
    private String serviceName;
    private String gatewayId;
    private String certificateId;
    private String createIfMatch;
    private String updateIfMatch;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public Boolean isTrusted() {
        return this.innerModel().isTrusted();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public GatewayCertificateAuthorityContractInner innerModel() {
        return this.innerObject;
    }

    private ApiManagementManager manager() {
        return this.serviceManager;
    }

    @Override
    public GatewayCertificateAuthorityContractImpl withExistingGateway(String resourceGroupName, String serviceName, String gatewayId) {
        this.resourceGroupName = resourceGroupName;
        this.serviceName = serviceName;
        this.gatewayId = gatewayId;
        return this;
    }

    @Override
    public GatewayCertificateAuthorityContract create() {
        this.innerObject = this.serviceManager.serviceClient().getGatewayCertificateAuthorities().createOrUpdateWithResponse(this.resourceGroupName, this.serviceName, this.gatewayId, this.certificateId, this.innerModel(), this.createIfMatch, Context.NONE).getValue();
        return this;
    }

    @Override
    public GatewayCertificateAuthorityContract create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getGatewayCertificateAuthorities().createOrUpdateWithResponse(this.resourceGroupName, this.serviceName, this.gatewayId, this.certificateId, this.innerModel(), this.createIfMatch, context).getValue();
        return this;
    }

    GatewayCertificateAuthorityContractImpl(String name, ApiManagementManager serviceManager) {
        this.innerObject = new GatewayCertificateAuthorityContractInner();
        this.serviceManager = serviceManager;
        this.certificateId = name;
        this.createIfMatch = null;
    }

    @Override
    public GatewayCertificateAuthorityContractImpl update() {
        this.updateIfMatch = null;
        return this;
    }

    @Override
    public GatewayCertificateAuthorityContract apply() {
        this.innerObject = this.serviceManager.serviceClient().getGatewayCertificateAuthorities().createOrUpdateWithResponse(this.resourceGroupName, this.serviceName, this.gatewayId, this.certificateId, this.innerModel(), this.updateIfMatch, Context.NONE).getValue();
        return this;
    }

    @Override
    public GatewayCertificateAuthorityContract apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getGatewayCertificateAuthorities().createOrUpdateWithResponse(this.resourceGroupName, this.serviceName, this.gatewayId, this.certificateId, this.innerModel(), this.updateIfMatch, context).getValue();
        return this;
    }

    GatewayCertificateAuthorityContractImpl(GatewayCertificateAuthorityContractInner innerObject, ApiManagementManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.serviceName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "service");
        this.gatewayId = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "gateways");
        this.certificateId = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "certificateAuthorities");
    }

    @Override
    public GatewayCertificateAuthorityContract refresh() {
        this.innerObject = this.serviceManager.serviceClient().getGatewayCertificateAuthorities().getWithResponse(this.resourceGroupName, this.serviceName, this.gatewayId, this.certificateId, Context.NONE).getValue();
        return this;
    }

    @Override
    public GatewayCertificateAuthorityContract refresh(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getGatewayCertificateAuthorities().getWithResponse(this.resourceGroupName, this.serviceName, this.gatewayId, this.certificateId, context).getValue();
        return this;
    }

    @Override
    public GatewayCertificateAuthorityContractImpl withIsTrusted(Boolean isTrusted) {
        this.innerModel().withIsTrusted(isTrusted);
        return this;
    }

    @Override
    public GatewayCertificateAuthorityContractImpl withIfMatch(String ifMatch) {
        if (this.isInCreateMode()) {
            this.createIfMatch = ifMatch;
            return this;
        }
        this.updateIfMatch = ifMatch;
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel().id() == null;
    }
}

