/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.resourcemanager.apimanagement.ApiManagementManager;
import com.azure.resourcemanager.apimanagement.fluent.models.GatewayContractInner;
import com.azure.resourcemanager.apimanagement.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.apimanagement.models.GatewayContract;
import com.azure.resourcemanager.apimanagement.models.GatewayKeyRegenerationRequestContract;
import com.azure.resourcemanager.apimanagement.models.GatewayKeysContract;
import com.azure.resourcemanager.apimanagement.models.GatewayTokenContract;
import com.azure.resourcemanager.apimanagement.models.GatewayTokenRequestContract;
import com.azure.resourcemanager.apimanagement.models.ResourceLocationDataContract;

public final class GatewayContractImpl
implements GatewayContract,
GatewayContract.Definition,
GatewayContract.Update {
    private GatewayContractInner innerObject;
    private final ApiManagementManager serviceManager;
    private String resourceGroupName;
    private String serviceName;
    private String gatewayId;
    private String createIfMatch;
    private String updateIfMatch;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public ResourceLocationDataContract locationData() {
        return this.innerModel().locationData();
    }

    @Override
    public String description() {
        return this.innerModel().description();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public GatewayContractInner innerModel() {
        return this.innerObject;
    }

    private ApiManagementManager manager() {
        return this.serviceManager;
    }

    @Override
    public GatewayContractImpl withExistingService(String resourceGroupName, String serviceName) {
        this.resourceGroupName = resourceGroupName;
        this.serviceName = serviceName;
        return this;
    }

    @Override
    public GatewayContract create() {
        this.innerObject = this.serviceManager.serviceClient().getGateways().createOrUpdateWithResponse(this.resourceGroupName, this.serviceName, this.gatewayId, this.innerModel(), this.createIfMatch, Context.NONE).getValue();
        return this;
    }

    @Override
    public GatewayContract create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getGateways().createOrUpdateWithResponse(this.resourceGroupName, this.serviceName, this.gatewayId, this.innerModel(), this.createIfMatch, context).getValue();
        return this;
    }

    GatewayContractImpl(String name, ApiManagementManager serviceManager) {
        this.innerObject = new GatewayContractInner();
        this.serviceManager = serviceManager;
        this.gatewayId = name;
        this.createIfMatch = null;
    }

    @Override
    public GatewayContractImpl update() {
        this.updateIfMatch = null;
        return this;
    }

    @Override
    public GatewayContract apply() {
        this.innerObject = this.serviceManager.serviceClient().getGateways().updateWithResponse(this.resourceGroupName, this.serviceName, this.gatewayId, this.updateIfMatch, this.innerModel(), Context.NONE).getValue();
        return this;
    }

    @Override
    public GatewayContract apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getGateways().updateWithResponse(this.resourceGroupName, this.serviceName, this.gatewayId, this.updateIfMatch, this.innerModel(), context).getValue();
        return this;
    }

    GatewayContractImpl(GatewayContractInner innerObject, ApiManagementManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.serviceName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "service");
        this.gatewayId = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "gateways");
    }

    @Override
    public GatewayContract refresh() {
        this.innerObject = this.serviceManager.serviceClient().getGateways().getWithResponse(this.resourceGroupName, this.serviceName, this.gatewayId, Context.NONE).getValue();
        return this;
    }

    @Override
    public GatewayContract refresh(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getGateways().getWithResponse(this.resourceGroupName, this.serviceName, this.gatewayId, context).getValue();
        return this;
    }

    @Override
    public Response<GatewayKeysContract> listKeysWithResponse(Context context) {
        return this.serviceManager.gateways().listKeysWithResponse(this.resourceGroupName, this.serviceName, this.gatewayId, context);
    }

    @Override
    public GatewayKeysContract listKeys() {
        return this.serviceManager.gateways().listKeys(this.resourceGroupName, this.serviceName, this.gatewayId);
    }

    @Override
    public Response<Void> regenerateKeyWithResponse(GatewayKeyRegenerationRequestContract parameters, Context context) {
        return this.serviceManager.gateways().regenerateKeyWithResponse(this.resourceGroupName, this.serviceName, this.gatewayId, parameters, context);
    }

    @Override
    public void regenerateKey(GatewayKeyRegenerationRequestContract parameters) {
        this.serviceManager.gateways().regenerateKey(this.resourceGroupName, this.serviceName, this.gatewayId, parameters);
    }

    @Override
    public Response<GatewayTokenContract> generateTokenWithResponse(GatewayTokenRequestContract parameters, Context context) {
        return this.serviceManager.gateways().generateTokenWithResponse(this.resourceGroupName, this.serviceName, this.gatewayId, parameters, context);
    }

    @Override
    public GatewayTokenContract generateToken(GatewayTokenRequestContract parameters) {
        return this.serviceManager.gateways().generateToken(this.resourceGroupName, this.serviceName, this.gatewayId, parameters);
    }

    @Override
    public GatewayContractImpl withLocationData(ResourceLocationDataContract locationData) {
        this.innerModel().withLocationData(locationData);
        return this;
    }

    @Override
    public GatewayContractImpl withDescription(String description) {
        this.innerModel().withDescription(description);
        return this;
    }

    @Override
    public GatewayContractImpl withIfMatch(String ifMatch) {
        if (this.isInCreateMode()) {
            this.createIfMatch = ifMatch;
            return this;
        }
        this.updateIfMatch = ifMatch;
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel().id() == null;
    }
}

