/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.util.Context;
import com.azure.resourcemanager.apimanagement.ApiManagementManager;
import com.azure.resourcemanager.apimanagement.fluent.models.GlobalSchemaContractInner;
import com.azure.resourcemanager.apimanagement.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.apimanagement.models.GlobalSchemaContract;
import com.azure.resourcemanager.apimanagement.models.SchemaType;

public final class GlobalSchemaContractImpl
implements GlobalSchemaContract,
GlobalSchemaContract.Definition,
GlobalSchemaContract.Update {
    private GlobalSchemaContractInner innerObject;
    private final ApiManagementManager serviceManager;
    private String resourceGroupName;
    private String serviceName;
    private String schemaId;
    private String createIfMatch;
    private String updateIfMatch;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public SchemaType schemaType() {
        return this.innerModel().schemaType();
    }

    @Override
    public String description() {
        return this.innerModel().description();
    }

    @Override
    public Object value() {
        return this.innerModel().value();
    }

    @Override
    public Object document() {
        return this.innerModel().document();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public GlobalSchemaContractInner innerModel() {
        return this.innerObject;
    }

    private ApiManagementManager manager() {
        return this.serviceManager;
    }

    @Override
    public GlobalSchemaContractImpl withExistingService(String resourceGroupName, String serviceName) {
        this.resourceGroupName = resourceGroupName;
        this.serviceName = serviceName;
        return this;
    }

    @Override
    public GlobalSchemaContract create() {
        this.innerObject = this.serviceManager.serviceClient().getGlobalSchemas().createOrUpdate(this.resourceGroupName, this.serviceName, this.schemaId, this.innerModel(), this.createIfMatch, Context.NONE);
        return this;
    }

    @Override
    public GlobalSchemaContract create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getGlobalSchemas().createOrUpdate(this.resourceGroupName, this.serviceName, this.schemaId, this.innerModel(), this.createIfMatch, context);
        return this;
    }

    GlobalSchemaContractImpl(String name, ApiManagementManager serviceManager) {
        this.innerObject = new GlobalSchemaContractInner();
        this.serviceManager = serviceManager;
        this.schemaId = name;
        this.createIfMatch = null;
    }

    @Override
    public GlobalSchemaContractImpl update() {
        this.updateIfMatch = null;
        return this;
    }

    @Override
    public GlobalSchemaContract apply() {
        this.innerObject = this.serviceManager.serviceClient().getGlobalSchemas().createOrUpdate(this.resourceGroupName, this.serviceName, this.schemaId, this.innerModel(), this.updateIfMatch, Context.NONE);
        return this;
    }

    @Override
    public GlobalSchemaContract apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getGlobalSchemas().createOrUpdate(this.resourceGroupName, this.serviceName, this.schemaId, this.innerModel(), this.updateIfMatch, context);
        return this;
    }

    GlobalSchemaContractImpl(GlobalSchemaContractInner innerObject, ApiManagementManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.serviceName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "service");
        this.schemaId = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "schemas");
    }

    @Override
    public GlobalSchemaContract refresh() {
        this.innerObject = this.serviceManager.serviceClient().getGlobalSchemas().getWithResponse(this.resourceGroupName, this.serviceName, this.schemaId, Context.NONE).getValue();
        return this;
    }

    @Override
    public GlobalSchemaContract refresh(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getGlobalSchemas().getWithResponse(this.resourceGroupName, this.serviceName, this.schemaId, context).getValue();
        return this;
    }

    @Override
    public GlobalSchemaContractImpl withSchemaType(SchemaType schemaType) {
        this.innerModel().withSchemaType(schemaType);
        return this;
    }

    @Override
    public GlobalSchemaContractImpl withDescription(String description) {
        this.innerModel().withDescription(description);
        return this;
    }

    @Override
    public GlobalSchemaContractImpl withValue(Object value) {
        this.innerModel().withValue(value);
        return this;
    }

    @Override
    public GlobalSchemaContractImpl withDocument(Object document) {
        this.innerModel().withDocument(document);
        return this;
    }

    @Override
    public GlobalSchemaContractImpl withIfMatch(String ifMatch) {
        if (this.isInCreateMode()) {
            this.createIfMatch = ifMatch;
            return this;
        }
        this.updateIfMatch = ifMatch;
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel().id() == null;
    }
}

