/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.apimanagement.ApiManagementManager;
import com.azure.resourcemanager.apimanagement.fluent.GraphQLApiResolverPoliciesClient;
import com.azure.resourcemanager.apimanagement.fluent.models.PolicyContractInner;
import com.azure.resourcemanager.apimanagement.implementation.PolicyContractImpl;
import com.azure.resourcemanager.apimanagement.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.apimanagement.models.GraphQLApiResolverPolicies;
import com.azure.resourcemanager.apimanagement.models.GraphQLApiResolverPoliciesCreateOrUpdateResponse;
import com.azure.resourcemanager.apimanagement.models.GraphQLApiResolverPoliciesGetEntityTagResponse;
import com.azure.resourcemanager.apimanagement.models.GraphQLApiResolverPoliciesGetResponse;
import com.azure.resourcemanager.apimanagement.models.PolicyContract;
import com.azure.resourcemanager.apimanagement.models.PolicyExportFormat;
import com.azure.resourcemanager.apimanagement.models.PolicyIdName;

public final class GraphQLApiResolverPoliciesImpl
implements GraphQLApiResolverPolicies {
    private static final ClientLogger LOGGER = new ClientLogger(GraphQLApiResolverPoliciesImpl.class);
    private final GraphQLApiResolverPoliciesClient innerClient;
    private final ApiManagementManager serviceManager;

    public GraphQLApiResolverPoliciesImpl(GraphQLApiResolverPoliciesClient innerClient, ApiManagementManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<PolicyContract> listByResolver(String resourceGroupName, String serviceName, String apiId, String resolverId) {
        PagedIterable<PolicyContractInner> inner = this.serviceClient().listByResolver(resourceGroupName, serviceName, apiId, resolverId);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new PolicyContractImpl((PolicyContractInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<PolicyContract> listByResolver(String resourceGroupName, String serviceName, String apiId, String resolverId, Context context) {
        PagedIterable<PolicyContractInner> inner = this.serviceClient().listByResolver(resourceGroupName, serviceName, apiId, resolverId, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new PolicyContractImpl((PolicyContractInner)((Object)inner1), this.manager()));
    }

    @Override
    public GraphQLApiResolverPoliciesGetEntityTagResponse getEntityTagWithResponse(String resourceGroupName, String serviceName, String apiId, String resolverId, PolicyIdName policyId, Context context) {
        return this.serviceClient().getEntityTagWithResponse(resourceGroupName, serviceName, apiId, resolverId, policyId, context);
    }

    @Override
    public void getEntityTag(String resourceGroupName, String serviceName, String apiId, String resolverId, PolicyIdName policyId) {
        this.serviceClient().getEntityTag(resourceGroupName, serviceName, apiId, resolverId, policyId);
    }

    @Override
    public Response<PolicyContract> getWithResponse(String resourceGroupName, String serviceName, String apiId, String resolverId, PolicyIdName policyId, PolicyExportFormat format, Context context) {
        GraphQLApiResolverPoliciesGetResponse inner = this.serviceClient().getWithResponse(resourceGroupName, serviceName, apiId, resolverId, policyId, format, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new PolicyContractImpl(inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public PolicyContract get(String resourceGroupName, String serviceName, String apiId, String resolverId, PolicyIdName policyId) {
        PolicyContractInner inner = this.serviceClient().get(resourceGroupName, serviceName, apiId, resolverId, policyId);
        if (inner != null) {
            return new PolicyContractImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<PolicyContract> createOrUpdateWithResponse(String resourceGroupName, String serviceName, String apiId, String resolverId, PolicyIdName policyId, PolicyContractInner parameters, String ifMatch, Context context) {
        GraphQLApiResolverPoliciesCreateOrUpdateResponse inner = this.serviceClient().createOrUpdateWithResponse(resourceGroupName, serviceName, apiId, resolverId, policyId, parameters, ifMatch, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new PolicyContractImpl(inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public PolicyContract createOrUpdate(String resourceGroupName, String serviceName, String apiId, String resolverId, PolicyIdName policyId, PolicyContractInner parameters) {
        PolicyContractInner inner = this.serviceClient().createOrUpdate(resourceGroupName, serviceName, apiId, resolverId, policyId, parameters);
        if (inner != null) {
            return new PolicyContractImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Void> deleteWithResponse(String resourceGroupName, String serviceName, String apiId, String resolverId, PolicyIdName policyId, String ifMatch, Context context) {
        return this.serviceClient().deleteWithResponse(resourceGroupName, serviceName, apiId, resolverId, policyId, ifMatch, context);
    }

    @Override
    public void delete(String resourceGroupName, String serviceName, String apiId, String resolverId, PolicyIdName policyId, String ifMatch) {
        this.serviceClient().delete(resourceGroupName, serviceName, apiId, resolverId, policyId, ifMatch);
    }

    private GraphQLApiResolverPoliciesClient serviceClient() {
        return this.innerClient;
    }

    private ApiManagementManager manager() {
        return this.serviceManager;
    }
}

