/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.apimanagement.ApiManagementManager;
import com.azure.resourcemanager.apimanagement.fluent.IssuesClient;
import com.azure.resourcemanager.apimanagement.fluent.models.IssueContractInner;
import com.azure.resourcemanager.apimanagement.implementation.IssueContractImpl;
import com.azure.resourcemanager.apimanagement.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.apimanagement.models.IssueContract;
import com.azure.resourcemanager.apimanagement.models.Issues;
import com.azure.resourcemanager.apimanagement.models.IssuesGetResponse;

public final class IssuesImpl
implements Issues {
    private static final ClientLogger LOGGER = new ClientLogger(IssuesImpl.class);
    private final IssuesClient innerClient;
    private final ApiManagementManager serviceManager;

    public IssuesImpl(IssuesClient innerClient, ApiManagementManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<IssueContract> listByService(String resourceGroupName, String serviceName) {
        PagedIterable<IssueContractInner> inner = this.serviceClient().listByService(resourceGroupName, serviceName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new IssueContractImpl((IssueContractInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<IssueContract> listByService(String resourceGroupName, String serviceName, String filter, Integer top, Integer skip, Context context) {
        PagedIterable<IssueContractInner> inner = this.serviceClient().listByService(resourceGroupName, serviceName, filter, top, skip, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new IssueContractImpl((IssueContractInner)((Object)inner1), this.manager()));
    }

    @Override
    public Response<IssueContract> getWithResponse(String resourceGroupName, String serviceName, String issueId, Context context) {
        IssuesGetResponse inner = this.serviceClient().getWithResponse(resourceGroupName, serviceName, issueId, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new IssueContractImpl(inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public IssueContract get(String resourceGroupName, String serviceName, String issueId) {
        IssueContractInner inner = this.serviceClient().get(resourceGroupName, serviceName, issueId);
        if (inner != null) {
            return new IssueContractImpl(inner, this.manager());
        }
        return null;
    }

    private IssuesClient serviceClient() {
        return this.innerClient;
    }

    private ApiManagementManager manager() {
        return this.serviceManager;
    }
}

