/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.util.Context;
import com.azure.resourcemanager.apimanagement.ApiManagementManager;
import com.azure.resourcemanager.apimanagement.fluent.models.LoggerContractInner;
import com.azure.resourcemanager.apimanagement.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.apimanagement.models.LoggerContract;
import com.azure.resourcemanager.apimanagement.models.LoggerType;
import com.azure.resourcemanager.apimanagement.models.LoggerUpdateContract;
import java.util.Collections;
import java.util.Map;

public final class LoggerContractImpl
implements LoggerContract,
LoggerContract.Definition,
LoggerContract.Update {
    private LoggerContractInner innerObject;
    private final ApiManagementManager serviceManager;
    private String resourceGroupName;
    private String serviceName;
    private String loggerId;
    private String createIfMatch;
    private String updateIfMatch;
    private LoggerUpdateContract updateParameters;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public LoggerType loggerType() {
        return this.innerModel().loggerType();
    }

    @Override
    public String description() {
        return this.innerModel().description();
    }

    @Override
    public Map<String, String> credentials() {
        Map<String, String> inner = this.innerModel().credentials();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        }
        return Collections.emptyMap();
    }

    @Override
    public Boolean isBuffered() {
        return this.innerModel().isBuffered();
    }

    @Override
    public String resourceId() {
        return this.innerModel().resourceId();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public LoggerContractInner innerModel() {
        return this.innerObject;
    }

    private ApiManagementManager manager() {
        return this.serviceManager;
    }

    @Override
    public LoggerContractImpl withExistingService(String resourceGroupName, String serviceName) {
        this.resourceGroupName = resourceGroupName;
        this.serviceName = serviceName;
        return this;
    }

    @Override
    public LoggerContract create() {
        this.innerObject = this.serviceManager.serviceClient().getLoggers().createOrUpdateWithResponse(this.resourceGroupName, this.serviceName, this.loggerId, this.innerModel(), this.createIfMatch, Context.NONE).getValue();
        return this;
    }

    @Override
    public LoggerContract create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getLoggers().createOrUpdateWithResponse(this.resourceGroupName, this.serviceName, this.loggerId, this.innerModel(), this.createIfMatch, context).getValue();
        return this;
    }

    LoggerContractImpl(String name, ApiManagementManager serviceManager) {
        this.innerObject = new LoggerContractInner();
        this.serviceManager = serviceManager;
        this.loggerId = name;
        this.createIfMatch = null;
    }

    @Override
    public LoggerContractImpl update() {
        this.updateIfMatch = null;
        this.updateParameters = new LoggerUpdateContract();
        return this;
    }

    @Override
    public LoggerContract apply() {
        this.innerObject = this.serviceManager.serviceClient().getLoggers().updateWithResponse(this.resourceGroupName, this.serviceName, this.loggerId, this.updateIfMatch, this.updateParameters, Context.NONE).getValue();
        return this;
    }

    @Override
    public LoggerContract apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getLoggers().updateWithResponse(this.resourceGroupName, this.serviceName, this.loggerId, this.updateIfMatch, this.updateParameters, context).getValue();
        return this;
    }

    LoggerContractImpl(LoggerContractInner innerObject, ApiManagementManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.serviceName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "service");
        this.loggerId = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "loggers");
    }

    @Override
    public LoggerContract refresh() {
        this.innerObject = this.serviceManager.serviceClient().getLoggers().getWithResponse(this.resourceGroupName, this.serviceName, this.loggerId, Context.NONE).getValue();
        return this;
    }

    @Override
    public LoggerContract refresh(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getLoggers().getWithResponse(this.resourceGroupName, this.serviceName, this.loggerId, context).getValue();
        return this;
    }

    @Override
    public LoggerContractImpl withLoggerType(LoggerType loggerType) {
        if (this.isInCreateMode()) {
            this.innerModel().withLoggerType(loggerType);
            return this;
        }
        this.updateParameters.withLoggerType(loggerType);
        return this;
    }

    @Override
    public LoggerContractImpl withDescription(String description) {
        if (this.isInCreateMode()) {
            this.innerModel().withDescription(description);
            return this;
        }
        this.updateParameters.withDescription(description);
        return this;
    }

    @Override
    public LoggerContractImpl withCredentials(Map<String, String> credentials) {
        if (this.isInCreateMode()) {
            this.innerModel().withCredentials(credentials);
            return this;
        }
        this.updateParameters.withCredentials(credentials);
        return this;
    }

    @Override
    public LoggerContractImpl withIsBuffered(Boolean isBuffered) {
        if (this.isInCreateMode()) {
            this.innerModel().withIsBuffered(isBuffered);
            return this;
        }
        this.updateParameters.withIsBuffered(isBuffered);
        return this;
    }

    @Override
    public LoggerContractImpl withResourceId(String resourceId) {
        this.innerModel().withResourceId(resourceId);
        return this;
    }

    @Override
    public LoggerContractImpl withIfMatch(String ifMatch) {
        if (this.isInCreateMode()) {
            this.createIfMatch = ifMatch;
            return this;
        }
        this.updateIfMatch = ifMatch;
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel().id() == null;
    }
}

