/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.resourcemanager.apimanagement.ApiManagementManager;
import com.azure.resourcemanager.apimanagement.fluent.models.NamedValueContractInner;
import com.azure.resourcemanager.apimanagement.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.apimanagement.models.KeyVaultContractCreateProperties;
import com.azure.resourcemanager.apimanagement.models.KeyVaultContractProperties;
import com.azure.resourcemanager.apimanagement.models.NamedValueContract;
import com.azure.resourcemanager.apimanagement.models.NamedValueCreateContract;
import com.azure.resourcemanager.apimanagement.models.NamedValueSecretContract;
import com.azure.resourcemanager.apimanagement.models.NamedValueUpdateParameters;
import java.util.Collections;
import java.util.List;

public final class NamedValueContractImpl
implements NamedValueContract,
NamedValueContract.Definition,
NamedValueContract.Update {
    private NamedValueContractInner innerObject;
    private final ApiManagementManager serviceManager;
    private String resourceGroupName;
    private String serviceName;
    private String namedValueId;
    private String createIfMatch;
    private NamedValueCreateContract createParameters;
    private String updateIfMatch;
    private NamedValueUpdateParameters updateParameters;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String displayName() {
        return this.innerModel().displayName();
    }

    @Override
    public String value() {
        return this.innerModel().value();
    }

    @Override
    public KeyVaultContractProperties keyVault() {
        return this.innerModel().keyVault();
    }

    @Override
    public List<String> tags() {
        List<String> inner = this.innerModel().tags();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public Boolean secret() {
        return this.innerModel().secret();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public NamedValueContractInner innerModel() {
        return this.innerObject;
    }

    private ApiManagementManager manager() {
        return this.serviceManager;
    }

    @Override
    public NamedValueContractImpl withExistingService(String resourceGroupName, String serviceName) {
        this.resourceGroupName = resourceGroupName;
        this.serviceName = serviceName;
        return this;
    }

    @Override
    public NamedValueContract create() {
        this.innerObject = this.serviceManager.serviceClient().getNamedValues().createOrUpdate(this.resourceGroupName, this.serviceName, this.namedValueId, this.createParameters, this.createIfMatch, Context.NONE);
        return this;
    }

    @Override
    public NamedValueContract create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getNamedValues().createOrUpdate(this.resourceGroupName, this.serviceName, this.namedValueId, this.createParameters, this.createIfMatch, context);
        return this;
    }

    NamedValueContractImpl(String name, ApiManagementManager serviceManager) {
        this.innerObject = new NamedValueContractInner();
        this.serviceManager = serviceManager;
        this.namedValueId = name;
        this.createIfMatch = null;
        this.createParameters = new NamedValueCreateContract();
    }

    @Override
    public NamedValueContractImpl update() {
        this.updateIfMatch = null;
        this.updateParameters = new NamedValueUpdateParameters();
        return this;
    }

    @Override
    public NamedValueContract apply() {
        this.innerObject = this.serviceManager.serviceClient().getNamedValues().update(this.resourceGroupName, this.serviceName, this.namedValueId, this.updateIfMatch, this.updateParameters, Context.NONE);
        return this;
    }

    @Override
    public NamedValueContract apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getNamedValues().update(this.resourceGroupName, this.serviceName, this.namedValueId, this.updateIfMatch, this.updateParameters, context);
        return this;
    }

    NamedValueContractImpl(NamedValueContractInner innerObject, ApiManagementManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.serviceName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "service");
        this.namedValueId = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "namedValues");
    }

    @Override
    public NamedValueContract refresh() {
        this.innerObject = this.serviceManager.serviceClient().getNamedValues().getWithResponse(this.resourceGroupName, this.serviceName, this.namedValueId, Context.NONE).getValue();
        return this;
    }

    @Override
    public NamedValueContract refresh(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getNamedValues().getWithResponse(this.resourceGroupName, this.serviceName, this.namedValueId, context).getValue();
        return this;
    }

    @Override
    public Response<NamedValueSecretContract> listValueWithResponse(Context context) {
        return this.serviceManager.namedValues().listValueWithResponse(this.resourceGroupName, this.serviceName, this.namedValueId, context);
    }

    @Override
    public NamedValueSecretContract listValue() {
        return this.serviceManager.namedValues().listValue(this.resourceGroupName, this.serviceName, this.namedValueId);
    }

    @Override
    public NamedValueContract refreshSecret() {
        return this.serviceManager.namedValues().refreshSecret(this.resourceGroupName, this.serviceName, this.namedValueId);
    }

    @Override
    public NamedValueContract refreshSecret(Context context) {
        return this.serviceManager.namedValues().refreshSecret(this.resourceGroupName, this.serviceName, this.namedValueId, context);
    }

    @Override
    public NamedValueContractImpl withTags(List<String> tags) {
        if (this.isInCreateMode()) {
            this.createParameters.withTags(tags);
            return this;
        }
        this.updateParameters.withTags(tags);
        return this;
    }

    @Override
    public NamedValueContractImpl withDisplayName(String displayName) {
        if (this.isInCreateMode()) {
            this.createParameters.withDisplayName(displayName);
            return this;
        }
        this.updateParameters.withDisplayName(displayName);
        return this;
    }

    @Override
    public NamedValueContractImpl withValue(String value) {
        if (this.isInCreateMode()) {
            this.createParameters.withValue(value);
            return this;
        }
        this.updateParameters.withValue(value);
        return this;
    }

    @Override
    public NamedValueContractImpl withKeyVault(KeyVaultContractCreateProperties keyVault) {
        if (this.isInCreateMode()) {
            this.createParameters.withKeyVault(keyVault);
            return this;
        }
        this.updateParameters.withKeyVault(keyVault);
        return this;
    }

    @Override
    public NamedValueContractImpl withSecret(Boolean secret) {
        if (this.isInCreateMode()) {
            this.createParameters.withSecret(secret);
            return this;
        }
        this.updateParameters.withSecret(secret);
        return this;
    }

    @Override
    public NamedValueContractImpl withIfMatch(String ifMatch) {
        if (this.isInCreateMode()) {
            this.createIfMatch = ifMatch;
            return this;
        }
        this.updateIfMatch = ifMatch;
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel().id() == null;
    }
}

