/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.Head;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.apimanagement.fluent.NamedValuesClient;
import com.azure.resourcemanager.apimanagement.fluent.models.NamedValueContractInner;
import com.azure.resourcemanager.apimanagement.fluent.models.NamedValueSecretContractInner;
import com.azure.resourcemanager.apimanagement.implementation.ApiManagementClientImpl;
import com.azure.resourcemanager.apimanagement.models.NamedValueCollection;
import com.azure.resourcemanager.apimanagement.models.NamedValueCreateContract;
import com.azure.resourcemanager.apimanagement.models.NamedValueUpdateParameters;
import com.azure.resourcemanager.apimanagement.models.NamedValuesGetEntityTagResponse;
import com.azure.resourcemanager.apimanagement.models.NamedValuesGetResponse;
import com.azure.resourcemanager.apimanagement.models.NamedValuesListValueResponse;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class NamedValuesClientImpl
implements NamedValuesClient {
    private final NamedValuesService service;
    private final ApiManagementClientImpl client;

    NamedValuesClientImpl(ApiManagementClientImpl client) {
        this.service = (NamedValuesService)RestProxy.create(NamedValuesService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<NamedValueContractInner>> listByServiceSinglePageAsync(String resourceGroupName, String serviceName, String filter, Integer top, Integer skip, Boolean isKeyVaultRefreshFailed) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByService(this.client.getEndpoint(), resourceGroupName, serviceName, filter, top, skip, isKeyVaultRefreshFailed, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((NamedValueCollection)res.getValue()).value(), ((NamedValueCollection)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<NamedValueContractInner>> listByServiceSinglePageAsync(String resourceGroupName, String serviceName, String filter, Integer top, Integer skip, Boolean isKeyVaultRefreshFailed, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByService(this.client.getEndpoint(), resourceGroupName, serviceName, filter, top, skip, isKeyVaultRefreshFailed, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((NamedValueCollection)res.getValue()).value(), ((NamedValueCollection)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<NamedValueContractInner> listByServiceAsync(String resourceGroupName, String serviceName, String filter, Integer top, Integer skip, Boolean isKeyVaultRefreshFailed) {
        return new PagedFlux(() -> this.listByServiceSinglePageAsync(resourceGroupName, serviceName, filter, top, skip, isKeyVaultRefreshFailed), nextLink -> this.listByServiceNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<NamedValueContractInner> listByServiceAsync(String resourceGroupName, String serviceName) {
        String filter = null;
        Integer top = null;
        Integer skip = null;
        Boolean isKeyVaultRefreshFailed = null;
        return new PagedFlux(() -> this.listByServiceSinglePageAsync(resourceGroupName, serviceName, filter, top, skip, isKeyVaultRefreshFailed), nextLink -> this.listByServiceNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<NamedValueContractInner> listByServiceAsync(String resourceGroupName, String serviceName, String filter, Integer top, Integer skip, Boolean isKeyVaultRefreshFailed, Context context) {
        return new PagedFlux(() -> this.listByServiceSinglePageAsync(resourceGroupName, serviceName, filter, top, skip, isKeyVaultRefreshFailed, context), nextLink -> this.listByServiceNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<NamedValueContractInner> listByService(String resourceGroupName, String serviceName) {
        String filter = null;
        Integer top = null;
        Integer skip = null;
        Boolean isKeyVaultRefreshFailed = null;
        return new PagedIterable(this.listByServiceAsync(resourceGroupName, serviceName, filter, top, skip, isKeyVaultRefreshFailed));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<NamedValueContractInner> listByService(String resourceGroupName, String serviceName, String filter, Integer top, Integer skip, Boolean isKeyVaultRefreshFailed, Context context) {
        return new PagedIterable(this.listByServiceAsync(resourceGroupName, serviceName, filter, top, skip, isKeyVaultRefreshFailed, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<NamedValuesGetEntityTagResponse> getEntityTagWithResponseAsync(String resourceGroupName, String serviceName, String namedValueId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (namedValueId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter namedValueId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getEntityTag(this.client.getEndpoint(), resourceGroupName, serviceName, namedValueId, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<NamedValuesGetEntityTagResponse> getEntityTagWithResponseAsync(String resourceGroupName, String serviceName, String namedValueId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (namedValueId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter namedValueId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getEntityTag(this.client.getEndpoint(), resourceGroupName, serviceName, namedValueId, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> getEntityTagAsync(String resourceGroupName, String serviceName, String namedValueId) {
        return this.getEntityTagWithResponseAsync(resourceGroupName, serviceName, namedValueId).flatMap(ignored -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public NamedValuesGetEntityTagResponse getEntityTagWithResponse(String resourceGroupName, String serviceName, String namedValueId, Context context) {
        return (NamedValuesGetEntityTagResponse)((Object)this.getEntityTagWithResponseAsync(resourceGroupName, serviceName, namedValueId, context).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void getEntityTag(String resourceGroupName, String serviceName, String namedValueId) {
        this.getEntityTagWithResponse(resourceGroupName, serviceName, namedValueId, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<NamedValuesGetResponse> getWithResponseAsync(String resourceGroupName, String serviceName, String namedValueId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (namedValueId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter namedValueId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), resourceGroupName, serviceName, namedValueId, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<NamedValuesGetResponse> getWithResponseAsync(String resourceGroupName, String serviceName, String namedValueId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (namedValueId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter namedValueId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), resourceGroupName, serviceName, namedValueId, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<NamedValueContractInner> getAsync(String resourceGroupName, String serviceName, String namedValueId) {
        return this.getWithResponseAsync(resourceGroupName, serviceName, namedValueId).flatMap(res -> Mono.justOrEmpty((Object)((Object)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public NamedValuesGetResponse getWithResponse(String resourceGroupName, String serviceName, String namedValueId, Context context) {
        return (NamedValuesGetResponse)((Object)this.getWithResponseAsync(resourceGroupName, serviceName, namedValueId, context).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public NamedValueContractInner get(String resourceGroupName, String serviceName, String namedValueId) {
        return this.getWithResponse(resourceGroupName, serviceName, namedValueId, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String serviceName, String namedValueId, NamedValueCreateContract parameters, String ifMatch) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (namedValueId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter namedValueId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdate(this.client.getEndpoint(), resourceGroupName, serviceName, namedValueId, ifMatch, this.client.getApiVersion(), this.client.getSubscriptionId(), parameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String serviceName, String namedValueId, NamedValueCreateContract parameters, String ifMatch, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (namedValueId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter namedValueId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createOrUpdate(this.client.getEndpoint(), resourceGroupName, serviceName, namedValueId, ifMatch, this.client.getApiVersion(), this.client.getSubscriptionId(), parameters, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<NamedValueContractInner>, NamedValueContractInner> beginCreateOrUpdateAsync(String resourceGroupName, String serviceName, String namedValueId, NamedValueCreateContract parameters, String ifMatch) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateWithResponseAsync(resourceGroupName, serviceName, namedValueId, parameters, ifMatch);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)NamedValueContractInner.class), (Type)((Object)NamedValueContractInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<NamedValueContractInner>, NamedValueContractInner> beginCreateOrUpdateAsync(String resourceGroupName, String serviceName, String namedValueId, NamedValueCreateContract parameters) {
        String ifMatch = null;
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateWithResponseAsync(resourceGroupName, serviceName, namedValueId, parameters, ifMatch);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)NamedValueContractInner.class), (Type)((Object)NamedValueContractInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<NamedValueContractInner>, NamedValueContractInner> beginCreateOrUpdateAsync(String resourceGroupName, String serviceName, String namedValueId, NamedValueCreateContract parameters, String ifMatch, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateWithResponseAsync(resourceGroupName, serviceName, namedValueId, parameters, ifMatch, context);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)NamedValueContractInner.class), (Type)((Object)NamedValueContractInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<NamedValueContractInner>, NamedValueContractInner> beginCreateOrUpdate(String resourceGroupName, String serviceName, String namedValueId, NamedValueCreateContract parameters) {
        String ifMatch = null;
        return this.beginCreateOrUpdateAsync(resourceGroupName, serviceName, namedValueId, parameters, ifMatch).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<NamedValueContractInner>, NamedValueContractInner> beginCreateOrUpdate(String resourceGroupName, String serviceName, String namedValueId, NamedValueCreateContract parameters, String ifMatch, Context context) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, serviceName, namedValueId, parameters, ifMatch, context).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<NamedValueContractInner> createOrUpdateAsync(String resourceGroupName, String serviceName, String namedValueId, NamedValueCreateContract parameters, String ifMatch) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, serviceName, namedValueId, parameters, ifMatch).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<NamedValueContractInner> createOrUpdateAsync(String resourceGroupName, String serviceName, String namedValueId, NamedValueCreateContract parameters) {
        String ifMatch = null;
        return this.beginCreateOrUpdateAsync(resourceGroupName, serviceName, namedValueId, parameters, ifMatch).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<NamedValueContractInner> createOrUpdateAsync(String resourceGroupName, String serviceName, String namedValueId, NamedValueCreateContract parameters, String ifMatch, Context context) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, serviceName, namedValueId, parameters, ifMatch, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public NamedValueContractInner createOrUpdate(String resourceGroupName, String serviceName, String namedValueId, NamedValueCreateContract parameters) {
        String ifMatch = null;
        return (NamedValueContractInner)((Object)this.createOrUpdateAsync(resourceGroupName, serviceName, namedValueId, parameters, ifMatch).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public NamedValueContractInner createOrUpdate(String resourceGroupName, String serviceName, String namedValueId, NamedValueCreateContract parameters, String ifMatch, Context context) {
        return (NamedValueContractInner)((Object)this.createOrUpdateAsync(resourceGroupName, serviceName, namedValueId, parameters, ifMatch, context).block());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(String resourceGroupName, String serviceName, String namedValueId, String ifMatch, NamedValueUpdateParameters parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (namedValueId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter namedValueId is required and cannot be null."));
        }
        if (ifMatch == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter ifMatch is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.update(this.client.getEndpoint(), resourceGroupName, serviceName, namedValueId, ifMatch, this.client.getApiVersion(), this.client.getSubscriptionId(), parameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(String resourceGroupName, String serviceName, String namedValueId, String ifMatch, NamedValueUpdateParameters parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (namedValueId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter namedValueId is required and cannot be null."));
        }
        if (ifMatch == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter ifMatch is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.update(this.client.getEndpoint(), resourceGroupName, serviceName, namedValueId, ifMatch, this.client.getApiVersion(), this.client.getSubscriptionId(), parameters, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<NamedValueContractInner>, NamedValueContractInner> beginUpdateAsync(String resourceGroupName, String serviceName, String namedValueId, String ifMatch, NamedValueUpdateParameters parameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.updateWithResponseAsync(resourceGroupName, serviceName, namedValueId, ifMatch, parameters);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)NamedValueContractInner.class), (Type)((Object)NamedValueContractInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<NamedValueContractInner>, NamedValueContractInner> beginUpdateAsync(String resourceGroupName, String serviceName, String namedValueId, String ifMatch, NamedValueUpdateParameters parameters, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.updateWithResponseAsync(resourceGroupName, serviceName, namedValueId, ifMatch, parameters, context);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)NamedValueContractInner.class), (Type)((Object)NamedValueContractInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<NamedValueContractInner>, NamedValueContractInner> beginUpdate(String resourceGroupName, String serviceName, String namedValueId, String ifMatch, NamedValueUpdateParameters parameters) {
        return this.beginUpdateAsync(resourceGroupName, serviceName, namedValueId, ifMatch, parameters).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<NamedValueContractInner>, NamedValueContractInner> beginUpdate(String resourceGroupName, String serviceName, String namedValueId, String ifMatch, NamedValueUpdateParameters parameters, Context context) {
        return this.beginUpdateAsync(resourceGroupName, serviceName, namedValueId, ifMatch, parameters, context).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<NamedValueContractInner> updateAsync(String resourceGroupName, String serviceName, String namedValueId, String ifMatch, NamedValueUpdateParameters parameters) {
        return this.beginUpdateAsync(resourceGroupName, serviceName, namedValueId, ifMatch, parameters).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<NamedValueContractInner> updateAsync(String resourceGroupName, String serviceName, String namedValueId, String ifMatch, NamedValueUpdateParameters parameters, Context context) {
        return this.beginUpdateAsync(resourceGroupName, serviceName, namedValueId, ifMatch, parameters, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public NamedValueContractInner update(String resourceGroupName, String serviceName, String namedValueId, String ifMatch, NamedValueUpdateParameters parameters) {
        return (NamedValueContractInner)((Object)this.updateAsync(resourceGroupName, serviceName, namedValueId, ifMatch, parameters).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public NamedValueContractInner update(String resourceGroupName, String serviceName, String namedValueId, String ifMatch, NamedValueUpdateParameters parameters, Context context) {
        return (NamedValueContractInner)((Object)this.updateAsync(resourceGroupName, serviceName, namedValueId, ifMatch, parameters, context).block());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> deleteWithResponseAsync(String resourceGroupName, String serviceName, String namedValueId, String ifMatch) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (namedValueId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter namedValueId is required and cannot be null."));
        }
        if (ifMatch == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter ifMatch is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), resourceGroupName, serviceName, namedValueId, ifMatch, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> deleteWithResponseAsync(String resourceGroupName, String serviceName, String namedValueId, String ifMatch, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (namedValueId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter namedValueId is required and cannot be null."));
        }
        if (ifMatch == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter ifMatch is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.delete(this.client.getEndpoint(), resourceGroupName, serviceName, namedValueId, ifMatch, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String serviceName, String namedValueId, String ifMatch) {
        return this.deleteWithResponseAsync(resourceGroupName, serviceName, namedValueId, ifMatch).flatMap(ignored -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteWithResponse(String resourceGroupName, String serviceName, String namedValueId, String ifMatch, Context context) {
        return (Response)this.deleteWithResponseAsync(resourceGroupName, serviceName, namedValueId, ifMatch, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String serviceName, String namedValueId, String ifMatch) {
        this.deleteWithResponse(resourceGroupName, serviceName, namedValueId, ifMatch, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<NamedValuesListValueResponse> listValueWithResponseAsync(String resourceGroupName, String serviceName, String namedValueId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (namedValueId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter namedValueId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listValue(this.client.getEndpoint(), resourceGroupName, serviceName, namedValueId, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<NamedValuesListValueResponse> listValueWithResponseAsync(String resourceGroupName, String serviceName, String namedValueId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (namedValueId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter namedValueId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listValue(this.client.getEndpoint(), resourceGroupName, serviceName, namedValueId, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<NamedValueSecretContractInner> listValueAsync(String resourceGroupName, String serviceName, String namedValueId) {
        return this.listValueWithResponseAsync(resourceGroupName, serviceName, namedValueId).flatMap(res -> Mono.justOrEmpty((Object)res.getValue()));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public NamedValuesListValueResponse listValueWithResponse(String resourceGroupName, String serviceName, String namedValueId, Context context) {
        return (NamedValuesListValueResponse)((Object)this.listValueWithResponseAsync(resourceGroupName, serviceName, namedValueId, context).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public NamedValueSecretContractInner listValue(String resourceGroupName, String serviceName, String namedValueId) {
        return this.listValueWithResponse(resourceGroupName, serviceName, namedValueId, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> refreshSecretWithResponseAsync(String resourceGroupName, String serviceName, String namedValueId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (namedValueId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter namedValueId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.refreshSecret(this.client.getEndpoint(), resourceGroupName, serviceName, namedValueId, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> refreshSecretWithResponseAsync(String resourceGroupName, String serviceName, String namedValueId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (namedValueId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter namedValueId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.refreshSecret(this.client.getEndpoint(), resourceGroupName, serviceName, namedValueId, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<NamedValueContractInner>, NamedValueContractInner> beginRefreshSecretAsync(String resourceGroupName, String serviceName, String namedValueId) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.refreshSecretWithResponseAsync(resourceGroupName, serviceName, namedValueId);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)NamedValueContractInner.class), (Type)((Object)NamedValueContractInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<NamedValueContractInner>, NamedValueContractInner> beginRefreshSecretAsync(String resourceGroupName, String serviceName, String namedValueId, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.refreshSecretWithResponseAsync(resourceGroupName, serviceName, namedValueId, context);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)NamedValueContractInner.class), (Type)((Object)NamedValueContractInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<NamedValueContractInner>, NamedValueContractInner> beginRefreshSecret(String resourceGroupName, String serviceName, String namedValueId) {
        return this.beginRefreshSecretAsync(resourceGroupName, serviceName, namedValueId).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<NamedValueContractInner>, NamedValueContractInner> beginRefreshSecret(String resourceGroupName, String serviceName, String namedValueId, Context context) {
        return this.beginRefreshSecretAsync(resourceGroupName, serviceName, namedValueId, context).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<NamedValueContractInner> refreshSecretAsync(String resourceGroupName, String serviceName, String namedValueId) {
        return this.beginRefreshSecretAsync(resourceGroupName, serviceName, namedValueId).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<NamedValueContractInner> refreshSecretAsync(String resourceGroupName, String serviceName, String namedValueId, Context context) {
        return this.beginRefreshSecretAsync(resourceGroupName, serviceName, namedValueId, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public NamedValueContractInner refreshSecret(String resourceGroupName, String serviceName, String namedValueId) {
        return (NamedValueContractInner)((Object)this.refreshSecretAsync(resourceGroupName, serviceName, namedValueId).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public NamedValueContractInner refreshSecret(String resourceGroupName, String serviceName, String namedValueId, Context context) {
        return (NamedValueContractInner)((Object)this.refreshSecretAsync(resourceGroupName, serviceName, namedValueId, context).block());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<NamedValueContractInner>> listByServiceNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByServiceNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((NamedValueCollection)res.getValue()).value(), ((NamedValueCollection)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<NamedValueContractInner>> listByServiceNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByServiceNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((NamedValueCollection)res.getValue()).value(), ((NamedValueCollection)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="ApiManagementClientN")
    public static interface NamedValuesService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/namedValues")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<NamedValueCollection>> listByService(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="serviceName") String var3, @QueryParam(value="$filter") String var4, @QueryParam(value="$top") Integer var5, @QueryParam(value="$skip") Integer var6, @QueryParam(value="isKeyVaultRefreshFailed") Boolean var7, @QueryParam(value="api-version") String var8, @PathParam(value="subscriptionId") String var9, @HeaderParam(value="Accept") String var10, Context var11);

        @Headers(value={"Content-Type: application/json"})
        @Head(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/namedValues/{namedValueId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<NamedValuesGetEntityTagResponse> getEntityTag(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="serviceName") String var3, @PathParam(value="namedValueId") String var4, @QueryParam(value="api-version") String var5, @PathParam(value="subscriptionId") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/namedValues/{namedValueId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<NamedValuesGetResponse> get(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="serviceName") String var3, @PathParam(value="namedValueId") String var4, @QueryParam(value="api-version") String var5, @PathParam(value="subscriptionId") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/namedValues/{namedValueId}")
        @ExpectedResponses(value={200, 201, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> createOrUpdate(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="serviceName") String var3, @PathParam(value="namedValueId") String var4, @HeaderParam(value="If-Match") String var5, @QueryParam(value="api-version") String var6, @PathParam(value="subscriptionId") String var7, @BodyParam(value="application/json") NamedValueCreateContract var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Patch(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/namedValues/{namedValueId}")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> update(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="serviceName") String var3, @PathParam(value="namedValueId") String var4, @HeaderParam(value="If-Match") String var5, @QueryParam(value="api-version") String var6, @PathParam(value="subscriptionId") String var7, @BodyParam(value="application/json") NamedValueUpdateParameters var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/namedValues/{namedValueId}")
        @ExpectedResponses(value={200, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Void>> delete(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="serviceName") String var3, @PathParam(value="namedValueId") String var4, @HeaderParam(value="If-Match") String var5, @QueryParam(value="api-version") String var6, @PathParam(value="subscriptionId") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/namedValues/{namedValueId}/listValue")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<NamedValuesListValueResponse> listValue(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="serviceName") String var3, @PathParam(value="namedValueId") String var4, @QueryParam(value="api-version") String var5, @PathParam(value="subscriptionId") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/namedValues/{namedValueId}/refreshSecret")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> refreshSecret(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="serviceName") String var3, @PathParam(value="namedValueId") String var4, @QueryParam(value="api-version") String var5, @PathParam(value="subscriptionId") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<NamedValueCollection>> listByServiceNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

