/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.Head;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.apimanagement.fluent.NotificationRecipientEmailsClient;
import com.azure.resourcemanager.apimanagement.fluent.models.RecipientEmailCollectionInner;
import com.azure.resourcemanager.apimanagement.fluent.models.RecipientEmailContractInner;
import com.azure.resourcemanager.apimanagement.implementation.ApiManagementClientImpl;
import com.azure.resourcemanager.apimanagement.models.NotificationName;
import reactor.core.publisher.Mono;

public final class NotificationRecipientEmailsClientImpl
implements NotificationRecipientEmailsClient {
    private final NotificationRecipientEmailsService service;
    private final ApiManagementClientImpl client;

    NotificationRecipientEmailsClientImpl(ApiManagementClientImpl client) {
        this.service = (NotificationRecipientEmailsService)RestProxy.create(NotificationRecipientEmailsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<RecipientEmailCollectionInner>> listByNotificationWithResponseAsync(String resourceGroupName, String serviceName, NotificationName notificationName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (notificationName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter notificationName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByNotification(this.client.getEndpoint(), resourceGroupName, serviceName, notificationName, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<RecipientEmailCollectionInner>> listByNotificationWithResponseAsync(String resourceGroupName, String serviceName, NotificationName notificationName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (notificationName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter notificationName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByNotification(this.client.getEndpoint(), resourceGroupName, serviceName, notificationName, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<RecipientEmailCollectionInner> listByNotificationAsync(String resourceGroupName, String serviceName, NotificationName notificationName) {
        return this.listByNotificationWithResponseAsync(resourceGroupName, serviceName, notificationName).flatMap(res -> Mono.justOrEmpty((Object)((RecipientEmailCollectionInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<RecipientEmailCollectionInner> listByNotificationWithResponse(String resourceGroupName, String serviceName, NotificationName notificationName, Context context) {
        return (Response)this.listByNotificationWithResponseAsync(resourceGroupName, serviceName, notificationName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public RecipientEmailCollectionInner listByNotification(String resourceGroupName, String serviceName, NotificationName notificationName) {
        return (RecipientEmailCollectionInner)this.listByNotificationWithResponse(resourceGroupName, serviceName, notificationName, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Boolean>> checkEntityExistsWithResponseAsync(String resourceGroupName, String serviceName, NotificationName notificationName, String email) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (notificationName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter notificationName is required and cannot be null."));
        }
        if (email == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter email is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.checkEntityExists(this.client.getEndpoint(), resourceGroupName, serviceName, notificationName, email, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Boolean>> checkEntityExistsWithResponseAsync(String resourceGroupName, String serviceName, NotificationName notificationName, String email, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (notificationName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter notificationName is required and cannot be null."));
        }
        if (email == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter email is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.checkEntityExists(this.client.getEndpoint(), resourceGroupName, serviceName, notificationName, email, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Boolean> checkEntityExistsAsync(String resourceGroupName, String serviceName, NotificationName notificationName, String email) {
        return this.checkEntityExistsWithResponseAsync(resourceGroupName, serviceName, notificationName, email).flatMap(res -> Mono.justOrEmpty((Object)((Boolean)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Boolean> checkEntityExistsWithResponse(String resourceGroupName, String serviceName, NotificationName notificationName, String email, Context context) {
        return (Response)this.checkEntityExistsWithResponseAsync(resourceGroupName, serviceName, notificationName, email, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public boolean checkEntityExists(String resourceGroupName, String serviceName, NotificationName notificationName, String email) {
        return (Boolean)this.checkEntityExistsWithResponse(resourceGroupName, serviceName, notificationName, email, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<RecipientEmailContractInner>> createOrUpdateWithResponseAsync(String resourceGroupName, String serviceName, NotificationName notificationName, String email) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (notificationName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter notificationName is required and cannot be null."));
        }
        if (email == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter email is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdate(this.client.getEndpoint(), resourceGroupName, serviceName, notificationName, email, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<RecipientEmailContractInner>> createOrUpdateWithResponseAsync(String resourceGroupName, String serviceName, NotificationName notificationName, String email, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (notificationName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter notificationName is required and cannot be null."));
        }
        if (email == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter email is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createOrUpdate(this.client.getEndpoint(), resourceGroupName, serviceName, notificationName, email, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<RecipientEmailContractInner> createOrUpdateAsync(String resourceGroupName, String serviceName, NotificationName notificationName, String email) {
        return this.createOrUpdateWithResponseAsync(resourceGroupName, serviceName, notificationName, email).flatMap(res -> Mono.justOrEmpty((Object)((Object)((RecipientEmailContractInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<RecipientEmailContractInner> createOrUpdateWithResponse(String resourceGroupName, String serviceName, NotificationName notificationName, String email, Context context) {
        return (Response)this.createOrUpdateWithResponseAsync(resourceGroupName, serviceName, notificationName, email, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public RecipientEmailContractInner createOrUpdate(String resourceGroupName, String serviceName, NotificationName notificationName, String email) {
        return (RecipientEmailContractInner)((Object)this.createOrUpdateWithResponse(resourceGroupName, serviceName, notificationName, email, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> deleteWithResponseAsync(String resourceGroupName, String serviceName, NotificationName notificationName, String email) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (notificationName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter notificationName is required and cannot be null."));
        }
        if (email == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter email is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), resourceGroupName, serviceName, notificationName, email, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> deleteWithResponseAsync(String resourceGroupName, String serviceName, NotificationName notificationName, String email, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (notificationName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter notificationName is required and cannot be null."));
        }
        if (email == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter email is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.delete(this.client.getEndpoint(), resourceGroupName, serviceName, notificationName, email, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String serviceName, NotificationName notificationName, String email) {
        return this.deleteWithResponseAsync(resourceGroupName, serviceName, notificationName, email).flatMap(ignored -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteWithResponse(String resourceGroupName, String serviceName, NotificationName notificationName, String email, Context context) {
        return (Response)this.deleteWithResponseAsync(resourceGroupName, serviceName, notificationName, email, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String serviceName, NotificationName notificationName, String email) {
        this.deleteWithResponse(resourceGroupName, serviceName, notificationName, email, Context.NONE);
    }

    @Host(value="{$host}")
    @ServiceInterface(name="ApiManagementClientN")
    public static interface NotificationRecipientEmailsService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/notifications/{notificationName}/recipientEmails")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<RecipientEmailCollectionInner>> listByNotification(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="serviceName") String var3, @PathParam(value="notificationName") NotificationName var4, @QueryParam(value="api-version") String var5, @PathParam(value="subscriptionId") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Head(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/notifications/{notificationName}/recipientEmails/{email}")
        @ExpectedResponses(value={204, 404})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Boolean>> checkEntityExists(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="serviceName") String var3, @PathParam(value="notificationName") NotificationName var4, @PathParam(value="email") String var5, @QueryParam(value="api-version") String var6, @PathParam(value="subscriptionId") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/notifications/{notificationName}/recipientEmails/{email}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<RecipientEmailContractInner>> createOrUpdate(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="serviceName") String var3, @PathParam(value="notificationName") NotificationName var4, @PathParam(value="email") String var5, @QueryParam(value="api-version") String var6, @PathParam(value="subscriptionId") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/notifications/{notificationName}/recipientEmails/{email}")
        @ExpectedResponses(value={200, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Void>> delete(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="serviceName") String var3, @PathParam(value="notificationName") NotificationName var4, @PathParam(value="email") String var5, @QueryParam(value="api-version") String var6, @PathParam(value="subscriptionId") String var7, @HeaderParam(value="Accept") String var8, Context var9);
    }
}

