/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.apimanagement.ApiManagementManager;
import com.azure.resourcemanager.apimanagement.fluent.NotificationsClient;
import com.azure.resourcemanager.apimanagement.fluent.models.NotificationContractInner;
import com.azure.resourcemanager.apimanagement.implementation.NotificationContractImpl;
import com.azure.resourcemanager.apimanagement.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.apimanagement.models.NotificationContract;
import com.azure.resourcemanager.apimanagement.models.NotificationName;
import com.azure.resourcemanager.apimanagement.models.Notifications;

public final class NotificationsImpl
implements Notifications {
    private static final ClientLogger LOGGER = new ClientLogger(NotificationsImpl.class);
    private final NotificationsClient innerClient;
    private final ApiManagementManager serviceManager;

    public NotificationsImpl(NotificationsClient innerClient, ApiManagementManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<NotificationContract> listByService(String resourceGroupName, String serviceName) {
        PagedIterable<NotificationContractInner> inner = this.serviceClient().listByService(resourceGroupName, serviceName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new NotificationContractImpl((NotificationContractInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<NotificationContract> listByService(String resourceGroupName, String serviceName, Integer top, Integer skip, Context context) {
        PagedIterable<NotificationContractInner> inner = this.serviceClient().listByService(resourceGroupName, serviceName, top, skip, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new NotificationContractImpl((NotificationContractInner)((Object)inner1), this.manager()));
    }

    @Override
    public Response<NotificationContract> getWithResponse(String resourceGroupName, String serviceName, NotificationName notificationName, Context context) {
        Response<NotificationContractInner> inner = this.serviceClient().getWithResponse(resourceGroupName, serviceName, notificationName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new NotificationContractImpl((NotificationContractInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public NotificationContract get(String resourceGroupName, String serviceName, NotificationName notificationName) {
        NotificationContractInner inner = this.serviceClient().get(resourceGroupName, serviceName, notificationName);
        if (inner != null) {
            return new NotificationContractImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<NotificationContract> createOrUpdateWithResponse(String resourceGroupName, String serviceName, NotificationName notificationName, String ifMatch, Context context) {
        Response<NotificationContractInner> inner = this.serviceClient().createOrUpdateWithResponse(resourceGroupName, serviceName, notificationName, ifMatch, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new NotificationContractImpl((NotificationContractInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public NotificationContract createOrUpdate(String resourceGroupName, String serviceName, NotificationName notificationName) {
        NotificationContractInner inner = this.serviceClient().createOrUpdate(resourceGroupName, serviceName, notificationName);
        if (inner != null) {
            return new NotificationContractImpl(inner, this.manager());
        }
        return null;
    }

    private NotificationsClient serviceClient() {
        return this.innerClient;
    }

    private ApiManagementManager manager() {
        return this.serviceManager;
    }
}

