/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.Head;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.apimanagement.fluent.PortalRevisionsClient;
import com.azure.resourcemanager.apimanagement.fluent.models.PortalRevisionContractInner;
import com.azure.resourcemanager.apimanagement.implementation.ApiManagementClientImpl;
import com.azure.resourcemanager.apimanagement.models.PortalRevisionCollection;
import com.azure.resourcemanager.apimanagement.models.PortalRevisionsGetEntityTagResponse;
import com.azure.resourcemanager.apimanagement.models.PortalRevisionsGetResponse;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class PortalRevisionsClientImpl
implements PortalRevisionsClient {
    private final PortalRevisionsService service;
    private final ApiManagementClientImpl client;

    PortalRevisionsClientImpl(ApiManagementClientImpl client) {
        this.service = (PortalRevisionsService)RestProxy.create(PortalRevisionsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<PortalRevisionContractInner>> listByServiceSinglePageAsync(String resourceGroupName, String serviceName, String filter, Integer top, Integer skip) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByService(this.client.getEndpoint(), resourceGroupName, serviceName, filter, top, skip, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PortalRevisionCollection)res.getValue()).value(), ((PortalRevisionCollection)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<PortalRevisionContractInner>> listByServiceSinglePageAsync(String resourceGroupName, String serviceName, String filter, Integer top, Integer skip, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByService(this.client.getEndpoint(), resourceGroupName, serviceName, filter, top, skip, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PortalRevisionCollection)res.getValue()).value(), ((PortalRevisionCollection)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<PortalRevisionContractInner> listByServiceAsync(String resourceGroupName, String serviceName, String filter, Integer top, Integer skip) {
        return new PagedFlux(() -> this.listByServiceSinglePageAsync(resourceGroupName, serviceName, filter, top, skip), nextLink -> this.listByServiceNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<PortalRevisionContractInner> listByServiceAsync(String resourceGroupName, String serviceName) {
        String filter = null;
        Integer top = null;
        Integer skip = null;
        return new PagedFlux(() -> this.listByServiceSinglePageAsync(resourceGroupName, serviceName, filter, top, skip), nextLink -> this.listByServiceNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<PortalRevisionContractInner> listByServiceAsync(String resourceGroupName, String serviceName, String filter, Integer top, Integer skip, Context context) {
        return new PagedFlux(() -> this.listByServiceSinglePageAsync(resourceGroupName, serviceName, filter, top, skip, context), nextLink -> this.listByServiceNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<PortalRevisionContractInner> listByService(String resourceGroupName, String serviceName) {
        String filter = null;
        Integer top = null;
        Integer skip = null;
        return new PagedIterable(this.listByServiceAsync(resourceGroupName, serviceName, filter, top, skip));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<PortalRevisionContractInner> listByService(String resourceGroupName, String serviceName, String filter, Integer top, Integer skip, Context context) {
        return new PagedIterable(this.listByServiceAsync(resourceGroupName, serviceName, filter, top, skip, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PortalRevisionsGetEntityTagResponse> getEntityTagWithResponseAsync(String resourceGroupName, String serviceName, String portalRevisionId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (portalRevisionId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter portalRevisionId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getEntityTag(this.client.getEndpoint(), resourceGroupName, serviceName, portalRevisionId, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PortalRevisionsGetEntityTagResponse> getEntityTagWithResponseAsync(String resourceGroupName, String serviceName, String portalRevisionId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (portalRevisionId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter portalRevisionId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getEntityTag(this.client.getEndpoint(), resourceGroupName, serviceName, portalRevisionId, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> getEntityTagAsync(String resourceGroupName, String serviceName, String portalRevisionId) {
        return this.getEntityTagWithResponseAsync(resourceGroupName, serviceName, portalRevisionId).flatMap(ignored -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public PortalRevisionsGetEntityTagResponse getEntityTagWithResponse(String resourceGroupName, String serviceName, String portalRevisionId, Context context) {
        return (PortalRevisionsGetEntityTagResponse)((Object)this.getEntityTagWithResponseAsync(resourceGroupName, serviceName, portalRevisionId, context).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void getEntityTag(String resourceGroupName, String serviceName, String portalRevisionId) {
        this.getEntityTagWithResponse(resourceGroupName, serviceName, portalRevisionId, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PortalRevisionsGetResponse> getWithResponseAsync(String resourceGroupName, String serviceName, String portalRevisionId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (portalRevisionId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter portalRevisionId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), resourceGroupName, serviceName, portalRevisionId, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PortalRevisionsGetResponse> getWithResponseAsync(String resourceGroupName, String serviceName, String portalRevisionId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (portalRevisionId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter portalRevisionId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), resourceGroupName, serviceName, portalRevisionId, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PortalRevisionContractInner> getAsync(String resourceGroupName, String serviceName, String portalRevisionId) {
        return this.getWithResponseAsync(resourceGroupName, serviceName, portalRevisionId).flatMap(res -> Mono.justOrEmpty((Object)((Object)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public PortalRevisionsGetResponse getWithResponse(String resourceGroupName, String serviceName, String portalRevisionId, Context context) {
        return (PortalRevisionsGetResponse)((Object)this.getWithResponseAsync(resourceGroupName, serviceName, portalRevisionId, context).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public PortalRevisionContractInner get(String resourceGroupName, String serviceName, String portalRevisionId) {
        return this.getWithResponse(resourceGroupName, serviceName, portalRevisionId, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String serviceName, String portalRevisionId, PortalRevisionContractInner parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (portalRevisionId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter portalRevisionId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdate(this.client.getEndpoint(), resourceGroupName, serviceName, portalRevisionId, this.client.getApiVersion(), this.client.getSubscriptionId(), parameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String serviceName, String portalRevisionId, PortalRevisionContractInner parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (portalRevisionId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter portalRevisionId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createOrUpdate(this.client.getEndpoint(), resourceGroupName, serviceName, portalRevisionId, this.client.getApiVersion(), this.client.getSubscriptionId(), parameters, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<PortalRevisionContractInner>, PortalRevisionContractInner> beginCreateOrUpdateAsync(String resourceGroupName, String serviceName, String portalRevisionId, PortalRevisionContractInner parameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateWithResponseAsync(resourceGroupName, serviceName, portalRevisionId, parameters);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)PortalRevisionContractInner.class), (Type)((Object)PortalRevisionContractInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<PortalRevisionContractInner>, PortalRevisionContractInner> beginCreateOrUpdateAsync(String resourceGroupName, String serviceName, String portalRevisionId, PortalRevisionContractInner parameters, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateWithResponseAsync(resourceGroupName, serviceName, portalRevisionId, parameters, context);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)PortalRevisionContractInner.class), (Type)((Object)PortalRevisionContractInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<PortalRevisionContractInner>, PortalRevisionContractInner> beginCreateOrUpdate(String resourceGroupName, String serviceName, String portalRevisionId, PortalRevisionContractInner parameters) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, serviceName, portalRevisionId, parameters).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<PortalRevisionContractInner>, PortalRevisionContractInner> beginCreateOrUpdate(String resourceGroupName, String serviceName, String portalRevisionId, PortalRevisionContractInner parameters, Context context) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, serviceName, portalRevisionId, parameters, context).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PortalRevisionContractInner> createOrUpdateAsync(String resourceGroupName, String serviceName, String portalRevisionId, PortalRevisionContractInner parameters) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, serviceName, portalRevisionId, parameters).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PortalRevisionContractInner> createOrUpdateAsync(String resourceGroupName, String serviceName, String portalRevisionId, PortalRevisionContractInner parameters, Context context) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, serviceName, portalRevisionId, parameters, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public PortalRevisionContractInner createOrUpdate(String resourceGroupName, String serviceName, String portalRevisionId, PortalRevisionContractInner parameters) {
        return (PortalRevisionContractInner)((Object)this.createOrUpdateAsync(resourceGroupName, serviceName, portalRevisionId, parameters).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public PortalRevisionContractInner createOrUpdate(String resourceGroupName, String serviceName, String portalRevisionId, PortalRevisionContractInner parameters, Context context) {
        return (PortalRevisionContractInner)((Object)this.createOrUpdateAsync(resourceGroupName, serviceName, portalRevisionId, parameters, context).block());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(String resourceGroupName, String serviceName, String portalRevisionId, String ifMatch, PortalRevisionContractInner parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (portalRevisionId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter portalRevisionId is required and cannot be null."));
        }
        if (ifMatch == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter ifMatch is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.update(this.client.getEndpoint(), resourceGroupName, serviceName, portalRevisionId, ifMatch, this.client.getApiVersion(), this.client.getSubscriptionId(), parameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(String resourceGroupName, String serviceName, String portalRevisionId, String ifMatch, PortalRevisionContractInner parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (portalRevisionId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter portalRevisionId is required and cannot be null."));
        }
        if (ifMatch == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter ifMatch is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.update(this.client.getEndpoint(), resourceGroupName, serviceName, portalRevisionId, ifMatch, this.client.getApiVersion(), this.client.getSubscriptionId(), parameters, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<PortalRevisionContractInner>, PortalRevisionContractInner> beginUpdateAsync(String resourceGroupName, String serviceName, String portalRevisionId, String ifMatch, PortalRevisionContractInner parameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.updateWithResponseAsync(resourceGroupName, serviceName, portalRevisionId, ifMatch, parameters);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)PortalRevisionContractInner.class), (Type)((Object)PortalRevisionContractInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<PortalRevisionContractInner>, PortalRevisionContractInner> beginUpdateAsync(String resourceGroupName, String serviceName, String portalRevisionId, String ifMatch, PortalRevisionContractInner parameters, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.updateWithResponseAsync(resourceGroupName, serviceName, portalRevisionId, ifMatch, parameters, context);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)PortalRevisionContractInner.class), (Type)((Object)PortalRevisionContractInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<PortalRevisionContractInner>, PortalRevisionContractInner> beginUpdate(String resourceGroupName, String serviceName, String portalRevisionId, String ifMatch, PortalRevisionContractInner parameters) {
        return this.beginUpdateAsync(resourceGroupName, serviceName, portalRevisionId, ifMatch, parameters).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<PortalRevisionContractInner>, PortalRevisionContractInner> beginUpdate(String resourceGroupName, String serviceName, String portalRevisionId, String ifMatch, PortalRevisionContractInner parameters, Context context) {
        return this.beginUpdateAsync(resourceGroupName, serviceName, portalRevisionId, ifMatch, parameters, context).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PortalRevisionContractInner> updateAsync(String resourceGroupName, String serviceName, String portalRevisionId, String ifMatch, PortalRevisionContractInner parameters) {
        return this.beginUpdateAsync(resourceGroupName, serviceName, portalRevisionId, ifMatch, parameters).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PortalRevisionContractInner> updateAsync(String resourceGroupName, String serviceName, String portalRevisionId, String ifMatch, PortalRevisionContractInner parameters, Context context) {
        return this.beginUpdateAsync(resourceGroupName, serviceName, portalRevisionId, ifMatch, parameters, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public PortalRevisionContractInner update(String resourceGroupName, String serviceName, String portalRevisionId, String ifMatch, PortalRevisionContractInner parameters) {
        return (PortalRevisionContractInner)((Object)this.updateAsync(resourceGroupName, serviceName, portalRevisionId, ifMatch, parameters).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public PortalRevisionContractInner update(String resourceGroupName, String serviceName, String portalRevisionId, String ifMatch, PortalRevisionContractInner parameters, Context context) {
        return (PortalRevisionContractInner)((Object)this.updateAsync(resourceGroupName, serviceName, portalRevisionId, ifMatch, parameters, context).block());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<PortalRevisionContractInner>> listByServiceNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByServiceNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PortalRevisionCollection)res.getValue()).value(), ((PortalRevisionCollection)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<PortalRevisionContractInner>> listByServiceNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByServiceNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PortalRevisionCollection)res.getValue()).value(), ((PortalRevisionCollection)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="ApiManagementClientP")
    public static interface PortalRevisionsService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/portalRevisions")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<PortalRevisionCollection>> listByService(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="serviceName") String var3, @QueryParam(value="$filter") String var4, @QueryParam(value="$top") Integer var5, @QueryParam(value="$skip") Integer var6, @QueryParam(value="api-version") String var7, @PathParam(value="subscriptionId") String var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Head(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/portalRevisions/{portalRevisionId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<PortalRevisionsGetEntityTagResponse> getEntityTag(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="serviceName") String var3, @PathParam(value="portalRevisionId") String var4, @QueryParam(value="api-version") String var5, @PathParam(value="subscriptionId") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/portalRevisions/{portalRevisionId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<PortalRevisionsGetResponse> get(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="serviceName") String var3, @PathParam(value="portalRevisionId") String var4, @QueryParam(value="api-version") String var5, @PathParam(value="subscriptionId") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/portalRevisions/{portalRevisionId}")
        @ExpectedResponses(value={201, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> createOrUpdate(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="serviceName") String var3, @PathParam(value="portalRevisionId") String var4, @QueryParam(value="api-version") String var5, @PathParam(value="subscriptionId") String var6, @BodyParam(value="application/json") PortalRevisionContractInner var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Patch(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/portalRevisions/{portalRevisionId}")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> update(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="serviceName") String var3, @PathParam(value="portalRevisionId") String var4, @HeaderParam(value="If-Match") String var5, @QueryParam(value="api-version") String var6, @PathParam(value="subscriptionId") String var7, @BodyParam(value="application/json") PortalRevisionContractInner var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<PortalRevisionCollection>> listByServiceNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

