/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.util.Context;
import com.azure.resourcemanager.apimanagement.ApiManagementManager;
import com.azure.resourcemanager.apimanagement.fluent.models.PrivateEndpointConnectionInner;
import com.azure.resourcemanager.apimanagement.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.apimanagement.models.PrivateEndpoint;
import com.azure.resourcemanager.apimanagement.models.PrivateEndpointConnection;
import com.azure.resourcemanager.apimanagement.models.PrivateEndpointConnectionProvisioningState;
import com.azure.resourcemanager.apimanagement.models.PrivateEndpointConnectionRequest;
import com.azure.resourcemanager.apimanagement.models.PrivateEndpointConnectionRequestProperties;
import com.azure.resourcemanager.apimanagement.models.PrivateLinkServiceConnectionState;

public final class PrivateEndpointConnectionImpl
implements PrivateEndpointConnection,
PrivateEndpointConnection.Definition,
PrivateEndpointConnection.Update {
    private PrivateEndpointConnectionInner innerObject;
    private final ApiManagementManager serviceManager;
    private String resourceGroupName;
    private String serviceName;
    private String privateEndpointConnectionName;
    private PrivateEndpointConnectionRequest createPrivateEndpointConnectionRequest;
    private PrivateEndpointConnectionRequest updatePrivateEndpointConnectionRequest;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public PrivateEndpoint privateEndpoint() {
        return this.innerModel().privateEndpoint();
    }

    @Override
    public PrivateLinkServiceConnectionState privateLinkServiceConnectionState() {
        return this.innerModel().privateLinkServiceConnectionState();
    }

    @Override
    public PrivateEndpointConnectionProvisioningState provisioningState() {
        return this.innerModel().provisioningState();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public PrivateEndpointConnectionInner innerModel() {
        return this.innerObject;
    }

    private ApiManagementManager manager() {
        return this.serviceManager;
    }

    @Override
    public PrivateEndpointConnectionImpl withExistingService(String resourceGroupName, String serviceName) {
        this.resourceGroupName = resourceGroupName;
        this.serviceName = serviceName;
        return this;
    }

    @Override
    public PrivateEndpointConnection create() {
        this.innerObject = this.serviceManager.serviceClient().getPrivateEndpointConnections().createOrUpdate(this.resourceGroupName, this.serviceName, this.privateEndpointConnectionName, this.createPrivateEndpointConnectionRequest, Context.NONE);
        return this;
    }

    @Override
    public PrivateEndpointConnection create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getPrivateEndpointConnections().createOrUpdate(this.resourceGroupName, this.serviceName, this.privateEndpointConnectionName, this.createPrivateEndpointConnectionRequest, context);
        return this;
    }

    PrivateEndpointConnectionImpl(String name, ApiManagementManager serviceManager) {
        this.innerObject = new PrivateEndpointConnectionInner();
        this.serviceManager = serviceManager;
        this.privateEndpointConnectionName = name;
        this.createPrivateEndpointConnectionRequest = new PrivateEndpointConnectionRequest();
    }

    @Override
    public PrivateEndpointConnectionImpl update() {
        this.updatePrivateEndpointConnectionRequest = new PrivateEndpointConnectionRequest();
        return this;
    }

    @Override
    public PrivateEndpointConnection apply() {
        this.innerObject = this.serviceManager.serviceClient().getPrivateEndpointConnections().createOrUpdate(this.resourceGroupName, this.serviceName, this.privateEndpointConnectionName, this.updatePrivateEndpointConnectionRequest, Context.NONE);
        return this;
    }

    @Override
    public PrivateEndpointConnection apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getPrivateEndpointConnections().createOrUpdate(this.resourceGroupName, this.serviceName, this.privateEndpointConnectionName, this.updatePrivateEndpointConnectionRequest, context);
        return this;
    }

    PrivateEndpointConnectionImpl(PrivateEndpointConnectionInner innerObject, ApiManagementManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.serviceName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "service");
        this.privateEndpointConnectionName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "privateEndpointConnections");
    }

    @Override
    public PrivateEndpointConnection refresh() {
        this.innerObject = (PrivateEndpointConnectionInner)((Object)this.serviceManager.serviceClient().getPrivateEndpointConnections().getByNameWithResponse(this.resourceGroupName, this.serviceName, this.privateEndpointConnectionName, Context.NONE).getValue());
        return this;
    }

    @Override
    public PrivateEndpointConnection refresh(Context context) {
        this.innerObject = (PrivateEndpointConnectionInner)((Object)this.serviceManager.serviceClient().getPrivateEndpointConnections().getByNameWithResponse(this.resourceGroupName, this.serviceName, this.privateEndpointConnectionName, context).getValue());
        return this;
    }

    @Override
    public PrivateEndpointConnectionImpl withProperties(PrivateEndpointConnectionRequestProperties properties) {
        if (this.isInCreateMode()) {
            this.createPrivateEndpointConnectionRequest.withProperties(properties);
            return this;
        }
        this.updatePrivateEndpointConnectionRequest.withProperties(properties);
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel().id() == null;
    }
}

