/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.apimanagement.ApiManagementManager;
import com.azure.resourcemanager.apimanagement.fluent.ReportsClient;
import com.azure.resourcemanager.apimanagement.fluent.models.ReportRecordContractInner;
import com.azure.resourcemanager.apimanagement.fluent.models.RequestReportRecordContractInner;
import com.azure.resourcemanager.apimanagement.implementation.ReportRecordContractImpl;
import com.azure.resourcemanager.apimanagement.implementation.RequestReportRecordContractImpl;
import com.azure.resourcemanager.apimanagement.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.apimanagement.models.ReportRecordContract;
import com.azure.resourcemanager.apimanagement.models.Reports;
import com.azure.resourcemanager.apimanagement.models.RequestReportRecordContract;
import java.time.Duration;

public final class ReportsImpl
implements Reports {
    private static final ClientLogger LOGGER = new ClientLogger(ReportsImpl.class);
    private final ReportsClient innerClient;
    private final ApiManagementManager serviceManager;

    public ReportsImpl(ReportsClient innerClient, ApiManagementManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<ReportRecordContract> listByApi(String resourceGroupName, String serviceName, String filter) {
        PagedIterable<ReportRecordContractInner> inner = this.serviceClient().listByApi(resourceGroupName, serviceName, filter);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ReportRecordContractImpl((ReportRecordContractInner)inner1, this.manager()));
    }

    @Override
    public PagedIterable<ReportRecordContract> listByApi(String resourceGroupName, String serviceName, String filter, Integer top, Integer skip, String orderby, Context context) {
        PagedIterable<ReportRecordContractInner> inner = this.serviceClient().listByApi(resourceGroupName, serviceName, filter, top, skip, orderby, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ReportRecordContractImpl((ReportRecordContractInner)inner1, this.manager()));
    }

    @Override
    public PagedIterable<ReportRecordContract> listByUser(String resourceGroupName, String serviceName, String filter) {
        PagedIterable<ReportRecordContractInner> inner = this.serviceClient().listByUser(resourceGroupName, serviceName, filter);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ReportRecordContractImpl((ReportRecordContractInner)inner1, this.manager()));
    }

    @Override
    public PagedIterable<ReportRecordContract> listByUser(String resourceGroupName, String serviceName, String filter, Integer top, Integer skip, String orderby, Context context) {
        PagedIterable<ReportRecordContractInner> inner = this.serviceClient().listByUser(resourceGroupName, serviceName, filter, top, skip, orderby, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ReportRecordContractImpl((ReportRecordContractInner)inner1, this.manager()));
    }

    @Override
    public PagedIterable<ReportRecordContract> listByOperation(String resourceGroupName, String serviceName, String filter) {
        PagedIterable<ReportRecordContractInner> inner = this.serviceClient().listByOperation(resourceGroupName, serviceName, filter);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ReportRecordContractImpl((ReportRecordContractInner)inner1, this.manager()));
    }

    @Override
    public PagedIterable<ReportRecordContract> listByOperation(String resourceGroupName, String serviceName, String filter, Integer top, Integer skip, String orderby, Context context) {
        PagedIterable<ReportRecordContractInner> inner = this.serviceClient().listByOperation(resourceGroupName, serviceName, filter, top, skip, orderby, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ReportRecordContractImpl((ReportRecordContractInner)inner1, this.manager()));
    }

    @Override
    public PagedIterable<ReportRecordContract> listByProduct(String resourceGroupName, String serviceName, String filter) {
        PagedIterable<ReportRecordContractInner> inner = this.serviceClient().listByProduct(resourceGroupName, serviceName, filter);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ReportRecordContractImpl((ReportRecordContractInner)inner1, this.manager()));
    }

    @Override
    public PagedIterable<ReportRecordContract> listByProduct(String resourceGroupName, String serviceName, String filter, Integer top, Integer skip, String orderby, Context context) {
        PagedIterable<ReportRecordContractInner> inner = this.serviceClient().listByProduct(resourceGroupName, serviceName, filter, top, skip, orderby, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ReportRecordContractImpl((ReportRecordContractInner)inner1, this.manager()));
    }

    @Override
    public PagedIterable<ReportRecordContract> listByGeo(String resourceGroupName, String serviceName, String filter) {
        PagedIterable<ReportRecordContractInner> inner = this.serviceClient().listByGeo(resourceGroupName, serviceName, filter);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ReportRecordContractImpl((ReportRecordContractInner)inner1, this.manager()));
    }

    @Override
    public PagedIterable<ReportRecordContract> listByGeo(String resourceGroupName, String serviceName, String filter, Integer top, Integer skip, Context context) {
        PagedIterable<ReportRecordContractInner> inner = this.serviceClient().listByGeo(resourceGroupName, serviceName, filter, top, skip, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ReportRecordContractImpl((ReportRecordContractInner)inner1, this.manager()));
    }

    @Override
    public PagedIterable<ReportRecordContract> listBySubscription(String resourceGroupName, String serviceName, String filter) {
        PagedIterable<ReportRecordContractInner> inner = this.serviceClient().listBySubscription(resourceGroupName, serviceName, filter);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ReportRecordContractImpl((ReportRecordContractInner)inner1, this.manager()));
    }

    @Override
    public PagedIterable<ReportRecordContract> listBySubscription(String resourceGroupName, String serviceName, String filter, Integer top, Integer skip, String orderby, Context context) {
        PagedIterable<ReportRecordContractInner> inner = this.serviceClient().listBySubscription(resourceGroupName, serviceName, filter, top, skip, orderby, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ReportRecordContractImpl((ReportRecordContractInner)inner1, this.manager()));
    }

    @Override
    public PagedIterable<ReportRecordContract> listByTime(String resourceGroupName, String serviceName, String filter, Duration interval) {
        PagedIterable<ReportRecordContractInner> inner = this.serviceClient().listByTime(resourceGroupName, serviceName, filter, interval);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ReportRecordContractImpl((ReportRecordContractInner)inner1, this.manager()));
    }

    @Override
    public PagedIterable<ReportRecordContract> listByTime(String resourceGroupName, String serviceName, String filter, Duration interval, Integer top, Integer skip, String orderby, Context context) {
        PagedIterable<ReportRecordContractInner> inner = this.serviceClient().listByTime(resourceGroupName, serviceName, filter, interval, top, skip, orderby, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ReportRecordContractImpl((ReportRecordContractInner)inner1, this.manager()));
    }

    @Override
    public PagedIterable<RequestReportRecordContract> listByRequest(String resourceGroupName, String serviceName, String filter) {
        PagedIterable<RequestReportRecordContractInner> inner = this.serviceClient().listByRequest(resourceGroupName, serviceName, filter);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new RequestReportRecordContractImpl((RequestReportRecordContractInner)inner1, this.manager()));
    }

    @Override
    public PagedIterable<RequestReportRecordContract> listByRequest(String resourceGroupName, String serviceName, String filter, Integer top, Integer skip, Context context) {
        PagedIterable<RequestReportRecordContractInner> inner = this.serviceClient().listByRequest(resourceGroupName, serviceName, filter, top, skip, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new RequestReportRecordContractImpl((RequestReportRecordContractInner)inner1, this.manager()));
    }

    private ReportsClient serviceClient() {
        return this.innerClient;
    }

    private ApiManagementManager manager() {
        return this.serviceManager;
    }
}

