/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.util.Context;
import com.azure.resourcemanager.apimanagement.ApiManagementManager;
import com.azure.resourcemanager.apimanagement.fluent.models.SchemaContractInner;
import com.azure.resourcemanager.apimanagement.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.apimanagement.models.SchemaContract;

public final class SchemaContractImpl
implements SchemaContract,
SchemaContract.Definition,
SchemaContract.Update {
    private SchemaContractInner innerObject;
    private final ApiManagementManager serviceManager;
    private String resourceGroupName;
    private String serviceName;
    private String apiId;
    private String schemaId;
    private String createIfMatch;
    private String updateIfMatch;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String contentType() {
        return this.innerModel().contentType();
    }

    @Override
    public String value() {
        return this.innerModel().value();
    }

    @Override
    public Object definitions() {
        return this.innerModel().definitions();
    }

    @Override
    public Object components() {
        return this.innerModel().components();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public SchemaContractInner innerModel() {
        return this.innerObject;
    }

    private ApiManagementManager manager() {
        return this.serviceManager;
    }

    @Override
    public SchemaContractImpl withExistingApi(String resourceGroupName, String serviceName, String apiId) {
        this.resourceGroupName = resourceGroupName;
        this.serviceName = serviceName;
        this.apiId = apiId;
        return this;
    }

    @Override
    public SchemaContract create() {
        this.innerObject = this.serviceManager.serviceClient().getApiSchemas().createOrUpdate(this.resourceGroupName, this.serviceName, this.apiId, this.schemaId, this.innerModel(), this.createIfMatch, Context.NONE);
        return this;
    }

    @Override
    public SchemaContract create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getApiSchemas().createOrUpdate(this.resourceGroupName, this.serviceName, this.apiId, this.schemaId, this.innerModel(), this.createIfMatch, context);
        return this;
    }

    SchemaContractImpl(String name, ApiManagementManager serviceManager) {
        this.innerObject = new SchemaContractInner();
        this.serviceManager = serviceManager;
        this.schemaId = name;
        this.createIfMatch = null;
    }

    @Override
    public SchemaContractImpl update() {
        this.updateIfMatch = null;
        return this;
    }

    @Override
    public SchemaContract apply() {
        this.innerObject = this.serviceManager.serviceClient().getApiSchemas().createOrUpdate(this.resourceGroupName, this.serviceName, this.apiId, this.schemaId, this.innerModel(), this.updateIfMatch, Context.NONE);
        return this;
    }

    @Override
    public SchemaContract apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getApiSchemas().createOrUpdate(this.resourceGroupName, this.serviceName, this.apiId, this.schemaId, this.innerModel(), this.updateIfMatch, context);
        return this;
    }

    SchemaContractImpl(SchemaContractInner innerObject, ApiManagementManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.serviceName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "service");
        this.apiId = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "apis");
        this.schemaId = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "schemas");
    }

    @Override
    public SchemaContract refresh() {
        this.innerObject = this.serviceManager.serviceClient().getApiSchemas().getWithResponse(this.resourceGroupName, this.serviceName, this.apiId, this.schemaId, Context.NONE).getValue();
        return this;
    }

    @Override
    public SchemaContract refresh(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getApiSchemas().getWithResponse(this.resourceGroupName, this.serviceName, this.apiId, this.schemaId, context).getValue();
        return this;
    }

    @Override
    public SchemaContractImpl withContentType(String contentType) {
        this.innerModel().withContentType(contentType);
        return this;
    }

    @Override
    public SchemaContractImpl withValue(String value) {
        this.innerModel().withValue(value);
        return this;
    }

    @Override
    public SchemaContractImpl withDefinitions(Object definitions) {
        this.innerModel().withDefinitions(definitions);
        return this;
    }

    @Override
    public SchemaContractImpl withComponents(Object components) {
        this.innerModel().withComponents(components);
        return this;
    }

    @Override
    public SchemaContractImpl withIfMatch(String ifMatch) {
        if (this.isInCreateMode()) {
            this.createIfMatch = ifMatch;
            return this;
        }
        this.updateIfMatch = ifMatch;
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel().id() == null;
    }
}

