/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.util.Context;
import com.azure.resourcemanager.apimanagement.ApiManagementManager;
import com.azure.resourcemanager.apimanagement.fluent.models.TagDescriptionContractInner;
import com.azure.resourcemanager.apimanagement.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.apimanagement.models.TagDescriptionContract;
import com.azure.resourcemanager.apimanagement.models.TagDescriptionCreateParameters;

public final class TagDescriptionContractImpl
implements TagDescriptionContract,
TagDescriptionContract.Definition,
TagDescriptionContract.Update {
    private TagDescriptionContractInner innerObject;
    private final ApiManagementManager serviceManager;
    private String resourceGroupName;
    private String serviceName;
    private String apiId;
    private String tagDescriptionId;
    private String createIfMatch;
    private TagDescriptionCreateParameters createParameters;
    private String updateIfMatch;
    private TagDescriptionCreateParameters updateParameters;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String tagId() {
        return this.innerModel().tagId();
    }

    @Override
    public String displayName() {
        return this.innerModel().displayName();
    }

    @Override
    public String description() {
        return this.innerModel().description();
    }

    @Override
    public String externalDocsUrl() {
        return this.innerModel().externalDocsUrl();
    }

    @Override
    public String externalDocsDescription() {
        return this.innerModel().externalDocsDescription();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public TagDescriptionContractInner innerModel() {
        return this.innerObject;
    }

    private ApiManagementManager manager() {
        return this.serviceManager;
    }

    @Override
    public TagDescriptionContractImpl withExistingApi(String resourceGroupName, String serviceName, String apiId) {
        this.resourceGroupName = resourceGroupName;
        this.serviceName = serviceName;
        this.apiId = apiId;
        return this;
    }

    @Override
    public TagDescriptionContract create() {
        this.innerObject = this.serviceManager.serviceClient().getApiTagDescriptions().createOrUpdateWithResponse(this.resourceGroupName, this.serviceName, this.apiId, this.tagDescriptionId, this.createParameters, this.createIfMatch, Context.NONE).getValue();
        return this;
    }

    @Override
    public TagDescriptionContract create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getApiTagDescriptions().createOrUpdateWithResponse(this.resourceGroupName, this.serviceName, this.apiId, this.tagDescriptionId, this.createParameters, this.createIfMatch, context).getValue();
        return this;
    }

    TagDescriptionContractImpl(String name, ApiManagementManager serviceManager) {
        this.innerObject = new TagDescriptionContractInner();
        this.serviceManager = serviceManager;
        this.tagDescriptionId = name;
        this.createIfMatch = null;
        this.createParameters = new TagDescriptionCreateParameters();
    }

    @Override
    public TagDescriptionContractImpl update() {
        this.updateIfMatch = null;
        this.updateParameters = new TagDescriptionCreateParameters();
        return this;
    }

    @Override
    public TagDescriptionContract apply() {
        this.innerObject = this.serviceManager.serviceClient().getApiTagDescriptions().createOrUpdateWithResponse(this.resourceGroupName, this.serviceName, this.apiId, this.tagDescriptionId, this.updateParameters, this.updateIfMatch, Context.NONE).getValue();
        return this;
    }

    @Override
    public TagDescriptionContract apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getApiTagDescriptions().createOrUpdateWithResponse(this.resourceGroupName, this.serviceName, this.apiId, this.tagDescriptionId, this.updateParameters, this.updateIfMatch, context).getValue();
        return this;
    }

    TagDescriptionContractImpl(TagDescriptionContractInner innerObject, ApiManagementManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.serviceName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "service");
        this.apiId = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "apis");
        this.tagDescriptionId = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "tagDescriptions");
    }

    @Override
    public TagDescriptionContract refresh() {
        this.innerObject = this.serviceManager.serviceClient().getApiTagDescriptions().getWithResponse(this.resourceGroupName, this.serviceName, this.apiId, this.tagDescriptionId, Context.NONE).getValue();
        return this;
    }

    @Override
    public TagDescriptionContract refresh(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getApiTagDescriptions().getWithResponse(this.resourceGroupName, this.serviceName, this.apiId, this.tagDescriptionId, context).getValue();
        return this;
    }

    @Override
    public TagDescriptionContractImpl withDescription(String description) {
        if (this.isInCreateMode()) {
            this.createParameters.withDescription(description);
            return this;
        }
        this.updateParameters.withDescription(description);
        return this;
    }

    @Override
    public TagDescriptionContractImpl withExternalDocsUrl(String externalDocsUrl) {
        if (this.isInCreateMode()) {
            this.createParameters.withExternalDocsUrl(externalDocsUrl);
            return this;
        }
        this.updateParameters.withExternalDocsUrl(externalDocsUrl);
        return this;
    }

    @Override
    public TagDescriptionContractImpl withExternalDocsDescription(String externalDocsDescription) {
        if (this.isInCreateMode()) {
            this.createParameters.withExternalDocsDescription(externalDocsDescription);
            return this;
        }
        this.updateParameters.withExternalDocsDescription(externalDocsDescription);
        return this;
    }

    @Override
    public TagDescriptionContractImpl withIfMatch(String ifMatch) {
        if (this.isInCreateMode()) {
            this.createIfMatch = ifMatch;
            return this;
        }
        this.updateIfMatch = ifMatch;
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel().id() == null;
    }
}

