/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.apimanagement.ApiManagementManager;
import com.azure.resourcemanager.apimanagement.fluent.TenantAccessGitsClient;
import com.azure.resourcemanager.apimanagement.models.AccessIdName;
import com.azure.resourcemanager.apimanagement.models.TenantAccessGits;

public final class TenantAccessGitsImpl
implements TenantAccessGits {
    private static final ClientLogger LOGGER = new ClientLogger(TenantAccessGitsImpl.class);
    private final TenantAccessGitsClient innerClient;
    private final ApiManagementManager serviceManager;

    public TenantAccessGitsImpl(TenantAccessGitsClient innerClient, ApiManagementManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<Void> regeneratePrimaryKeyWithResponse(String resourceGroupName, String serviceName, AccessIdName accessName, Context context) {
        return this.serviceClient().regeneratePrimaryKeyWithResponse(resourceGroupName, serviceName, accessName, context);
    }

    @Override
    public void regeneratePrimaryKey(String resourceGroupName, String serviceName, AccessIdName accessName) {
        this.serviceClient().regeneratePrimaryKey(resourceGroupName, serviceName, accessName);
    }

    @Override
    public Response<Void> regenerateSecondaryKeyWithResponse(String resourceGroupName, String serviceName, AccessIdName accessName, Context context) {
        return this.serviceClient().regenerateSecondaryKeyWithResponse(resourceGroupName, serviceName, accessName, context);
    }

    @Override
    public void regenerateSecondaryKey(String resourceGroupName, String serviceName, AccessIdName accessName) {
        this.serviceClient().regenerateSecondaryKey(resourceGroupName, serviceName, accessName);
    }

    private TenantAccessGitsClient serviceClient() {
        return this.innerClient;
    }

    private ApiManagementManager manager() {
        return this.serviceManager;
    }
}

