/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.apimanagement.fluent.TenantConfigurationsClient;
import com.azure.resourcemanager.apimanagement.fluent.models.OperationResultContractInner;
import com.azure.resourcemanager.apimanagement.fluent.models.TenantConfigurationSyncStateContractInner;
import com.azure.resourcemanager.apimanagement.implementation.ApiManagementClientImpl;
import com.azure.resourcemanager.apimanagement.models.ConfigurationIdName;
import com.azure.resourcemanager.apimanagement.models.DeployConfigurationParameters;
import com.azure.resourcemanager.apimanagement.models.SaveConfigurationParameter;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class TenantConfigurationsClientImpl
implements TenantConfigurationsClient {
    private final TenantConfigurationsService service;
    private final ApiManagementClientImpl client;

    TenantConfigurationsClientImpl(ApiManagementClientImpl client) {
        this.service = (TenantConfigurationsService)RestProxy.create(TenantConfigurationsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deployWithResponseAsync(String resourceGroupName, String serviceName, ConfigurationIdName configurationName, DeployConfigurationParameters parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (configurationName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter configurationName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.deploy(this.client.getEndpoint(), resourceGroupName, serviceName, this.client.getApiVersion(), this.client.getSubscriptionId(), configurationName, parameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deployWithResponseAsync(String resourceGroupName, String serviceName, ConfigurationIdName configurationName, DeployConfigurationParameters parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (configurationName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter configurationName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.deploy(this.client.getEndpoint(), resourceGroupName, serviceName, this.client.getApiVersion(), this.client.getSubscriptionId(), configurationName, parameters, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<OperationResultContractInner>, OperationResultContractInner> beginDeployAsync(String resourceGroupName, String serviceName, ConfigurationIdName configurationName, DeployConfigurationParameters parameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.deployWithResponseAsync(resourceGroupName, serviceName, configurationName, parameters);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)OperationResultContractInner.class), (Type)((Object)OperationResultContractInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<OperationResultContractInner>, OperationResultContractInner> beginDeployAsync(String resourceGroupName, String serviceName, ConfigurationIdName configurationName, DeployConfigurationParameters parameters, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.deployWithResponseAsync(resourceGroupName, serviceName, configurationName, parameters, context);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)OperationResultContractInner.class), (Type)((Object)OperationResultContractInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<OperationResultContractInner>, OperationResultContractInner> beginDeploy(String resourceGroupName, String serviceName, ConfigurationIdName configurationName, DeployConfigurationParameters parameters) {
        return this.beginDeployAsync(resourceGroupName, serviceName, configurationName, parameters).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<OperationResultContractInner>, OperationResultContractInner> beginDeploy(String resourceGroupName, String serviceName, ConfigurationIdName configurationName, DeployConfigurationParameters parameters, Context context) {
        return this.beginDeployAsync(resourceGroupName, serviceName, configurationName, parameters, context).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<OperationResultContractInner> deployAsync(String resourceGroupName, String serviceName, ConfigurationIdName configurationName, DeployConfigurationParameters parameters) {
        return this.beginDeployAsync(resourceGroupName, serviceName, configurationName, parameters).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<OperationResultContractInner> deployAsync(String resourceGroupName, String serviceName, ConfigurationIdName configurationName, DeployConfigurationParameters parameters, Context context) {
        return this.beginDeployAsync(resourceGroupName, serviceName, configurationName, parameters, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public OperationResultContractInner deploy(String resourceGroupName, String serviceName, ConfigurationIdName configurationName, DeployConfigurationParameters parameters) {
        return (OperationResultContractInner)((Object)this.deployAsync(resourceGroupName, serviceName, configurationName, parameters).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public OperationResultContractInner deploy(String resourceGroupName, String serviceName, ConfigurationIdName configurationName, DeployConfigurationParameters parameters, Context context) {
        return (OperationResultContractInner)((Object)this.deployAsync(resourceGroupName, serviceName, configurationName, parameters, context).block());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> saveWithResponseAsync(String resourceGroupName, String serviceName, ConfigurationIdName configurationName, SaveConfigurationParameter parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (configurationName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter configurationName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.save(this.client.getEndpoint(), resourceGroupName, serviceName, this.client.getApiVersion(), this.client.getSubscriptionId(), configurationName, parameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> saveWithResponseAsync(String resourceGroupName, String serviceName, ConfigurationIdName configurationName, SaveConfigurationParameter parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (configurationName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter configurationName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.save(this.client.getEndpoint(), resourceGroupName, serviceName, this.client.getApiVersion(), this.client.getSubscriptionId(), configurationName, parameters, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<OperationResultContractInner>, OperationResultContractInner> beginSaveAsync(String resourceGroupName, String serviceName, ConfigurationIdName configurationName, SaveConfigurationParameter parameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.saveWithResponseAsync(resourceGroupName, serviceName, configurationName, parameters);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)OperationResultContractInner.class), (Type)((Object)OperationResultContractInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<OperationResultContractInner>, OperationResultContractInner> beginSaveAsync(String resourceGroupName, String serviceName, ConfigurationIdName configurationName, SaveConfigurationParameter parameters, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.saveWithResponseAsync(resourceGroupName, serviceName, configurationName, parameters, context);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)OperationResultContractInner.class), (Type)((Object)OperationResultContractInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<OperationResultContractInner>, OperationResultContractInner> beginSave(String resourceGroupName, String serviceName, ConfigurationIdName configurationName, SaveConfigurationParameter parameters) {
        return this.beginSaveAsync(resourceGroupName, serviceName, configurationName, parameters).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<OperationResultContractInner>, OperationResultContractInner> beginSave(String resourceGroupName, String serviceName, ConfigurationIdName configurationName, SaveConfigurationParameter parameters, Context context) {
        return this.beginSaveAsync(resourceGroupName, serviceName, configurationName, parameters, context).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<OperationResultContractInner> saveAsync(String resourceGroupName, String serviceName, ConfigurationIdName configurationName, SaveConfigurationParameter parameters) {
        return this.beginSaveAsync(resourceGroupName, serviceName, configurationName, parameters).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<OperationResultContractInner> saveAsync(String resourceGroupName, String serviceName, ConfigurationIdName configurationName, SaveConfigurationParameter parameters, Context context) {
        return this.beginSaveAsync(resourceGroupName, serviceName, configurationName, parameters, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public OperationResultContractInner save(String resourceGroupName, String serviceName, ConfigurationIdName configurationName, SaveConfigurationParameter parameters) {
        return (OperationResultContractInner)((Object)this.saveAsync(resourceGroupName, serviceName, configurationName, parameters).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public OperationResultContractInner save(String resourceGroupName, String serviceName, ConfigurationIdName configurationName, SaveConfigurationParameter parameters, Context context) {
        return (OperationResultContractInner)((Object)this.saveAsync(resourceGroupName, serviceName, configurationName, parameters, context).block());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> validateWithResponseAsync(String resourceGroupName, String serviceName, ConfigurationIdName configurationName, DeployConfigurationParameters parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (configurationName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter configurationName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.validate(this.client.getEndpoint(), resourceGroupName, serviceName, this.client.getApiVersion(), this.client.getSubscriptionId(), configurationName, parameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> validateWithResponseAsync(String resourceGroupName, String serviceName, ConfigurationIdName configurationName, DeployConfigurationParameters parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (configurationName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter configurationName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.validate(this.client.getEndpoint(), resourceGroupName, serviceName, this.client.getApiVersion(), this.client.getSubscriptionId(), configurationName, parameters, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<OperationResultContractInner>, OperationResultContractInner> beginValidateAsync(String resourceGroupName, String serviceName, ConfigurationIdName configurationName, DeployConfigurationParameters parameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.validateWithResponseAsync(resourceGroupName, serviceName, configurationName, parameters);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)OperationResultContractInner.class), (Type)((Object)OperationResultContractInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<OperationResultContractInner>, OperationResultContractInner> beginValidateAsync(String resourceGroupName, String serviceName, ConfigurationIdName configurationName, DeployConfigurationParameters parameters, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.validateWithResponseAsync(resourceGroupName, serviceName, configurationName, parameters, context);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)OperationResultContractInner.class), (Type)((Object)OperationResultContractInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<OperationResultContractInner>, OperationResultContractInner> beginValidate(String resourceGroupName, String serviceName, ConfigurationIdName configurationName, DeployConfigurationParameters parameters) {
        return this.beginValidateAsync(resourceGroupName, serviceName, configurationName, parameters).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<OperationResultContractInner>, OperationResultContractInner> beginValidate(String resourceGroupName, String serviceName, ConfigurationIdName configurationName, DeployConfigurationParameters parameters, Context context) {
        return this.beginValidateAsync(resourceGroupName, serviceName, configurationName, parameters, context).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<OperationResultContractInner> validateAsync(String resourceGroupName, String serviceName, ConfigurationIdName configurationName, DeployConfigurationParameters parameters) {
        return this.beginValidateAsync(resourceGroupName, serviceName, configurationName, parameters).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<OperationResultContractInner> validateAsync(String resourceGroupName, String serviceName, ConfigurationIdName configurationName, DeployConfigurationParameters parameters, Context context) {
        return this.beginValidateAsync(resourceGroupName, serviceName, configurationName, parameters, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public OperationResultContractInner validate(String resourceGroupName, String serviceName, ConfigurationIdName configurationName, DeployConfigurationParameters parameters) {
        return (OperationResultContractInner)((Object)this.validateAsync(resourceGroupName, serviceName, configurationName, parameters).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public OperationResultContractInner validate(String resourceGroupName, String serviceName, ConfigurationIdName configurationName, DeployConfigurationParameters parameters, Context context) {
        return (OperationResultContractInner)((Object)this.validateAsync(resourceGroupName, serviceName, configurationName, parameters, context).block());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<TenantConfigurationSyncStateContractInner>> getSyncStateWithResponseAsync(String resourceGroupName, String serviceName, ConfigurationIdName configurationName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (configurationName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter configurationName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getSyncState(this.client.getEndpoint(), resourceGroupName, serviceName, this.client.getApiVersion(), this.client.getSubscriptionId(), configurationName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<TenantConfigurationSyncStateContractInner>> getSyncStateWithResponseAsync(String resourceGroupName, String serviceName, ConfigurationIdName configurationName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (configurationName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter configurationName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getSyncState(this.client.getEndpoint(), resourceGroupName, serviceName, this.client.getApiVersion(), this.client.getSubscriptionId(), configurationName, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<TenantConfigurationSyncStateContractInner> getSyncStateAsync(String resourceGroupName, String serviceName, ConfigurationIdName configurationName) {
        return this.getSyncStateWithResponseAsync(resourceGroupName, serviceName, configurationName).flatMap(res -> Mono.justOrEmpty((Object)((Object)((TenantConfigurationSyncStateContractInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<TenantConfigurationSyncStateContractInner> getSyncStateWithResponse(String resourceGroupName, String serviceName, ConfigurationIdName configurationName, Context context) {
        return (Response)this.getSyncStateWithResponseAsync(resourceGroupName, serviceName, configurationName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public TenantConfigurationSyncStateContractInner getSyncState(String resourceGroupName, String serviceName, ConfigurationIdName configurationName) {
        return (TenantConfigurationSyncStateContractInner)((Object)this.getSyncStateWithResponse(resourceGroupName, serviceName, configurationName, Context.NONE).getValue());
    }

    @Host(value="{$host}")
    @ServiceInterface(name="ApiManagementClientT")
    public static interface TenantConfigurationsService {
        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/tenant/{configurationName}/deploy")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> deploy(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="serviceName") String var3, @QueryParam(value="api-version") String var4, @PathParam(value="subscriptionId") String var5, @PathParam(value="configurationName") ConfigurationIdName var6, @BodyParam(value="application/json") DeployConfigurationParameters var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/tenant/{configurationName}/save")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> save(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="serviceName") String var3, @QueryParam(value="api-version") String var4, @PathParam(value="subscriptionId") String var5, @PathParam(value="configurationName") ConfigurationIdName var6, @BodyParam(value="application/json") SaveConfigurationParameter var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/tenant/{configurationName}/validate")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> validate(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="serviceName") String var3, @QueryParam(value="api-version") String var4, @PathParam(value="subscriptionId") String var5, @PathParam(value="configurationName") ConfigurationIdName var6, @BodyParam(value="application/json") DeployConfigurationParameters var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/tenant/{configurationName}/syncState")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<TenantConfigurationSyncStateContractInner>> getSyncState(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="serviceName") String var3, @QueryParam(value="api-version") String var4, @PathParam(value="subscriptionId") String var5, @PathParam(value="configurationName") ConfigurationIdName var6, @HeaderParam(value="Accept") String var7, Context var8);
    }
}

