/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.apimanagement.models.ApiContactInformation;
import com.azure.resourcemanager.apimanagement.models.ApiLicenseInformation;
import com.azure.resourcemanager.apimanagement.models.ApiType;
import com.azure.resourcemanager.apimanagement.models.AuthenticationSettingsContract;
import com.azure.resourcemanager.apimanagement.models.SubscriptionKeyParameterNamesContract;
import java.io.IOException;

public class ApiEntityBaseContract
implements JsonSerializable<ApiEntityBaseContract> {
    private String description;
    private AuthenticationSettingsContract authenticationSettings;
    private SubscriptionKeyParameterNamesContract subscriptionKeyParameterNames;
    private ApiType apiType;
    private String apiRevision;
    private String apiVersion;
    private Boolean isCurrent;
    private Boolean isOnline;
    private String apiRevisionDescription;
    private String apiVersionDescription;
    private String apiVersionSetId;
    private Boolean subscriptionRequired;
    private String termsOfServiceUrl;
    private ApiContactInformation contact;
    private ApiLicenseInformation license;

    public String description() {
        return this.description;
    }

    public ApiEntityBaseContract withDescription(String description) {
        this.description = description;
        return this;
    }

    public AuthenticationSettingsContract authenticationSettings() {
        return this.authenticationSettings;
    }

    public ApiEntityBaseContract withAuthenticationSettings(AuthenticationSettingsContract authenticationSettings) {
        this.authenticationSettings = authenticationSettings;
        return this;
    }

    public SubscriptionKeyParameterNamesContract subscriptionKeyParameterNames() {
        return this.subscriptionKeyParameterNames;
    }

    public ApiEntityBaseContract withSubscriptionKeyParameterNames(SubscriptionKeyParameterNamesContract subscriptionKeyParameterNames) {
        this.subscriptionKeyParameterNames = subscriptionKeyParameterNames;
        return this;
    }

    public ApiType apiType() {
        return this.apiType;
    }

    public ApiEntityBaseContract withApiType(ApiType apiType) {
        this.apiType = apiType;
        return this;
    }

    public String apiRevision() {
        return this.apiRevision;
    }

    public ApiEntityBaseContract withApiRevision(String apiRevision) {
        this.apiRevision = apiRevision;
        return this;
    }

    public String apiVersion() {
        return this.apiVersion;
    }

    public ApiEntityBaseContract withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return this;
    }

    public Boolean isCurrent() {
        return this.isCurrent;
    }

    public ApiEntityBaseContract withIsCurrent(Boolean isCurrent) {
        this.isCurrent = isCurrent;
        return this;
    }

    public Boolean isOnline() {
        return this.isOnline;
    }

    ApiEntityBaseContract withIsOnline(Boolean isOnline) {
        this.isOnline = isOnline;
        return this;
    }

    public String apiRevisionDescription() {
        return this.apiRevisionDescription;
    }

    public ApiEntityBaseContract withApiRevisionDescription(String apiRevisionDescription) {
        this.apiRevisionDescription = apiRevisionDescription;
        return this;
    }

    public String apiVersionDescription() {
        return this.apiVersionDescription;
    }

    public ApiEntityBaseContract withApiVersionDescription(String apiVersionDescription) {
        this.apiVersionDescription = apiVersionDescription;
        return this;
    }

    public String apiVersionSetId() {
        return this.apiVersionSetId;
    }

    public ApiEntityBaseContract withApiVersionSetId(String apiVersionSetId) {
        this.apiVersionSetId = apiVersionSetId;
        return this;
    }

    public Boolean subscriptionRequired() {
        return this.subscriptionRequired;
    }

    public ApiEntityBaseContract withSubscriptionRequired(Boolean subscriptionRequired) {
        this.subscriptionRequired = subscriptionRequired;
        return this;
    }

    public String termsOfServiceUrl() {
        return this.termsOfServiceUrl;
    }

    public ApiEntityBaseContract withTermsOfServiceUrl(String termsOfServiceUrl) {
        this.termsOfServiceUrl = termsOfServiceUrl;
        return this;
    }

    public ApiContactInformation contact() {
        return this.contact;
    }

    public ApiEntityBaseContract withContact(ApiContactInformation contact) {
        this.contact = contact;
        return this;
    }

    public ApiLicenseInformation license() {
        return this.license;
    }

    public ApiEntityBaseContract withLicense(ApiLicenseInformation license) {
        this.license = license;
        return this;
    }

    public void validate() {
        if (this.authenticationSettings() != null) {
            this.authenticationSettings().validate();
        }
        if (this.subscriptionKeyParameterNames() != null) {
            this.subscriptionKeyParameterNames().validate();
        }
        if (this.contact() != null) {
            this.contact().validate();
        }
        if (this.license() != null) {
            this.license().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeJsonField("authenticationSettings", (JsonSerializable)this.authenticationSettings);
        jsonWriter.writeJsonField("subscriptionKeyParameterNames", (JsonSerializable)this.subscriptionKeyParameterNames);
        jsonWriter.writeStringField("type", this.apiType == null ? null : this.apiType.toString());
        jsonWriter.writeStringField("apiRevision", this.apiRevision);
        jsonWriter.writeStringField("apiVersion", this.apiVersion);
        jsonWriter.writeBooleanField("isCurrent", this.isCurrent);
        jsonWriter.writeStringField("apiRevisionDescription", this.apiRevisionDescription);
        jsonWriter.writeStringField("apiVersionDescription", this.apiVersionDescription);
        jsonWriter.writeStringField("apiVersionSetId", this.apiVersionSetId);
        jsonWriter.writeBooleanField("subscriptionRequired", this.subscriptionRequired);
        jsonWriter.writeStringField("termsOfServiceUrl", this.termsOfServiceUrl);
        jsonWriter.writeJsonField("contact", (JsonSerializable)this.contact);
        jsonWriter.writeJsonField("license", (JsonSerializable)this.license);
        return jsonWriter.writeEndObject();
    }

    public static ApiEntityBaseContract fromJson(JsonReader jsonReader) throws IOException {
        return (ApiEntityBaseContract)jsonReader.readObject(reader -> {
            ApiEntityBaseContract deserializedApiEntityBaseContract = new ApiEntityBaseContract();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("description".equals(fieldName)) {
                    deserializedApiEntityBaseContract.description = reader.getString();
                    continue;
                }
                if ("authenticationSettings".equals(fieldName)) {
                    deserializedApiEntityBaseContract.authenticationSettings = AuthenticationSettingsContract.fromJson(reader);
                    continue;
                }
                if ("subscriptionKeyParameterNames".equals(fieldName)) {
                    deserializedApiEntityBaseContract.subscriptionKeyParameterNames = SubscriptionKeyParameterNamesContract.fromJson(reader);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedApiEntityBaseContract.apiType = ApiType.fromString(reader.getString());
                    continue;
                }
                if ("apiRevision".equals(fieldName)) {
                    deserializedApiEntityBaseContract.apiRevision = reader.getString();
                    continue;
                }
                if ("apiVersion".equals(fieldName)) {
                    deserializedApiEntityBaseContract.apiVersion = reader.getString();
                    continue;
                }
                if ("isCurrent".equals(fieldName)) {
                    deserializedApiEntityBaseContract.isCurrent = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("isOnline".equals(fieldName)) {
                    deserializedApiEntityBaseContract.isOnline = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("apiRevisionDescription".equals(fieldName)) {
                    deserializedApiEntityBaseContract.apiRevisionDescription = reader.getString();
                    continue;
                }
                if ("apiVersionDescription".equals(fieldName)) {
                    deserializedApiEntityBaseContract.apiVersionDescription = reader.getString();
                    continue;
                }
                if ("apiVersionSetId".equals(fieldName)) {
                    deserializedApiEntityBaseContract.apiVersionSetId = reader.getString();
                    continue;
                }
                if ("subscriptionRequired".equals(fieldName)) {
                    deserializedApiEntityBaseContract.subscriptionRequired = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("termsOfServiceUrl".equals(fieldName)) {
                    deserializedApiEntityBaseContract.termsOfServiceUrl = reader.getString();
                    continue;
                }
                if ("contact".equals(fieldName)) {
                    deserializedApiEntityBaseContract.contact = ApiContactInformation.fromJson(reader);
                    continue;
                }
                if ("license".equals(fieldName)) {
                    deserializedApiEntityBaseContract.license = ApiLicenseInformation.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedApiEntityBaseContract;
        });
    }
}

