/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.apimanagement.models.ApimIdentityType;
import com.azure.resourcemanager.apimanagement.models.UserIdentityProperties;
import java.io.IOException;
import java.util.Map;
import java.util.UUID;

public final class ApiManagementServiceIdentity
implements JsonSerializable<ApiManagementServiceIdentity> {
    private ApimIdentityType type;
    private UUID principalId;
    private UUID tenantId;
    private Map<String, UserIdentityProperties> userAssignedIdentities;
    private static final ClientLogger LOGGER = new ClientLogger(ApiManagementServiceIdentity.class);

    public ApimIdentityType type() {
        return this.type;
    }

    public ApiManagementServiceIdentity withType(ApimIdentityType type) {
        this.type = type;
        return this;
    }

    public UUID principalId() {
        return this.principalId;
    }

    public UUID tenantId() {
        return this.tenantId;
    }

    public Map<String, UserIdentityProperties> userAssignedIdentities() {
        return this.userAssignedIdentities;
    }

    public ApiManagementServiceIdentity withUserAssignedIdentities(Map<String, UserIdentityProperties> userAssignedIdentities) {
        this.userAssignedIdentities = userAssignedIdentities;
        return this;
    }

    public void validate() {
        if (this.type() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property type in model ApiManagementServiceIdentity"));
        }
        if (this.userAssignedIdentities() != null) {
            this.userAssignedIdentities().values().forEach(e -> {
                if (e != null) {
                    e.validate();
                }
            });
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeMapField("userAssignedIdentities", this.userAssignedIdentities, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static ApiManagementServiceIdentity fromJson(JsonReader jsonReader) throws IOException {
        return (ApiManagementServiceIdentity)jsonReader.readObject(reader -> {
            ApiManagementServiceIdentity deserializedApiManagementServiceIdentity = new ApiManagementServiceIdentity();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("type".equals(fieldName)) {
                    deserializedApiManagementServiceIdentity.type = ApimIdentityType.fromString(reader.getString());
                    continue;
                }
                if ("principalId".equals(fieldName)) {
                    deserializedApiManagementServiceIdentity.principalId = (UUID)reader.getNullable(nonNullReader -> UUID.fromString(nonNullReader.getString()));
                    continue;
                }
                if ("tenantId".equals(fieldName)) {
                    deserializedApiManagementServiceIdentity.tenantId = (UUID)reader.getNullable(nonNullReader -> UUID.fromString(nonNullReader.getString()));
                    continue;
                }
                if ("userAssignedIdentities".equals(fieldName)) {
                    Map userAssignedIdentities;
                    deserializedApiManagementServiceIdentity.userAssignedIdentities = userAssignedIdentities = reader.readMap(reader1 -> UserIdentityProperties.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedApiManagementServiceIdentity;
        });
    }
}

