/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.models;

import com.azure.core.management.ProxyResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.apimanagement.fluent.models.AssociationContractProperties;
import com.azure.resourcemanager.apimanagement.models.ProvisioningState;
import java.io.IOException;

public final class AssociationContract
extends ProxyResource {
    private AssociationContractProperties innerProperties;
    private String type;
    private String name;
    private String id;

    private AssociationContractProperties innerProperties() {
        return this.innerProperties;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public AssociationContract withProvisioningState(ProvisioningState provisioningState) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AssociationContractProperties();
        }
        this.innerProperties().withProvisioningState(provisioningState);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static AssociationContract fromJson(JsonReader jsonReader) throws IOException {
        return (AssociationContract)((Object)jsonReader.readObject(reader -> {
            AssociationContract deserializedAssociationContract = new AssociationContract();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedAssociationContract.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedAssociationContract.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedAssociationContract.type = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedAssociationContract.innerProperties = AssociationContractProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAssociationContract;
        }));
    }
}

