/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.apimanagement.models.BackendCredentialsContract;
import com.azure.resourcemanager.apimanagement.models.BackendProperties;
import com.azure.resourcemanager.apimanagement.models.BackendProxyContract;
import com.azure.resourcemanager.apimanagement.models.BackendTlsProperties;
import java.io.IOException;

public class BackendBaseParameters
implements JsonSerializable<BackendBaseParameters> {
    private String title;
    private String description;
    private String resourceId;
    private BackendProperties properties;
    private BackendCredentialsContract credentials;
    private BackendProxyContract proxy;
    private BackendTlsProperties tls;

    public String title() {
        return this.title;
    }

    public BackendBaseParameters withTitle(String title) {
        this.title = title;
        return this;
    }

    public String description() {
        return this.description;
    }

    public BackendBaseParameters withDescription(String description) {
        this.description = description;
        return this;
    }

    public String resourceId() {
        return this.resourceId;
    }

    public BackendBaseParameters withResourceId(String resourceId) {
        this.resourceId = resourceId;
        return this;
    }

    public BackendProperties properties() {
        return this.properties;
    }

    public BackendBaseParameters withProperties(BackendProperties properties) {
        this.properties = properties;
        return this;
    }

    public BackendCredentialsContract credentials() {
        return this.credentials;
    }

    public BackendBaseParameters withCredentials(BackendCredentialsContract credentials) {
        this.credentials = credentials;
        return this;
    }

    public BackendProxyContract proxy() {
        return this.proxy;
    }

    public BackendBaseParameters withProxy(BackendProxyContract proxy) {
        this.proxy = proxy;
        return this;
    }

    public BackendTlsProperties tls() {
        return this.tls;
    }

    public BackendBaseParameters withTls(BackendTlsProperties tls) {
        this.tls = tls;
        return this;
    }

    public void validate() {
        if (this.properties() != null) {
            this.properties().validate();
        }
        if (this.credentials() != null) {
            this.credentials().validate();
        }
        if (this.proxy() != null) {
            this.proxy().validate();
        }
        if (this.tls() != null) {
            this.tls().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("title", this.title);
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeStringField("resourceId", this.resourceId);
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.properties);
        jsonWriter.writeJsonField("credentials", (JsonSerializable)this.credentials);
        jsonWriter.writeJsonField("proxy", (JsonSerializable)this.proxy);
        jsonWriter.writeJsonField("tls", (JsonSerializable)this.tls);
        return jsonWriter.writeEndObject();
    }

    public static BackendBaseParameters fromJson(JsonReader jsonReader) throws IOException {
        return (BackendBaseParameters)jsonReader.readObject(reader -> {
            BackendBaseParameters deserializedBackendBaseParameters = new BackendBaseParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("title".equals(fieldName)) {
                    deserializedBackendBaseParameters.title = reader.getString();
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedBackendBaseParameters.description = reader.getString();
                    continue;
                }
                if ("resourceId".equals(fieldName)) {
                    deserializedBackendBaseParameters.resourceId = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedBackendBaseParameters.properties = BackendProperties.fromJson(reader);
                    continue;
                }
                if ("credentials".equals(fieldName)) {
                    deserializedBackendBaseParameters.credentials = BackendCredentialsContract.fromJson(reader);
                    continue;
                }
                if ("proxy".equals(fieldName)) {
                    deserializedBackendBaseParameters.proxy = BackendProxyContract.fromJson(reader);
                    continue;
                }
                if ("tls".equals(fieldName)) {
                    deserializedBackendBaseParameters.tls = BackendTlsProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedBackendBaseParameters;
        });
    }
}

