/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.models;

import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.resourcemanager.apimanagement.fluent.models.BackendContractInner;
import com.azure.resourcemanager.apimanagement.models.BackendCredentialsContract;
import com.azure.resourcemanager.apimanagement.models.BackendProperties;
import com.azure.resourcemanager.apimanagement.models.BackendProtocol;
import com.azure.resourcemanager.apimanagement.models.BackendProxyContract;
import com.azure.resourcemanager.apimanagement.models.BackendReconnectContract;
import com.azure.resourcemanager.apimanagement.models.BackendTlsProperties;

public interface BackendContract {
    public String id();

    public String name();

    public String type();

    public String url();

    public BackendProtocol protocol();

    public String title();

    public String description();

    public String resourceId();

    public BackendProperties properties();

    public BackendCredentialsContract credentials();

    public BackendProxyContract proxy();

    public BackendTlsProperties tls();

    public String resourceGroupName();

    public BackendContractInner innerModel();

    public Update update();

    public BackendContract refresh();

    public BackendContract refresh(Context var1);

    public Response<Void> reconnectWithResponse(BackendReconnectContract var1, Context var2);

    public void reconnect();

    public static interface UpdateStages {

        public static interface WithIfMatch {
            public Update withIfMatch(String var1);
        }

        public static interface WithTls {
            public Update withTls(BackendTlsProperties var1);
        }

        public static interface WithProxy {
            public Update withProxy(BackendProxyContract var1);
        }

        public static interface WithCredentials {
            public Update withCredentials(BackendCredentialsContract var1);
        }

        public static interface WithProperties {
            public Update withProperties(BackendProperties var1);
        }

        public static interface WithResourceId {
            public Update withResourceId(String var1);
        }

        public static interface WithDescription {
            public Update withDescription(String var1);
        }

        public static interface WithTitle {
            public Update withTitle(String var1);
        }

        public static interface WithProtocol {
            public Update withProtocol(BackendProtocol var1);
        }

        public static interface WithUrl {
            public Update withUrl(String var1);
        }
    }

    public static interface Update
    extends UpdateStages.WithUrl,
    UpdateStages.WithProtocol,
    UpdateStages.WithTitle,
    UpdateStages.WithDescription,
    UpdateStages.WithResourceId,
    UpdateStages.WithProperties,
    UpdateStages.WithCredentials,
    UpdateStages.WithProxy,
    UpdateStages.WithTls,
    UpdateStages.WithIfMatch {
        public BackendContract apply();

        public BackendContract apply(Context var1);
    }

    public static interface DefinitionStages {

        public static interface WithIfMatch {
            public WithCreate withIfMatch(String var1);
        }

        public static interface WithTls {
            public WithCreate withTls(BackendTlsProperties var1);
        }

        public static interface WithProxy {
            public WithCreate withProxy(BackendProxyContract var1);
        }

        public static interface WithCredentials {
            public WithCreate withCredentials(BackendCredentialsContract var1);
        }

        public static interface WithProperties {
            public WithCreate withProperties(BackendProperties var1);
        }

        public static interface WithResourceId {
            public WithCreate withResourceId(String var1);
        }

        public static interface WithDescription {
            public WithCreate withDescription(String var1);
        }

        public static interface WithTitle {
            public WithCreate withTitle(String var1);
        }

        public static interface WithProtocol {
            public WithCreate withProtocol(BackendProtocol var1);
        }

        public static interface WithUrl {
            public WithCreate withUrl(String var1);
        }

        public static interface WithCreate
        extends WithUrl,
        WithProtocol,
        WithTitle,
        WithDescription,
        WithResourceId,
        WithProperties,
        WithCredentials,
        WithProxy,
        WithTls,
        WithIfMatch {
            public BackendContract create();

            public BackendContract create(Context var1);
        }

        public static interface WithParentResource {
            public WithCreate withExistingService(String var1, String var2);
        }

        public static interface Blank
        extends WithParentResource {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithParentResource,
    DefinitionStages.WithCreate {
    }
}

