/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.apimanagement.models.X509CertificateName;
import java.io.IOException;
import java.util.List;

public final class BackendServiceFabricClusterProperties
implements JsonSerializable<BackendServiceFabricClusterProperties> {
    private String clientCertificateId;
    private String clientCertificatethumbprint;
    private Integer maxPartitionResolutionRetries;
    private List<String> managementEndpoints;
    private List<String> serverCertificateThumbprints;
    private List<X509CertificateName> serverX509Names;
    private static final ClientLogger LOGGER = new ClientLogger(BackendServiceFabricClusterProperties.class);

    public String clientCertificateId() {
        return this.clientCertificateId;
    }

    public BackendServiceFabricClusterProperties withClientCertificateId(String clientCertificateId) {
        this.clientCertificateId = clientCertificateId;
        return this;
    }

    public String clientCertificatethumbprint() {
        return this.clientCertificatethumbprint;
    }

    public BackendServiceFabricClusterProperties withClientCertificatethumbprint(String clientCertificatethumbprint) {
        this.clientCertificatethumbprint = clientCertificatethumbprint;
        return this;
    }

    public Integer maxPartitionResolutionRetries() {
        return this.maxPartitionResolutionRetries;
    }

    public BackendServiceFabricClusterProperties withMaxPartitionResolutionRetries(Integer maxPartitionResolutionRetries) {
        this.maxPartitionResolutionRetries = maxPartitionResolutionRetries;
        return this;
    }

    public List<String> managementEndpoints() {
        return this.managementEndpoints;
    }

    public BackendServiceFabricClusterProperties withManagementEndpoints(List<String> managementEndpoints) {
        this.managementEndpoints = managementEndpoints;
        return this;
    }

    public List<String> serverCertificateThumbprints() {
        return this.serverCertificateThumbprints;
    }

    public BackendServiceFabricClusterProperties withServerCertificateThumbprints(List<String> serverCertificateThumbprints) {
        this.serverCertificateThumbprints = serverCertificateThumbprints;
        return this;
    }

    public List<X509CertificateName> serverX509Names() {
        return this.serverX509Names;
    }

    public BackendServiceFabricClusterProperties withServerX509Names(List<X509CertificateName> serverX509Names) {
        this.serverX509Names = serverX509Names;
        return this;
    }

    public void validate() {
        if (this.managementEndpoints() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property managementEndpoints in model BackendServiceFabricClusterProperties"));
        }
        if (this.serverX509Names() != null) {
            this.serverX509Names().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("managementEndpoints", this.managementEndpoints, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("clientCertificateId", this.clientCertificateId);
        jsonWriter.writeStringField("clientCertificatethumbprint", this.clientCertificatethumbprint);
        jsonWriter.writeNumberField("maxPartitionResolutionRetries", (Number)this.maxPartitionResolutionRetries);
        jsonWriter.writeArrayField("serverCertificateThumbprints", this.serverCertificateThumbprints, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("serverX509Names", this.serverX509Names, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static BackendServiceFabricClusterProperties fromJson(JsonReader jsonReader) throws IOException {
        return (BackendServiceFabricClusterProperties)jsonReader.readObject(reader -> {
            BackendServiceFabricClusterProperties deserializedBackendServiceFabricClusterProperties = new BackendServiceFabricClusterProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("managementEndpoints".equals(fieldName)) {
                    List managementEndpoints;
                    deserializedBackendServiceFabricClusterProperties.managementEndpoints = managementEndpoints = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("clientCertificateId".equals(fieldName)) {
                    deserializedBackendServiceFabricClusterProperties.clientCertificateId = reader.getString();
                    continue;
                }
                if ("clientCertificatethumbprint".equals(fieldName)) {
                    deserializedBackendServiceFabricClusterProperties.clientCertificatethumbprint = reader.getString();
                    continue;
                }
                if ("maxPartitionResolutionRetries".equals(fieldName)) {
                    deserializedBackendServiceFabricClusterProperties.maxPartitionResolutionRetries = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("serverCertificateThumbprints".equals(fieldName)) {
                    List serverCertificateThumbprints;
                    deserializedBackendServiceFabricClusterProperties.serverCertificateThumbprints = serverCertificateThumbprints = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("serverX509Names".equals(fieldName)) {
                    List serverX509Names;
                    deserializedBackendServiceFabricClusterProperties.serverX509Names = serverX509Names = reader.readArray(reader1 -> X509CertificateName.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedBackendServiceFabricClusterProperties;
        });
    }
}

