/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.apimanagement.models.CertificateConfigurationStoreName;
import com.azure.resourcemanager.apimanagement.models.CertificateInformation;
import java.io.IOException;

public final class CertificateConfiguration
implements JsonSerializable<CertificateConfiguration> {
    private String encodedCertificate;
    private String certificatePassword;
    private CertificateConfigurationStoreName storeName;
    private CertificateInformation certificate;
    private static final ClientLogger LOGGER = new ClientLogger(CertificateConfiguration.class);

    public String encodedCertificate() {
        return this.encodedCertificate;
    }

    public CertificateConfiguration withEncodedCertificate(String encodedCertificate) {
        this.encodedCertificate = encodedCertificate;
        return this;
    }

    public String certificatePassword() {
        return this.certificatePassword;
    }

    public CertificateConfiguration withCertificatePassword(String certificatePassword) {
        this.certificatePassword = certificatePassword;
        return this;
    }

    public CertificateConfigurationStoreName storeName() {
        return this.storeName;
    }

    public CertificateConfiguration withStoreName(CertificateConfigurationStoreName storeName) {
        this.storeName = storeName;
        return this;
    }

    public CertificateInformation certificate() {
        return this.certificate;
    }

    public CertificateConfiguration withCertificate(CertificateInformation certificate) {
        this.certificate = certificate;
        return this;
    }

    public void validate() {
        if (this.storeName() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property storeName in model CertificateConfiguration"));
        }
        if (this.certificate() != null) {
            this.certificate().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("storeName", this.storeName == null ? null : this.storeName.toString());
        jsonWriter.writeStringField("encodedCertificate", this.encodedCertificate);
        jsonWriter.writeStringField("certificatePassword", this.certificatePassword);
        jsonWriter.writeJsonField("certificate", (JsonSerializable)this.certificate);
        return jsonWriter.writeEndObject();
    }

    public static CertificateConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return (CertificateConfiguration)jsonReader.readObject(reader -> {
            CertificateConfiguration deserializedCertificateConfiguration = new CertificateConfiguration();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("storeName".equals(fieldName)) {
                    deserializedCertificateConfiguration.storeName = CertificateConfigurationStoreName.fromString(reader.getString());
                    continue;
                }
                if ("encodedCertificate".equals(fieldName)) {
                    deserializedCertificateConfiguration.encodedCertificate = reader.getString();
                    continue;
                }
                if ("certificatePassword".equals(fieldName)) {
                    deserializedCertificateConfiguration.certificatePassword = reader.getString();
                    continue;
                }
                if ("certificate".equals(fieldName)) {
                    deserializedCertificateConfiguration.certificate = CertificateInformation.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCertificateConfiguration;
        });
    }
}

